/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.send.InterfaceSendPacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class ComStmtExecute
implements InterfaceSendPacket {
    private final int parameterCount;
    private final ParameterHolder[] parameters;
    private final int statementId;
    private MariaDbType[] parameterTypeHeader;

    public ComStmtExecute(int statementId, ParameterHolder[] parameters, int parameterCount, MariaDbType[] parameterTypeHeader) {
        this.parameterCount = parameterCount;
        this.parameters = parameters;
        this.statementId = statementId;
        this.parameterTypeHeader = parameterTypeHeader;
    }

    @Override
    public void send(OutputStream os) throws IOException {
        PacketOutputStream buffer = (PacketOutputStream)os;
        buffer.startPacket(0, true);
        ComStmtExecute.writeCmd(this.statementId, this.parameters, this.parameterCount, this.parameterTypeHeader, buffer);
        buffer.finishPacketWithoutRelease(true);
        buffer.releaseBuffer();
    }

    public static void writeCmd(int statementId, ParameterHolder[] parameters, int parameterCount, MariaDbType[] parameterTypeHeader, PacketOutputStream pos) throws IOException {
        pos.buffer.put((byte)23);
        pos.buffer.putInt(statementId);
        pos.buffer.put((byte)0);
        pos.buffer.putInt(1);
        if (parameterCount > 0) {
            int i;
            int nullCount = (parameterCount + 7) / 8;
            pos.assureBufferCapacity(nullCount + 1);
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                if (!parameters[i2].isNullData()) continue;
                int n = i2 / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i2 % 8);
            }
            pos.buffer.put(nullBitsBuffer, 0, nullCount);
            boolean mustSendHeaderType = false;
            if (parameterCount == 0 || parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i = 0; i < parameterCount; ++i) {
                    if (parameterTypeHeader[i].equals((Object)parameters[i].getMariaDbType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            if (mustSendHeaderType) {
                pos.assureBufferCapacity(1 + parameterCount * 2);
                pos.buffer.put((byte)1);
                for (i = 0; i < parameterCount; ++i) {
                    parameterTypeHeader[i] = parameters[i].getMariaDbType();
                    pos.buffer.putShort((short)parameterTypeHeader[i].getType());
                }
            } else {
                pos.buffer.put((byte)0);
            }
        }
        for (int i = 0; i < parameterCount; ++i) {
            ParameterHolder holder = parameters[i];
            if (holder.isLongData() || holder.isNullData()) continue;
            ((NotLongDataParameter)holder).writeBinary(pos);
        }
    }
}

