/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU40;
import org.lwjgl.cuda.CUIPCEventHandle;
import org.lwjgl.cuda.CUIPCMemHandle;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CU41
extends CU40 {
    public static final int CU_IPC_HANDLE_SIZE = 64;
    public static final int CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS = 1;

    protected CU41() {
        throw new UnsupportedOperationException();
    }

    public static int ncuDeviceGetByPCIBusId(long dev, long pciBusId) {
        long __functionAddress = Functions.DeviceGetByPCIBusId;
        return JNI.callPPI((long)dev, (long)pciBusId, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetByPCIBusId(@NativeType(value="CUdevice *") IntBuffer dev, @NativeType(value="char const *") ByteBuffer pciBusId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dev, (int)1);
            Checks.checkNT1((ByteBuffer)pciBusId);
        }
        return CU41.ncuDeviceGetByPCIBusId(MemoryUtil.memAddress((IntBuffer)dev), MemoryUtil.memAddress((ByteBuffer)pciBusId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuDeviceGetByPCIBusId(@NativeType(value="CUdevice *") IntBuffer dev, @NativeType(value="char const *") CharSequence pciBusId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)dev, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pciBusId, true);
            long pciBusIdEncoded = stack.getPointerAddress();
            int n = CU41.ncuDeviceGetByPCIBusId(MemoryUtil.memAddress((IntBuffer)dev), pciBusIdEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int ncuDeviceGetPCIBusId(long pciBusId, int len, int dev) {
        long __functionAddress = Functions.DeviceGetPCIBusId;
        return JNI.callPI((long)pciBusId, (int)len, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetPCIBusId(@NativeType(value="char *") ByteBuffer pciBusId, @NativeType(value="CUdevice") int dev) {
        return CU41.ncuDeviceGetPCIBusId(MemoryUtil.memAddress((ByteBuffer)pciBusId), pciBusId.remaining(), dev);
    }

    public static int ncuIpcGetEventHandle(long pHandle, long event) {
        long __functionAddress = Functions.IpcGetEventHandle;
        if (Checks.CHECKS) {
            Checks.check((long)event);
        }
        return JNI.callPPI((long)pHandle, (long)event, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuIpcGetEventHandle(@NativeType(value="CUipcEventHandle *") CUIPCEventHandle pHandle, @NativeType(value="CUevent") long event) {
        return CU41.ncuIpcGetEventHandle(pHandle.address(), event);
    }

    public static int ncuIpcOpenEventHandle(long phEvent, long handle) {
        long __functionAddress = Functions.IpcOpenEventHandle;
        return JNI.callPPI((long)phEvent, (long)handle, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuIpcOpenEventHandle(@NativeType(value="CUevent *") PointerBuffer phEvent, @NativeType(value="CUipcEventHandle") CUIPCEventHandle handle) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phEvent, (int)1);
        }
        return CU41.ncuIpcOpenEventHandle(MemoryUtil.memAddress((CustomBuffer)phEvent), handle.address());
    }

    public static int ncuIpcGetMemHandle(long pHandle, long dptr) {
        long __functionAddress = Functions.IpcGetMemHandle;
        if (Checks.CHECKS) {
            Checks.check((long)dptr);
        }
        return JNI.callPPI((long)pHandle, (long)dptr, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuIpcGetMemHandle(@NativeType(value="CUipcMemHandle *") CUIPCMemHandle pHandle, @NativeType(value="CUdeviceptr") long dptr) {
        return CU41.ncuIpcGetMemHandle(pHandle.address(), dptr);
    }

    public static int ncuIpcOpenMemHandle(long pdptr, long handle, int Flags) {
        long __functionAddress = Functions.IpcOpenMemHandle;
        return JNI.callPPI((long)pdptr, (long)handle, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuIpcOpenMemHandle(@NativeType(value="CUdeviceptr *") PointerBuffer pdptr, @NativeType(value="CUipcMemHandle") CUIPCMemHandle handle, @NativeType(value="unsigned int") int Flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pdptr, (int)1);
        }
        return CU41.ncuIpcOpenMemHandle(MemoryUtil.memAddress((CustomBuffer)pdptr), handle.address(), Flags);
    }

    @NativeType(value="CUresult")
    public static int cuIpcCloseMemHandle(@NativeType(value="CUdeviceptr") long dptr) {
        long __functionAddress = Functions.IpcCloseMemHandle;
        if (Checks.CHECKS) {
            Checks.check((long)dptr);
        }
        return JNI.callPI((long)dptr, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long DeviceGetByPCIBusId = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDeviceGetByPCIBusId");
        public static final long DeviceGetPCIBusId = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDeviceGetPCIBusId");
        public static final long IpcGetEventHandle = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuIpcGetEventHandle");
        public static final long IpcOpenEventHandle = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuIpcOpenEventHandle");
        public static final long IpcGetMemHandle = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuIpcGetMemHandle");
        public static final long IpcOpenMemHandle = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuIpcOpenMemHandle");
        public static final long IpcCloseMemHandle = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuIpcCloseMemHandle");

        private Functions() {
        }
    }
}

