/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.Job;
import hudson.tasks.LogRotator;
import java.io.IOException;
import java.util.logging.Logger;

final class LinkedLogRotator
extends LogRotator {
    private static final Logger LOGGER = Logger.getLogger(LinkedLogRotator.class.getName());

    LinkedLogRotator(int artifactDaysToKeep, int artifactNumToKeep) {
        super(-1, -1, artifactDaysToKeep, artifactNumToKeep);
    }

    LinkedLogRotator() {
        super(-1, -1, -1, -1);
    }

    public void perform(Job _job) throws IOException, InterruptedException {
        super.perform(_job);
        MatrixConfiguration job = (MatrixConfiguration)_job;
        for (MatrixRun r : (MatrixRun[])job.getBuilds().toArray((Object[])new MatrixRun[0])) {
            if (job.getParent().getBuildByNumber(r.getNumber()) != null) continue;
            LOGGER.fine("Deleting " + r.getFullDisplayName());
            r.delete();
        }
        if (!job.isActiveConfiguration() && job.getLastBuild() == null) {
            LOGGER.fine("Deleting " + job.getFullDisplayName() + " because the configuration is inactive and there's no builds");
            job.delete();
        }
    }
}

