/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.FileBuildParameters;
import com.tikal.jenkins.plugins.multijob.MultiJobBuilder;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.ParserRuleFile;
import com.tikal.jenkins.plugins.multijob.PredefinedBuildParameters;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.FileParameterValue;
import hudson.model.Hudson;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseJobsConfig
implements Describable<PhaseJobsConfig> {
    private String jobName;
    private String jobProperties;
    private boolean currParams;
    private boolean exposedSCM;
    private boolean disableJob;
    private String parsingRulesPath;
    private int maxRetries;
    private boolean enableRetryStrategy;
    private boolean enableCondition;
    private boolean abortAllJob;
    private String condition;
    private List<AbstractBuildParameters> configs;
    private KillPhaseOnJobResultCondition killPhaseOnJobResultCondition = KillPhaseOnJobResultCondition.NEVER;
    private boolean buildOnlyIfSCMChanges = false;

    public boolean isBuildOnlyIfSCMChanges() {
        return this.buildOnlyIfSCMChanges;
    }

    public void setBuildOnlyIfSCMChanges(boolean triggerOnlyIfSCMChanges) {
        this.buildOnlyIfSCMChanges = triggerOnlyIfSCMChanges;
    }

    public void setParsingRulesPath(String parsingRulesPath) {
        this.parsingRulesPath = parsingRulesPath;
    }

    public String getParsingRulesPath() {
        return this.parsingRulesPath;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setEnableRetryStrategy(boolean enableRetryStrategy) {
        this.enableRetryStrategy = enableRetryStrategy;
    }

    public boolean getEnableRetryStrategy() {
        return this.enableRetryStrategy;
    }

    public void setEnableCondition(boolean enableCondition) {
        this.enableCondition = enableCondition;
    }

    public boolean getEnableCondition() {
        return this.enableCondition;
    }

    public void setAbortAllJob(boolean abortAllJob) {
        this.abortAllJob = abortAllJob;
    }

    public boolean getAbortAllJob() {
        return this.abortAllJob;
    }

    public boolean isDisableJob() {
        return this.disableJob;
    }

    public void setDisableJob(boolean disableJob) {
        this.disableJob = disableJob;
    }

    public KillPhaseOnJobResultCondition getKillPhaseOnJobResultCondition() {
        return this.killPhaseOnJobResultCondition;
    }

    public void setKillPhaseOnJobResultCondition(KillPhaseOnJobResultCondition killPhaseOnJobResultCondition) {
        this.killPhaseOnJobResultCondition = killPhaseOnJobResultCondition;
    }

    public boolean isExposedSCM() {
        return this.exposedSCM;
    }

    public void setExposedSCM(boolean exposedSCM) {
        this.exposedSCM = exposedSCM;
    }

    public boolean isCurrParams() {
        return this.currParams;
    }

    public void setCurrParams(boolean currParams) {
        this.currParams = currParams;
    }

    public String getJobProperties() {
        return this.jobProperties;
    }

    public void setJobProperties(String jobProperties) {
        this.jobProperties = jobProperties;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Descriptor<PhaseJobsConfig> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }

    @DataBoundConstructor
    public PhaseJobsConfig(String jobName, String jobProperties, boolean currParams, List<AbstractBuildParameters> configs, KillPhaseOnJobResultCondition killPhaseOnJobResultCondition, boolean disableJob, boolean enableRetryStrategy, String parsingRulesPath, int maxRetries, boolean enableCondition, boolean abortAllJob, String condition, boolean buildOnlyIfSCMChanges) {
        this.jobName = jobName;
        this.jobProperties = jobProperties;
        this.currParams = currParams;
        this.killPhaseOnJobResultCondition = killPhaseOnJobResultCondition;
        this.disableJob = disableJob;
        this.configs = Util.fixNull(configs);
        this.enableRetryStrategy = enableRetryStrategy;
        this.maxRetries = maxRetries;
        if (this.maxRetries < 0) {
            this.maxRetries = 0;
        }
        this.parsingRulesPath = Util.fixNull((String)parsingRulesPath);
        this.enableCondition = enableCondition;
        this.abortAllJob = abortAllJob;
        this.condition = Util.fixNull((String)condition);
        this.buildOnlyIfSCMChanges = buildOnlyIfSCMChanges;
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public List<ParameterValue> getJobParameters(AbstractBuild<?, ?> build, TaskListener listener) {
        ParametersAction action = (ParametersAction)build.getAction(ParametersAction.class);
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>(action.getParameters().size());
        if (action != null) {
            for (ParameterValue value : action.getParameters()) {
                if (value instanceof FileParameterValue) continue;
                values.add(value);
            }
        }
        return values;
    }

    private static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            if (param == null) continue;
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    public List<Action> getActions(AbstractBuild build, TaskListener listener, AbstractProject project, boolean isCurrentInclude) throws IOException, InterruptedException {
        ArrayList<Action> actions = new ArrayList<Action>();
        ParametersAction params = null;
        LinkedList<ParameterValue> paramsValuesList = new LinkedList<ParameterValue>();
        List originalActions = project.getActions();
        ParametersDefinitionProperty parameters = null;
        for (Object object : originalActions) {
            if (!(object instanceof ParametersDefinitionProperty)) continue;
            parameters = (ParametersDefinitionProperty)object;
        }
        if (parameters != null) {
            for (ParameterDefinition parameterdef : parameters.getParameterDefinitions()) {
                if (parameterdef.getDefaultParameterValue() == null) continue;
                paramsValuesList.add(parameterdef.getDefaultParameterValue());
            }
            params = new ParametersAction(paramsValuesList.toArray(new ParameterValue[paramsValuesList.size()]));
        }
        if (isCurrentInclude) {
            ParametersAction defaultParameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (params != null && defaultParameters != null) {
                params = PhaseJobsConfig.mergeParameters(params, defaultParameters);
            } else if (params == null) {
                params = defaultParameters;
            }
        }
        if (this.configs != null) {
            for (AbstractBuildParameters config : this.configs) {
                try {
                    Action a = config.getAction(build, listener);
                    if (a instanceof ParametersAction) {
                        params = params == null ? (ParametersAction)a : PhaseJobsConfig.mergeParameters(params, (ParametersAction)a);
                        continue;
                    }
                    if (a == null) continue;
                    actions.add(a);
                }
                catch (AbstractBuildParameters.DontTriggerException e) {
                    listener.getLogger().println("[multiJob] DontTriggerException: " + (Object)((Object)e));
                }
            }
        }
        if (params != null) {
            actions.add((Action)params);
        }
        return actions;
    }

    public boolean hasProperties() {
        return this.jobProperties != null && !this.jobProperties.isEmpty();
    }

    public Object readResolve() {
        if (this.hasProperties()) {
            hudson.plugins.parameterizedtrigger.PredefinedBuildParameters buildParameters = new hudson.plugins.parameterizedtrigger.PredefinedBuildParameters(this.jobProperties);
            if (this.configs == null) {
                this.configs = new ArrayList<AbstractBuildParameters>();
            }
            this.configs.add((AbstractBuildParameters)buildParameters);
        }
        ArrayList<Object> oldParams = new ArrayList<Object>();
        if (this.configs != null && this.configs.size() > 0) {
            Iterator<AbstractBuildParameters> parametersIterator = this.configs.iterator();
            while (parametersIterator.hasNext()) {
                AbstractBuildParameters param = parametersIterator.next();
                if (param instanceof PredefinedBuildParameters) {
                    PredefinedBuildParameters previosStringParam = (PredefinedBuildParameters)param;
                    parametersIterator.remove();
                    oldParams.add(new hudson.plugins.parameterizedtrigger.PredefinedBuildParameters(previosStringParam.getJobProperties()));
                    continue;
                }
                if (!(param instanceof FileBuildParameters)) continue;
                FileBuildParameters previosFileParam = (FileBuildParameters)param;
                parametersIterator.remove();
                oldParams.add(new hudson.plugins.parameterizedtrigger.FileBuildParameters(previosFileParam.getPropertiesFile()));
            }
            this.configs.addAll(oldParams);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KillPhaseOnJobResultCondition {
        FAILURE("Failure (stop the phase execution if the job is failed)"){

            public boolean isKillPhase(Result result) {
                return result.isWorseOrEqualTo(Result.FAILURE);
            }
        }
        ,
        NEVER("Never (ignore the job result and continue the phase execution)"){

            public boolean isKillPhase(Result result) {
                return result.equals(Result.ABORTED);
            }
        }
        ,
        UNSTABLE("Unstable (stop the phase execution if the job is unstable)"){

            public boolean isKillPhase(Result result) {
                return result.isWorseOrEqualTo(Result.UNSTABLE);
            }
        };

        private final String label;

        public abstract boolean isKillPhase(Result var1);

        private KillPhaseOnJobResultCondition(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<PhaseJobsConfig> {
        private ParserRuleFile[] parsingRulesGlobal = new ParserRuleFile[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Phase Jobs Config";
        }

        public List<Descriptor<AbstractBuildParameters>> getBuilderConfigDescriptors() {
            return Hudson.getInstance().getDescriptorList(AbstractBuildParameters.class);
        }

        public AutoCompletionCandidates doAutoCompleteJobName(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            for (String localJobName : Hudson.getInstance().getJobNames()) {
                if (!localJobName.toLowerCase().startsWith(value.toLowerCase())) continue;
                c.add(localJobName);
            }
            return c;
        }

        private void savePhaseJobConfigParameters(String localJobName) {
            MultiJobProject parentProject;
            List builders;
            AbstractProject project = (AbstractProject)Jenkins.getInstance().getItemByFullName(localJobName);
            List<ParameterDefinition> parameterDefinitions = this.getParameterDefinition(project);
            StringBuilder sb = new StringBuilder();
            for (ParameterDefinition pdef : parameterDefinitions) {
                String paramValue = null;
                if (pdef instanceof StringParameterDefinition) {
                    StringParameterDefinition stringParameterDefinition = (StringParameterDefinition)pdef;
                    paramValue = stringParameterDefinition.getDefaultParameterValue().value;
                } else if (pdef instanceof BooleanParameterDefinition) {
                    BooleanParameterDefinition booleanParameterDefinition = (BooleanParameterDefinition)pdef;
                    paramValue = String.valueOf(booleanParameterDefinition.getDefaultParameterValue().value);
                }
                sb.append(pdef.getName()).append("=").append(paramValue).append("\n");
            }
            AbstractProject item = this.getCurrentJob();
            if (item instanceof MultiJobProject && (builders = (parentProject = (MultiJobProject)item).getBuilders()) != null) {
                for (Builder builder : builders) {
                    if (!(builder instanceof MultiJobBuilder)) continue;
                    MultiJobBuilder multiJobBuilder = (MultiJobBuilder)builder;
                    List<PhaseJobsConfig> phaseJobs = multiJobBuilder.getPhaseJobs();
                    for (PhaseJobsConfig phaseJob : phaseJobs) {
                        if (!phaseJob.getJobName().equals(localJobName)) continue;
                        phaseJob.setJobProperties(sb.toString());
                        this.save();
                    }
                }
            }
        }

        private AbstractProject getCurrentJob() {
            String nameUrl = Descriptor.getCurrentDescriptorByNameUrl();
            String jobName = nameUrl.substring(nameUrl.lastIndexOf("/") + 1);
            return (AbstractProject)Jenkins.getInstance().getItemByFullName(jobName);
        }

        public List<ParameterDefinition> getParameterDefinition(AbstractProject project) {
            ArrayList<ParameterDefinition> list = new ArrayList<ParameterDefinition>();
            Map map = project.getProperties();
            for (Map.Entry entry : map.entrySet()) {
                JobProperty property = (JobProperty)entry.getValue();
                if (!(property instanceof ParametersDefinitionProperty)) continue;
                ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)property;
                for (ParameterDefinition parameterDefinition : pdp.getParameterDefinitions()) {
                    if (!(parameterDefinition instanceof StringParameterDefinition) && !(parameterDefinition instanceof BooleanParameterDefinition) && !(parameterDefinition instanceof ChoiceParameterDefinition)) continue;
                    list.add(parameterDefinition);
                }
            }
            return list;
        }

        public String doFillJobProperties(@QueryParameter String jobName) {
            return "fill=in";
        }

        public ParserRuleFile[] getParsingRulesGlobal() {
            return this.parsingRulesGlobal;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.parsingRulesGlobal = req.bindParametersToList(ParserRuleFile.class, "jenkins-multijob-plugin.").toArray(new ParserRuleFile[0]);
            this.save();
            return true;
        }
    }
}

