/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class Which {
    private static final Logger LOGGER = Logger.getLogger(Which.class.getName());

    public static URL classFileUrl(Class clazz) throws IOException {
        URL res;
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((res = cl.getResource(clazz.getName().replace('.', '/') + ".class")) == null) {
            throw new IllegalArgumentException("Unable to locate class file for " + clazz);
        }
        return res;
    }

    public static URL jarURL(Class clazz) throws IOException {
        return Which.classFileUrl(clazz);
    }

    public static File jarFile(Class clazz) throws IOException {
        return Which.jarFile(Which.classFileUrl(clazz), clazz.getName().replace('.', '/') + ".class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static File jarFile(URL res, String qualifiedName) throws IOException {
        URLConnection con;
        String originalURL;
        String resURL;
        block24: {
            originalURL = resURL = res.toExternalForm();
            if (resURL.startsWith("jar:file:")) return Which.fromJarUrlToFile(resURL);
            if (resURL.startsWith("wsjar:file:")) {
                return Which.fromJarUrlToFile(resURL);
            }
            if (resURL.startsWith("code-source:/")) {
                resURL = resURL.substring("code-source:/".length(), resURL.lastIndexOf(33));
                return new File(Which.decode(new URL("file:/" + resURL).getPath()));
            }
            if (resURL.startsWith("zip:")) {
                resURL = resURL.substring("zip:".length(), resURL.lastIndexOf(33));
                return new File(Which.decode(new URL("file:" + resURL).getPath()));
            }
            if (resURL.startsWith("file:")) {
                int n = qualifiedName.split("/").length;
                while (n > 0) {
                    int idx = Math.max(resURL.lastIndexOf(47), resURL.lastIndexOf(92));
                    if (idx < 0) {
                        throw new IllegalArgumentException(originalURL + " - " + resURL);
                    }
                    resURL = resURL.substring(0, idx);
                    --n;
                }
                return new File(Which.decode(new URL(resURL).getPath()));
            }
            if (resURL.startsWith("vfszip:")) {
                File file;
                InputStream is = res.openStream();
                try {
                    Object var10_22;
                    try {
                        Field f;
                        Object delegate = is;
                        while (delegate.getClass().getEnclosingClass() != ZipFile.class) {
                            f = delegate.getClass().getDeclaredField("delegate");
                            f.setAccessible(true);
                            if (!(delegate = f.get(delegate)).getClass().getName().equals("java.util.jar.JarVerifier$VerifierStream")) continue;
                            f = delegate.getClass().getDeclaredField("is");
                            f.setAccessible(true);
                            delegate = f.get(delegate);
                        }
                        f = delegate.getClass().getDeclaredField("this$0");
                        f.setAccessible(true);
                        ZipFile zipFile = (ZipFile)f.get(delegate);
                        file = new File(zipFile.getName());
                        Object var10_21 = null;
                    }
                    catch (NoSuchFieldException e) {
                        LOGGER.log(Level.FINE, "Failed to resolve vfszip into a jar location", e);
                        var10_22 = null;
                        is.close();
                        break block24;
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.log(Level.FINE, "Failed to resolve vfszip into a jar location", e);
                        var10_22 = null;
                        is.close();
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_23 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                return file;
            }
        }
        if (resURL.startsWith("vfs:")) {
            String dotdot = "";
            for (int i = qualifiedName.split("/").length; i > 1; --i) {
                dotdot = dotdot + "../";
            }
            try {
                URL jar = new URL(res, dotdot);
                String path = jar.getPath();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                String fileName = path.substring(path.lastIndexOf(47) + 1);
                Object vfs = new URL(jar, "..").getContent();
                File dir = (File)vfs.getClass().getMethod("getPhysicalFile", new Class[0]).invoke(vfs, new Object[0]);
                File jarFile = new File(dir, fileName);
                if (jarFile.exists()) {
                    return jarFile;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to resolve vfs file into a location", e);
            }
        }
        if (!((con = res.openConnection()) instanceof JarURLConnection)) throw new IllegalArgumentException(originalURL + " - " + resURL);
        JarURLConnection jcon = (JarURLConnection)con;
        JarFile jarFile = jcon.getJarFile();
        if (jarFile == null) throw new IllegalArgumentException(originalURL + " - " + resURL);
        String n = jarFile.getName();
        if (n.length() > 0) {
            return new File(n);
        }
        try {
            Field f = ZipFile.class.getDeclaredField("name");
            f.setAccessible(true);
            return new File((String)f.get(jarFile));
        }
        catch (NoSuchFieldException e) {
            LOGGER.log(Level.INFO, "Failed to obtain the local cache file name of " + resURL, e);
            throw new IllegalArgumentException(originalURL + " - " + resURL);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, "Failed to obtain the local cache file name of " + resURL, e);
        }
        throw new IllegalArgumentException(originalURL + " - " + resURL);
    }

    public static File jarFile(URL resource) throws IOException {
        return Which.fromJarUrlToFile(resource.toExternalForm());
    }

    private static File fromJarUrlToFile(String resURL) throws MalformedURLException {
        resURL = resURL.substring(resURL.indexOf(58) + 1, resURL.lastIndexOf(33));
        return new File(Which.decode(new URL(resURL).getPath()));
    }

    private static String decode(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '%') {
                baos.write(Which.hexToInt(s.charAt(i + 1)) * 16 + Which.hexToInt(s.charAt(i + 2)));
                i += 2;
                continue;
            }
            baos.write(ch);
        }
        try {
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static int hexToInt(int ch) {
        return Character.getNumericValue(ch);
    }
}

