/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SynchronousExecutorService
extends AbstractExecutorService {
    private volatile boolean shutdown = false;
    private int count = 0;

    SynchronousExecutorService() {
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.shutdown && this.count == 0;
    }

    @Override
    public synchronized boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.count != 0) {
            long d = end - System.currentTimeMillis();
            if (d < 0L) {
                return false;
            }
            this.wait(d);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        if (this.shutdown) {
            throw new IllegalStateException("Already shut down");
        }
        this.touchCount(1);
        try {
            command.run();
            Object var3_2 = null;
            this.touchCount(-1);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.touchCount(-1);
            throw throwable;
        }
    }

    private synchronized void touchCount(int diff) {
        this.count += diff;
        if (this.count == 0) {
            this.notifyAll();
        }
    }
}

