/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.Future;
import hudson.remoting.RemotingSystemException;
import hudson.remoting.RequestAbortedException;
import hudson.remoting.Response;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Request<RSP extends Serializable, EXC extends Throwable>
extends Command {
    private final int id;
    private int lastIoId;
    private volatile Response<RSP, EXC> response;
    protected volatile transient java.util.concurrent.Future<?> future;
    volatile transient int responseIoId;
    volatile transient java.util.concurrent.Future<?> lastIo;
    private static int nextId = 0;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Request.class.getName());
    public static boolean chainCause = Boolean.getBoolean(Request.class.getName() + ".chainCause");
    static ThreadLocal<Request> CURRENT = new ThreadLocal();

    protected abstract RSP perform(Channel var1) throws EXC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request() {
        Class<Request> clazz = Request.class;
        synchronized (Request.class) {
            this.id = nextId++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RSP call(Channel channel) throws EXC, InterruptedException, IOException {
        Object object;
        this.lastIoId = channel.lastIoId();
        Object object2 = channel;
        synchronized (object2) {
            object = this;
            synchronized (object) {
                this.response = null;
                channel.pendingCalls.put(this.id, this);
                channel.send(this);
            }
        }
        try {
            object2 = this;
            synchronized (object2) {
                Thread t = Thread.currentThread();
                String name = t.getName();
                try {
                    t.setName(name + " / waiting for " + channel);
                    while (this.response == null && !channel.isInClosed()) {
                        this.wait(30000L);
                    }
                    if (this.response == null) {
                        throw new RequestAbortedException(null);
                    }
                }
                finally {
                    t.setName(name);
                }
                if (this.lastIo != null) {
                    try {
                        this.lastIo.get();
                    }
                    catch (ExecutionException e) {
                        // empty catch block
                    }
                }
                try {
                    channel.pipeWriter.get(this.responseIoId).get();
                }
                catch (ExecutionException e) {
                    // empty catch block
                }
                Object exc = this.response.exception;
                if (exc != null) {
                    if (exc instanceof RemotingSystemException) {
                        throw ((RemotingSystemException)exc).wrapForRethrow();
                    }
                    throw (Throwable)exc;
                }
                return (RSP)((Serializable)this.response.returnValue);
            }
        }
        catch (InterruptedException e) {
            object = channel;
            synchronized (object) {
                if (!channel.isOutClosed()) {
                    channel.send(new Cancel(this.id));
                }
            }
            throw e;
        }
    }

    public final Future<RSP> callAsync(final Channel channel) throws IOException {
        this.response = null;
        this.lastIoId = channel.lastIoId();
        channel.pendingCalls.put(this.id, this);
        channel.send(this);
        return new Future<RSP>(){
            private volatile boolean cancelled;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.cancelled || this.isDone()) {
                    return false;
                }
                this.cancelled = true;
                if (mayInterruptIfRunning) {
                    try {
                        channel.send(new Cancel(Request.this.id));
                    }
                    catch (IOException x) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled;
            }

            @Override
            public boolean isDone() {
                return this.isCancelled() || Request.this.response != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RSP get() throws InterruptedException, ExecutionException {
                Request request = Request.this;
                synchronized (request) {
                    try {
                        while (Request.this.response == null) {
                            if (this.isCancelled()) {
                                throw new CancellationException();
                            }
                            Request.this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        try {
                            channel.send(new Cancel(Request.this.id));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw e;
                    }
                    if (((Request)Request.this).response.exception != null) {
                        throw new ExecutionException((Throwable)((Request)Request.this).response.exception);
                    }
                    return (Serializable)((Request)Request.this).response.returnValue;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RSP get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Request request = Request.this;
                synchronized (request) {
                    long now;
                    long end = System.currentTimeMillis() + unit.toMillis(timeout);
                    while (Request.this.response == null && (now = System.currentTimeMillis()) < end) {
                        if (this.isCancelled()) {
                            throw new CancellationException();
                        }
                        Request.this.wait(Math.max(1L, end - now));
                    }
                    if (Request.this.response == null) {
                        throw new TimeoutException();
                    }
                    if (((Request)Request.this).response.exception != null) {
                        throw new ExecutionException((Throwable)((Request)Request.this).response.exception);
                    }
                    return (Serializable)((Request)Request.this).response.returnValue;
                }
            }
        };
    }

    synchronized void onCompleted(Response<RSP, EXC> response) {
        this.response = response;
        this.notifyAll();
    }

    void abort(IOException e) {
        this.onCompleted(new Response(this.id, 0, new RequestAbortedException(e)));
    }

    @Override
    protected final void execute(final Channel channel) {
        channel.executingCalls.put(this.id, this);
        this.future = channel.executor.submit(new Runnable(){
            private int startIoId;

            private int calcLastIoId() {
                int endIoId = channel.lastIoId();
                if (this.startIoId == endIoId) {
                    return 0;
                }
                return endIoId;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String oldThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName(oldThreadName + " for " + channel.getName());
                try {
                    Response rsp;
                    CURRENT.set(Request.this);
                    this.startIoId = channel.lastIoId();
                    try {
                        channel.pipeWriter.get(Request.this.lastIoId).get();
                        Object r = Request.this.perform(channel);
                        rsp = new Response(Request.this.id, this.calcLastIoId(), r);
                    }
                    catch (Throwable t) {
                        rsp = new Response(Request.this.id, this.calcLastIoId(), t);
                    }
                    finally {
                        CURRENT.set(null);
                    }
                    if (chainCause) {
                        rsp.createdAt.initCause(Request.this.createdAt);
                    }
                    Channel channel2 = channel;
                    synchronized (channel2) {
                        if (!channel.isOutClosed()) {
                            channel.send(rsp);
                        }
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to send back a reply", e);
                }
                finally {
                    channel.executingCalls.remove(Request.this.id);
                    Thread.currentThread().setName(oldThreadName);
                }
            }
        });
    }

    static int getCurrentRequestId() {
        Request r = CURRENT.get();
        return r != null ? r.id : 0;
    }

    private static final class Cancel
    extends Command {
        private final int id;

        Cancel(int id) {
            this.id = id;
        }

        protected void execute(Channel channel) {
            Request<?, ?> r = channel.executingCalls.get(this.id);
            if (r == null) {
                return;
            }
            java.util.concurrent.Future<?> f = r.future;
            if (f != null) {
                f.cancel(true);
            }
        }
    }
}

