/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.artifact.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVersionTransformation
extends AbstractLogEnabled
implements ArtifactTransformation {
    @Requirement
    protected RepositoryMetadataManager repositoryMetadataManager;
    protected WagonManager wagonManager;

    protected String resolveVersion(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws RepositoryMetadataResolutionException {
        Object metadata = !artifact.isSnapshot() || "LATEST".equals(artifact.getBaseVersion()) ? new ArtifactRepositoryMetadata(artifact) : new SnapshotArtifactRepositoryMetadata(artifact);
        this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, remoteRepositories, localRepository);
        artifact.addMetadata((ArtifactMetadata)metadata);
        Metadata repoMetadata = metadata.getMetadata();
        String version = null;
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            version = this.constructVersion(repoMetadata.getVersioning(), artifact.getBaseVersion());
        }
        if (version == null) {
            version = artifact.getBaseVersion();
        }
        if (this.getLogger().isDebugEnabled()) {
            if (!version.equals(artifact.getBaseVersion())) {
                String message = artifact.getArtifactId() + ": resolved to version " + version;
                message = artifact.getRepository() != null ? message + " from repository " + artifact.getRepository().getId() : message + " from local repository";
                this.getLogger().debug(message);
            } else {
                this.getLogger().debug(artifact.getArtifactId() + ": using locally installed snapshot");
            }
        }
        return version;
    }

    protected abstract String constructVersion(Versioning var1, String var2);
}

