/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.spel;

import java.io.Reader;
import java.util.List;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.spel.SpELRule;
import org.jeasy.rules.support.AbstractRuleFactory;
import org.jeasy.rules.support.RuleDefinition;
import org.jeasy.rules.support.reader.RuleDefinitionReader;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ParserContext;

public class SpELRuleFactory
extends AbstractRuleFactory {
    private final RuleDefinitionReader reader;
    private BeanResolver beanResolver;
    private ParserContext parserContext;

    public SpELRuleFactory(RuleDefinitionReader reader) {
        this(reader, ParserContext.TEMPLATE_EXPRESSION);
    }

    public SpELRuleFactory(RuleDefinitionReader reader, ParserContext parserContext) {
        this.reader = reader;
        this.parserContext = parserContext;
    }

    public SpELRuleFactory(RuleDefinitionReader reader, BeanResolver beanResolver) {
        this.reader = reader;
        this.beanResolver = beanResolver;
    }

    public SpELRuleFactory(RuleDefinitionReader reader, ParserContext parserContext, BeanResolver beanResolver) {
        this.reader = reader;
        this.parserContext = parserContext;
        this.beanResolver = beanResolver;
    }

    public Rule createRule(Reader ruleDescriptor) throws Exception {
        List ruleDefinitions = this.reader.read(ruleDescriptor);
        if (ruleDefinitions.isEmpty()) {
            throw new IllegalArgumentException("rule descriptor is empty");
        }
        return this.createRule((RuleDefinition)ruleDefinitions.get(0));
    }

    public Rules createRules(Reader rulesDescriptor) throws Exception {
        Rules rules = new Rules(new Rule[0]);
        List ruleDefinitions = this.reader.read(rulesDescriptor);
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            rules.register(new Object[]{this.createRule(ruleDefinition)});
        }
        return rules;
    }

    protected Rule createSimpleRule(RuleDefinition ruleDefinition) {
        SpELRule spELRule = new SpELRule(this.parserContext, this.beanResolver).name(ruleDefinition.getName()).description(ruleDefinition.getDescription()).priority(ruleDefinition.getPriority()).when(ruleDefinition.getCondition());
        for (String action : ruleDefinition.getActions()) {
            spELRule.then(action);
        }
        return spELRule;
    }
}

