/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.spel;

import org.jeasy.rules.api.Condition;
import org.jeasy.rules.api.Facts;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpELCondition
implements Condition {
    private final ExpressionParser parser = new SpelExpressionParser();
    private final Expression compiledExpression;
    private BeanResolver beanResolver;

    public SpELCondition(String expression) {
        this(expression, ParserContext.TEMPLATE_EXPRESSION);
    }

    public SpELCondition(String expression, BeanResolver beanResolver) {
        this(expression, ParserContext.TEMPLATE_EXPRESSION, beanResolver);
    }

    public SpELCondition(String expression, ParserContext parserContext) {
        this.compiledExpression = this.parser.parseExpression(expression, parserContext);
    }

    public SpELCondition(String expression, ParserContext parserContext, BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
        this.compiledExpression = this.parser.parseExpression(expression, parserContext);
    }

    public boolean evaluate(Facts facts) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setRootObject((Object)facts.asMap());
        context.setVariables(facts.asMap());
        if (this.beanResolver != null) {
            context.setBeanResolver(this.beanResolver);
        }
        return (Boolean)this.compiledExpression.getValue((EvaluationContext)context, Boolean.class);
    }
}

