package org.jboss.threads;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.time.Duration;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.threads.StoppedExecutorException;
import org.jboss.logging.Logger;
import org.jboss.threads.InterruptHandler;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-03-07T14:33:41-0600")
public class Messages_$logger extends DelegatingBasicLogger implements Messages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    public Messages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void version(final String version) {
        super.log.logf(FQCN, INFO, null, version$str(), version);
    }
    protected String version$str() {
        return "JBoss Threads version %s";
    }
    protected String shutDownInitiated$str() {
        return "JBTHR00009: Executor has been shut down";
    }
    @Override
    public final org.jboss.threads.StoppedExecutorException shutDownInitiated() {
        final org.jboss.threads.StoppedExecutorException result = new org.jboss.threads.StoppedExecutorException(String.format(getLoggingLocale(), shutDownInitiated$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String cannotAwaitWithin$str() {
        return "JBTHR00012: Cannot await termination of a thread pool from one of its own threads";
    }
    @Override
    public final IllegalStateException cannotAwaitWithin() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAwaitWithin$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noInterruptHandlers$str() {
        return "JBTHR00103: The current thread does not support interrupt handlers";
    }
    @Override
    public final IllegalStateException noInterruptHandlers() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noInterruptHandlers$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void interruptHandlerThrew(final Throwable cause, final org.jboss.threads.InterruptHandler interruptHandler) {
        super.log.logf(FQCN, ERROR, cause, interruptHandlerThrew$str(), interruptHandler);
    }
    protected String interruptHandlerThrew$str() {
        return "JBTHR00108: Interrupt handler %s threw an exception";
    }
    protected String nonPositiveKeepAlive$str() {
        return "JBTHR00109: Keep-alive time must be positive but was %s";
    }
    @Override
    public final IllegalArgumentException nonPositiveKeepAlive(final Duration actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nonPositiveKeepAlive$str(), actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAllowedContainerManaged$str() {
        return "JBTHR00200: %s() not allowed on container-managed executor";
    }
    @Override
    public final SecurityException notAllowedContainerManaged(final String methodName) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), notAllowedContainerManaged$str(), methodName));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
