/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.Crypto;
import org.hsqldb.scriptio.ScriptWriterText;

public class ScriptWriterEncode
extends ScriptWriterText {
    Crypto crypto;
    HsqlByteArrayOutputStream byteOut;

    public ScriptWriterEncode(Database database, String string, boolean bl, Crypto crypto) {
        super(database, string, bl, true, false);
        try {
            this.fileStreamOut = crypto.getOutputStream(this.fileStreamOut);
            this.fileStreamOut = new GZIPOutputStream(this.fileStreamOut);
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, 26, new Object[]{iOException.getMessage(), this.outFile});
        }
    }

    public ScriptWriterEncode(Database database, String string, Crypto crypto) {
        super(database, string, false, false, false);
        this.crypto = crypto;
        this.byteOut = new HsqlByteArrayOutputStream();
    }

    protected void finishStream() throws IOException {
        if (this.fileStreamOut instanceof GZIPOutputStream) {
            ((GZIPOutputStream)this.fileStreamOut).finish();
        }
        this.fileStreamOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRowOutToFile() throws IOException {
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            if (this.byteOut == null) {
                super.writeRowOutToFile();
                return;
            }
            int n = this.crypto.getEncodedSize(this.rowOut.size());
            this.byteOut.ensureRoom(n + 4);
            n = this.crypto.encode(this.rowOut.getBuffer(), 0, this.rowOut.size(), this.byteOut.getBuffer(), 4);
            this.byteOut.setPosition(0);
            this.byteOut.writeInt(n);
            this.fileStreamOut.write(this.byteOut.getBuffer(), 0, n + 4);
        }
    }
}

