/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorClient
extends RowSetNavigator {
    public static final Object[][] emptyTable = new Object[0][];
    int currentOffset;
    int baseBlockSize;
    Object[][] table;

    public RowSetNavigatorClient() {
        this.table = emptyTable;
    }

    public RowSetNavigatorClient(int n) {
        this.table = new Object[n][];
    }

    public RowSetNavigatorClient(RowSetNavigator rowSetNavigator, int n, int n2) {
        this.size = rowSetNavigator.size;
        this.baseBlockSize = n2;
        this.currentOffset = n;
        this.table = new Object[n2][];
        rowSetNavigator.absolute(n);
        for (int i = 0; i < n2; ++i) {
            this.table[i] = rowSetNavigator.getCurrent();
            rowSetNavigator.next();
        }
        rowSetNavigator.beforeFirst();
    }

    public void setData(Object[][] objectArray) {
        this.table = objectArray;
        this.size = objectArray.length;
    }

    public void setData(int n, Object[] objectArray) {
        this.table[n] = objectArray;
    }

    public Object[] getData(int n) {
        return this.table[n];
    }

    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        if (this.currentPos == this.currentOffset + this.table.length) {
            this.getBlock(this.currentOffset + this.table.length);
        }
        return this.table[this.currentPos - this.currentOffset];
    }

    public Row getCurrentRow() {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    public void remove() {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    public void add(Object[] objectArray) {
        this.ensureCapacity();
        this.table[this.size] = objectArray;
        ++this.size;
    }

    public boolean addRow(Row row) {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    public void clear() {
        this.setData(emptyTable);
        this.reset();
    }

    public boolean absolute(int n) {
        if (n < 0) {
            n += this.size;
        }
        if (n < 0) {
            this.beforeFirst();
            return false;
        }
        if (n >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        this.currentPos = n;
        return true;
    }

    public void close() {
        if (this.session != null && (this.currentOffset != 0 || this.table.length != this.size)) {
            this.session.closeNavigator(this.id);
        }
    }

    public void readSimple(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
        this.size = rowInputInterface.readInt();
        if (this.table.length < this.size) {
            this.table = new Object[this.size][];
        }
        for (int i = 0; i < this.size; ++i) {
            this.table[i] = rowInputInterface.readData(resultMetaData.columnTypes);
        }
    }

    public void writeSimple(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws IOException {
        rowOutputInterface.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            Object[] objectArray = this.table[i];
            rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
    }

    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
        this.id = rowInputInterface.readLong();
        this.size = rowInputInterface.readInt();
        this.currentOffset = rowInputInterface.readInt();
        this.baseBlockSize = rowInputInterface.readInt();
        if (this.table.length < this.baseBlockSize) {
            this.table = new Object[this.baseBlockSize][];
        }
        for (int i = 0; i < this.baseBlockSize; ++i) {
            this.table[i] = rowInputInterface.readData(resultMetaData.columnTypes);
        }
    }

    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws HsqlException, IOException {
        int n = this.size - this.currentOffset;
        if (n > this.table.length) {
            n = this.table.length;
        }
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(this.currentOffset);
        rowOutputInterface.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.table[i];
            rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
    }

    void getBlock(int n) {
        try {
            RowSetNavigatorClient rowSetNavigatorClient = this.session.getRows(this.id, n, this.baseBlockSize);
            this.table = rowSetNavigatorClient.table;
            this.currentOffset = rowSetNavigatorClient.currentOffset;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    private void ensureCapacity() {
        if (this.size == this.table.length) {
            int n = this.size == 0 ? 4 : this.size * 2;
            Object[][] objectArrayArray = new Object[n][];
            System.arraycopy(this.table, 0, objectArrayArray, 0, this.size);
            this.table = objectArrayArray;
        }
    }
}

