/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;

class TransactionManagerCommon {
    Database database;
    Session lobSession;
    boolean hasPersistence;
    int txModel;
    HsqlNameManager.HsqlName[] catalogNameList;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    LongDeque liveTransactionTimestamps = new LongDeque();
    AtomicLong globalChangeTimestamp = new AtomicLong(1L);
    int transactionCount = 0;
    HashMap tableWriteLocks = new HashMap();
    MultiValueHashMap tableReadLocks = new MultiValueHashMap();
    public IntKeyHashMapConcurrent rowActionMap;

    TransactionManagerCommon() {
    }

    void persistCommit(Session session, Object[] objectArray, int n) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            RowAction rowAction = (RowAction)objectArray[i];
            if (rowAction.type == 0) continue;
            int n2 = rowAction.getCommitTypeOn(session.actionTimestamp);
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (rowAction.table.hasLobColumn) {
                switch (n2) {
                    case 1: {
                        session.sessionData.adjustLobUsageCount(rowAction.table, row.getData(), 1);
                        break;
                    }
                    case 2: {
                        session.sessionData.adjustLobUsageCount(rowAction.table, row.getData(), -1);
                        bl = true;
                        break;
                    }
                }
            }
            try {
                rowAction.store.commitRow(session, row, n2, this.txModel);
                if (this.txModel != 0) continue;
                rowAction.setAsNoOp();
                row.rowAction = null;
                continue;
            }
            catch (HsqlException hsqlException) {
                this.database.logger.logWarningEvent("data commit failed", hsqlException);
            }
        }
        try {
            if (bl && this.transactionCount == 0) {
                this.database.lobManager.deleteUnusedLobs();
            }
            session.logSequences();
            if (n > 0) {
                this.database.logger.writeCommitStatement(session);
            }
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finaliseRows(Session session, Object[] objectArray, int n, int n2, boolean bl) {
        boolean bl2 = false;
        for (int i = n; i < n2; ++i) {
            Object object;
            RowAction rowAction = (RowAction)objectArray[i];
            if (!rowAction.isMemory && rowAction.type == 0) {
                Object var13_12;
                object = this.rowActionMap.getWriteLock();
                ((ReentrantReadWriteLock.WriteLock)object).lock();
                try {
                    RowAction rowAction2 = rowAction;
                    synchronized (rowAction2) {
                        if (rowAction.type == 0) {
                            this.rowActionMap.remove(rowAction.getPos());
                        }
                    }
                    var13_12 = null;
                    ((ReentrantReadWriteLock.WriteLock)object).unlock();
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    ((ReentrantReadWriteLock.WriteLock)object).unlock();
                    throw throwable;
                }
            }
            if (rowAction.type != 3 || rowAction.deleteComplete) continue;
            try {
                rowAction.deleteComplete = true;
                if (rowAction.table.getTableType() == 3) continue;
                object = rowAction.memoryRow;
                if (object == null) {
                    object = (Row)rowAction.store.get(rowAction.getPos(), false);
                }
                if (bl && rowAction.table.hasLobColumn) {
                    bl2 = true;
                }
                rowAction.store.commitRow(session, (Row)object, rowAction.type, this.txModel);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2 && this.transactionCount == 0) {
            this.database.lobManager.deleteUnusedLobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeRolledBackTransaction(Session session, long l, Object[] objectArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            RowAction rowAction = (RowAction)objectArray[i];
            Row row = rowAction.memoryRow;
            if (row == null) {
                if (rowAction.type == 0) continue;
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            Row row2 = row;
            synchronized (row2) {
                rowAction.mergeRollback(session, l, row);
                continue;
            }
        }
    }

    void mergeTransaction(Session session, Object[] objectArray, int n, int n2, long l) {
        for (int i = n; i < n2; ++i) {
            RowAction rowAction = (RowAction)objectArray[i];
            rowAction.mergeToTimestamp(l);
        }
    }

    long nextChangeTimestamp() {
        return this.globalChangeTimestamp.incrementAndGet();
    }

    boolean checkDeadlock(Session session, OrderedHashSet orderedHashSet) {
        int n = session.waitingSessions.size();
        for (int i = 0; i < n; ++i) {
            Session session2 = (Session)session.waitingSessions.get(i);
            if (orderedHashSet.contains(session2)) {
                return false;
            }
            if (this.checkDeadlock(session2, orderedHashSet)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void endActionTPL(Session session) {
        block13: {
            block12: {
                block11: {
                    if (session.isolationLevel == 4) return;
                    if (session.isolationLevel == 8) {
                        return;
                    }
                    if (session.sessionContext.currentStatement == null) {
                        return;
                    }
                    if (session.sessionContext.depth > 0) {
                        return;
                    }
                    Object[] objectArray = session.sessionContext.currentStatement.getTableNamesForRead();
                    if (objectArray.length == 0) {
                        return;
                    }
                    this.writeLock.lock();
                    try {
                        int n;
                        this.unlockReadTablesTPL(session, (HsqlNameManager.HsqlName[])objectArray);
                        int n2 = session.waitingSessions.size();
                        if (n2 == 0) {
                            Object var8_4 = null;
                            this.writeLock.unlock();
                            return;
                        }
                        boolean bl = false;
                        for (n = 0; n < objectArray.length; ++n) {
                            if (this.tableWriteLocks.get(objectArray[n]) == session) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            break block11;
                        }
                        bl = false;
                        for (n = 0; n < n2; ++n) {
                            Session session2 = (Session)session.waitingSessions.get(n);
                            if (!ArrayUtil.containsAny(objectArray, session2.sessionContext.currentStatement.getTableNamesForWrite())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            break block12;
                        }
                        this.resetLocks(session);
                        this.resetLatchesMidTransaction(session);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.writeLock.unlock();
                        throw throwable;
                    }
                }
                Object var8_5 = null;
                this.writeLock.unlock();
                return;
            }
            Object var8_6 = null;
            this.writeLock.unlock();
            return;
        }
        Object var8_7 = null;
        this.writeLock.unlock();
    }

    void endTransactionTPL(Session session) {
        this.unlockTablesTPL(session);
        int n = session.waitingSessions.size();
        if (n == 0) {
            return;
        }
        this.resetLocks(session);
        this.resetLatches(session);
    }

    void resetLocks(Session session) {
        Session session2;
        int n;
        int n2 = session.waitingSessions.size();
        for (n = 0; n < n2; ++n) {
            boolean bl;
            session2 = (Session)session.waitingSessions.get(n);
            session2.tempUnlocked = false;
            long l = session2.latch.getCount();
            if (l != 1L || !(bl = this.setWaitedSessionsTPL(session2, session2.sessionContext.currentStatement)) || !session2.tempSet.isEmpty()) continue;
            this.lockTablesTPL(session2, session2.sessionContext.currentStatement);
            session2.tempUnlocked = true;
        }
        for (n = 0; n < n2; ++n) {
            session2 = (Session)session.waitingSessions.get(n);
            if (session2.tempUnlocked || session2.abortTransaction) continue;
            this.setWaitedSessionsTPL(session2, session2.sessionContext.currentStatement);
        }
    }

    void resetLatches(Session session) {
        int n = session.waitingSessions.size();
        for (int i = 0; i < n; ++i) {
            Session session2 = (Session)session.waitingSessions.get(i);
            if (session2.abortTransaction || session2.tempSet.isEmpty()) {
                // empty if block
            }
            this.setWaitingSessionTPL(session2);
        }
        session.waitingSessions.clear();
    }

    void resetLatchesMidTransaction(Session session) {
        session.tempSet.clear();
        session.tempSet.addAll(session.waitingSessions);
        session.waitingSessions.clear();
        int n = session.tempSet.size();
        for (int i = 0; i < n; ++i) {
            Session session2 = (Session)session.tempSet.get(i);
            if (session2.abortTransaction || session2.tempSet.isEmpty()) {
                // empty if block
            }
            this.setWaitingSessionTPL(session2);
        }
        session.tempSet.clear();
    }

    boolean setWaitedSessionsTPL(Session session, Statement statement) {
        Session session2;
        HsqlNameManager.HsqlName hsqlName;
        int n;
        session.tempSet.clear();
        if (statement == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session2 = (Session)this.tableWriteLocks.get(hsqlName);
            if (session2 != null && session2 != session) {
                session.tempSet.add(session2);
            }
            Iterator iterator = this.tableReadLocks.get(hsqlName);
            while (iterator.hasNext()) {
                session2 = (Session)iterator.next();
                if (session2 == session) continue;
                session.tempSet.add(session2);
            }
        }
        hsqlNameArray = statement.getTableNamesForRead();
        if (this.txModel == 1 && session.isReadOnly()) {
            hsqlNameArray = this.catalogNameList;
        }
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (session2 = (Session)this.tableWriteLocks.get(hsqlName)) == null || session2 == session) continue;
            session.tempSet.add(session2);
        }
        if (session.tempSet.isEmpty()) {
            return true;
        }
        if (this.checkDeadlock(session, session.tempSet)) {
            return true;
        }
        session.tempSet.clear();
        session.abortTransaction = true;
        return false;
    }

    void setWaitingSessionTPL(Session session) {
        int n = session.tempSet.size();
        assert (session.latch.getCount() <= (long)(n + 1));
        for (int i = 0; i < n; ++i) {
            Session session2 = (Session)session.tempSet.get(i);
            session2.waitingSessions.add(session);
        }
        session.tempSet.clear();
        session.latch.setCount(n);
    }

    void lockTablesTPL(Session session, Statement statement) {
        HsqlNameManager.HsqlName hsqlName;
        int n;
        if (statement == null || session.abortTransaction) {
            return;
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableWriteLocks.put(hsqlName, session);
        }
        hsqlNameArray = statement.getTableNamesForRead();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableReadLocks.put(hsqlName, session);
        }
    }

    void unlockTablesTPL(Session session) {
        Session session2;
        Iterator iterator = this.tableWriteLocks.values().iterator();
        while (iterator.hasNext()) {
            session2 = (Session)iterator.next();
            if (session2 != session) continue;
            iterator.setValue(null);
        }
        iterator = this.tableReadLocks.values().iterator();
        while (iterator.hasNext()) {
            session2 = (Session)iterator.next();
            if (session2 != session) continue;
            iterator.remove();
        }
    }

    void unlockReadTablesTPL(Session session, HsqlNameManager.HsqlName[] hsqlNameArray) {
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            this.tableReadLocks.remove(hsqlNameArray[i], session);
        }
    }

    boolean hasLocks(Session session, Statement statement) {
        Session session2;
        HsqlNameManager.HsqlName hsqlName;
        int n;
        if (statement == null) {
            return true;
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session2 = (Session)this.tableWriteLocks.get(hsqlName);
            if (session2 != null && session2 != session) {
                return false;
            }
            Iterator iterator = this.tableReadLocks.get(hsqlName);
            while (iterator.hasNext()) {
                session2 = (Session)iterator.next();
                if (session2 == session) continue;
                return false;
            }
        }
        hsqlNameArray = statement.getTableNamesForRead();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (session2 = (Session)this.tableWriteLocks.get(hsqlName)) == null || session2 == session) continue;
            return false;
        }
        return true;
    }

    long getFirstLiveTransactionTimestamp() {
        if (this.liveTransactionTimestamps.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.liveTransactionTimestamps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    RowAction[] getRowActionList() {
        this.writeLock.lock();
        try {
            var1_1 = this.database.sessionManager.getAllSessions();
            var2_2 = new int[var1_1.length];
            var4_3 = 0;
            var5_4 = 0;
            for (var6_6 = 0; var6_6 < var1_1.length; ++var6_6) {
                var5_4 += var1_1[var6_6].getTransactionSize();
            }
            var3_8 = new RowAction[var5_4];
            block3: while (true) {
                var5_4 = 0;
                var6_7 = 0x7FFFFFFFFFFFFFFFL;
                var8_9 = 0;
                for (var9_11 = 0; var9_11 < var1_1.length; ++var9_11) {
                    var10_12 = var1_1[var9_11].getTransactionSize();
                    if (var2_2[var9_11] >= var10_12) continue;
                    var11_14 = (RowAction)var1_1[var9_11].rowActionList.get(var2_2[var9_11]);
                    if (var11_14.actionTimestamp < var6_7) {
                        var6_7 = var11_14.actionTimestamp;
                        var8_9 = var9_11;
                    }
                    var5_4 = 1;
                }
                if (var5_4 == 0) break;
                var9_10 = var1_1[var8_9].rowActionList;
                while (true) {
                    if (var2_2[var8_9] >= var9_10.size()) continue block3;
                    var10_13 = (RowAction)var9_10.get(var2_2[var8_9]);
                    if (var10_13.actionTimestamp == var6_7 + 1L) {
                        ++var6_7;
                    }
                    if (var10_13.actionTimestamp == var6_7) ** break;
                    continue block3;
                    var3_8[var4_3++] = var10_13;
                    v0 = var8_9;
                    var2_2[v0] = var2_2[v0] + 1;
                }
                break;
            }
            var5_5 = var3_8;
            var13_15 = null;
            this.writeLock.unlock();
            return var5_5;
        }
        catch (Throwable var12_17) {
            var13_16 = null;
            this.writeLock.unlock();
            throw var12_17;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DoubleIntIndex getTransactionIDList() {
        this.writeLock.lock();
        try {
            int n = this.rowActionMap.size();
            DoubleIntIndex doubleIntIndex = new DoubleIntIndex(n, false);
            doubleIntIndex.setKeysSearchTarget();
            Iterator iterator = this.rowActionMap.keySet().iterator();
            while (iterator.hasNext()) {
                doubleIntIndex.addUnique(iterator.nextInt(), 0);
            }
            DoubleIntIndex doubleIntIndex2 = doubleIntIndex;
            Object var6_5 = null;
            this.writeLock.unlock();
            return doubleIntIndex2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertTransactionIDs(DoubleIntIndex doubleIntIndex) {
        this.writeLock.lock();
        try {
            RowAction[] rowActionArray = new RowAction[this.rowActionMap.size()];
            Iterator iterator = this.rowActionMap.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                rowActionArray[n] = (RowAction)iterator.next();
                ++n;
            }
            this.rowActionMap.clear();
            for (n = 0; n < rowActionArray.length; ++n) {
                int n2 = doubleIntIndex.lookupFirstEqual(rowActionArray[n].getPos());
                rowActionArray[n].setPos(n2);
                this.rowActionMap.put(n2, rowActionArray[n]);
            }
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }
}

