/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.Session;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.result.Result;

public class StatementSchemaDefinition
extends StatementSchema {
    StatementSchema[] statements;

    StatementSchemaDefinition(StatementSchema[] statementSchemaArray) {
        this.statements = statementSchemaArray;
    }

    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    Result getResult(Session session) {
        Table table;
        Object object;
        int n;
        HsqlNameManager.HsqlName hsqlName = this.statements[0].getSchemaName();
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        Result result = this.statements[0].execute(session);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        StatementSchema statementSchema = new StatementSchema(null, 1088, null);
        if (this.statements.length == 1 || result.isError()) {
            return result;
        }
        HsqlNameManager.HsqlName hsqlName2 = session.getCurrentSchemaHsqlName();
        for (n = 1; n < this.statements.length; ++n) {
            try {
                session.setSchema(hsqlName.name);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.statements[n].setSchemaHsqlName(hsqlName);
            session.parser.reset(this.statements[n].getSQL());
            try {
                session.parser.read();
                switch (this.statements[n].getType()) {
                    case 48: 
                    case 49: {
                        result = this.statements[n].execute(session);
                        break;
                    }
                    case 77: {
                        StatementSchema statementSchema2 = session.parser.compileCreate();
                        statementSchema2.isSchemaDefinition = true;
                        statementSchema2.setSchemaHsqlName(hsqlName);
                        if (session.parser.token.tokenType != 848) {
                            throw session.parser.unexpectedToken();
                        }
                        statementSchema2.isLogged = false;
                        result = statementSchema2.execute(session);
                        object = ((Table)statementSchema2.arguments[0]).getName();
                        table = (Table)session.database.schemaManager.getSchemaObject((HsqlNameManager.HsqlName)object);
                        hsqlArrayList.addAll((HsqlArrayList)statementSchema2.arguments[1]);
                        ((HsqlArrayList)statementSchema2.arguments[1]).clear();
                        statementSchema.sql = table.getSQL();
                        statementSchema.execute(session);
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 61: 
                    case 83: 
                    case 133: {
                        result = this.statements[n].execute(session);
                        break;
                    }
                    case 14: 
                    case 23: 
                    case 80: 
                    case 84: 
                    case 1074: {
                        StatementSchema statementSchema2 = session.parser.compileCreate();
                        statementSchema2.isSchemaDefinition = true;
                        statementSchema2.setSchemaHsqlName(hsqlName);
                        if (session.parser.token.tokenType != 848) {
                            throw session.parser.unexpectedToken();
                        }
                        result = statementSchema2.execute(session);
                        break;
                    }
                    case 6: 
                    case 52: 
                    case 79: 
                    case 114: 
                    case 117: {
                        throw session.parser.unsupportedFeature();
                    }
                    default: {
                        throw Error.runtimeError(201, "");
                    }
                }
                if (!result.isError()) continue;
            }
            catch (HsqlException hsqlException) {
                result = Result.newErrorResult(hsqlException, this.statements[n].getSQL());
            }
            break;
        }
        if (!result.isError()) {
            try {
                for (n = 0; n < hsqlArrayList.size(); ++n) {
                    object = (Constraint)hsqlArrayList.get(n);
                    table = session.database.schemaManager.getUserTable(session, ((Constraint)object).core.refTableName);
                    ParserDDL.addForeignKey(session, table, (Constraint)object, null);
                    statementSchema.sql = ((Constraint)object).getSQL();
                    statementSchema.execute(session);
                }
            }
            catch (HsqlException hsqlException) {
                result = Result.newErrorResult(hsqlException, this.sql);
            }
        }
        if (result.isError()) {
            try {
                session.database.schemaManager.dropSchema(session, hsqlName.name, true);
                session.database.logger.writeToLog(session, this.getDropSchemaStatement(hsqlName));
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        try {
            session.setCurrentSchemaHsqlName(hsqlName2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    String getDropSchemaStatement(HsqlNameManager.HsqlName hsqlName) {
        return "DROP SCHEMA " + hsqlName.statementName + " " + "CASCADE";
    }
}

