/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementInsert;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongValueHashMap;
import org.hsqldb.result.Result;

public final class StatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private LongKeyHashMap sqlLookup;
    private LongKeyHashMap csidMap;
    private long next_cs_id;

    StatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.sqlLookup = new LongKeyHashMap();
        this.csidMap = new LongKeyHashMap();
        this.next_cs_id = 0L;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.sqlLookup.clear();
        this.csidMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private long getStatementID(HsqlNameManager.HsqlName hsqlName, String string) {
        LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(hsqlName.hashCode());
        if (longValueHashMap == null) {
            return -1L;
        }
        return longValueHashMap.get((Object)string, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Statement getStatement(Session session, long l) {
        Statement statement = (Statement)this.csidMap.get(l);
        if (statement == null) {
            return null;
        }
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            String string = (String)this.sqlLookup.get(l);
            HsqlNameManager.HsqlName hsqlName = session.getCurrentSchemaHsqlName();
            try {
                try {
                    HsqlNameManager.HsqlName hsqlName2 = statement.getSchemaName();
                    session.setSchema(hsqlName2.name);
                    StatementInsert statementInsert = null;
                    if (statement.generatedResultMetaData() != null) {
                        statementInsert = (StatementInsert)statement;
                    }
                    statement = session.compileStatement(string, statement.getResultProperties());
                    statement.setID(l);
                    statement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
                    if (statementInsert != null) {
                        statement.setGeneratedColumnInfo(statementInsert.generatedType, statementInsert.generatedInputMetaData);
                    }
                    this.csidMap.put(l, statement);
                }
                catch (Throwable throwable) {
                    this.freeStatement(l);
                    Statement statement2 = null;
                    Object var10_11 = null;
                    session.setSchema(hsqlName.name);
                    return statement2;
                }
                Object var10_10 = null;
                session.setSchema(hsqlName.name);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                session.setSchema(hsqlName.name);
                throw throwable;
            }
        }
        return statement;
    }

    private long registerStatement(long l, Statement statement) {
        if (l < 0L) {
            l = this.nextID();
            int n = statement.getSchemaName().hashCode();
            LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(n);
            if (longValueHashMap == null) {
                longValueHashMap = new LongValueHashMap();
                this.schemaMap.put(n, longValueHashMap);
            }
            longValueHashMap.put(statement.getSQL(), l);
            this.sqlLookup.put(l, statement.getSQL());
        }
        statement.setID(l);
        statement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
        this.csidMap.put(l, statement);
        return l;
    }

    synchronized void freeStatement(long l) {
        if (l == -1L) {
            return;
        }
        Statement statement = (Statement)this.csidMap.remove(l);
        if (statement != null) {
            int n = statement.getSchemaName().hashCode();
            LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(n);
            String string = (String)this.sqlLookup.remove(l);
            longValueHashMap.remove(string);
        }
    }

    synchronized Statement compile(Session session, Result result) throws Throwable {
        String string = result.getMainString();
        long l = this.getStatementID(session.currentSchema, string);
        Statement statement = (Statement)this.csidMap.get(l);
        if (statement == null || !statement.isValid() || statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            int n = result.getExecuteProperties();
            statement = session.compileStatement(string, n);
            l = this.registerStatement(l, statement);
        }
        statement.setGeneratedColumnInfo(result.getGeneratedResultType(), result.getGeneratedResultMetaData());
        return statement;
    }
}

