/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Comparator;
import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.SubQuery;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.store.BaseHashMap;

public class StatementExpression
extends StatementDMQL {
    Expression expression;

    StatementExpression(Session session, ParserDQL.CompileContext compileContext, int n, Expression expression) {
        super(n, 2007, null);
        switch (n) {
            case 58: 
            case 1101: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        this.isTransactionStatement = false;
        this.expression = expression;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 58: {
                return this.sql;
            }
            case 1101: {
                stringBuffer.append(this.expression.getSQL());
            }
        }
        return stringBuffer.toString();
    }

    SubQuery[] getSubqueries(Session session) {
        BaseHashMap baseHashMap = null;
        if (this.expression != null) {
            baseHashMap = this.expression.collectAllSubqueries((OrderedHashSet)baseHashMap);
        }
        if (baseHashMap == null || baseHashMap.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] objectArray = new SubQuery[baseHashMap.size()];
        ((HashSet)baseHashMap).toArray(objectArray);
        ArraySort.sort(objectArray, 0, objectArray.length, (Comparator)objectArray[0]);
        for (int i = 0; i < this.subqueries.length; ++i) {
            ((SubQuery)objectArray[i]).prepareTable(session);
        }
        return objectArray;
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("STATEMENT");
        return stringBuffer.toString();
    }

    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    Result getResult(Session session) {
        switch (this.type) {
            case 58: 
            case 1101: {
                return this.expression.getResult(session);
            }
        }
        throw Error.runtimeError(201, "");
    }

    public void resolve(Session session) {
    }

    String describeImpl(Session session) throws Exception {
        return this.getSQL();
    }

    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        int n;
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
        }
    }

    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
    }
}

