// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSProxyObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSTypeofIdenticalNode#doBoolean}
 *     Activation probability: 0.12714
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doNumber(int)}
 *     Activation probability: 0.11857
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doNumber(SafeInteger)}
 *     Activation probability: 0.11000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doNumber(long)}
 *     Activation probability: 0.10143
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doNumber(double)}
 *     Activation probability: 0.09286
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doSymbol}
 *     Activation probability: 0.08429
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doBigInt}
 *     Activation probability: 0.07571
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doString}
 *     Activation probability: 0.06714
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doTypeObjectOrFunctionJSFunction}
 *     Activation probability: 0.05857
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doTypeObjectOrFunctionJSProxy}
 *     Activation probability: 0.05000
 *     With/without class size: 5/4 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doTypeObjectOrFunctionOther}
 *     Activation probability: 0.04143
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doTypePrimitive}
 *     Activation probability: 0.03286
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doForeignObject}
 *     Activation probability: 0.02429
 *     With/without class size: 4/4 bytes
 *   Specialization {@link JSTypeofIdenticalNode#doForeignObject}
 *     Activation probability: 0.01571
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(JSTypeofIdenticalNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class JSTypeofIdenticalNodeGen extends JSTypeofIdenticalNode implements Introspection.Provider {

    static final ReferenceField<ForeignObject0Data> FOREIGN_OBJECT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreignObject0_cache", ForeignObject0Data.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSTypeofIdenticalNode#doBoolean}
     *   1: SpecializationActive {@link JSTypeofIdenticalNode#doNumber(int)}
     *   2: SpecializationActive {@link JSTypeofIdenticalNode#doNumber(SafeInteger)}
     *   3: SpecializationActive {@link JSTypeofIdenticalNode#doNumber(long)}
     *   4: SpecializationActive {@link JSTypeofIdenticalNode#doNumber(double)}
     *   5: SpecializationActive {@link JSTypeofIdenticalNode#doSymbol}
     *   6: SpecializationActive {@link JSTypeofIdenticalNode#doBigInt}
     *   7: SpecializationActive {@link JSTypeofIdenticalNode#doString}
     *   8: SpecializationActive {@link JSTypeofIdenticalNode#doTypeObjectOrFunctionJSFunction}
     *   9: SpecializationActive {@link JSTypeofIdenticalNode#doTypeObjectOrFunctionJSProxy}
     *   10: SpecializationActive {@link JSTypeofIdenticalNode#doTypeObjectOrFunctionOther}
     *   11: SpecializationActive {@link JSTypeofIdenticalNode#doTypePrimitive}
     *   12: SpecializationActive {@link JSTypeofIdenticalNode#doForeignObject}
     *   13: SpecializationActive {@link JSTypeofIdenticalNode#doForeignObject}
     *   14-16: ImplicitCast[type=double, index=0]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSTypeofIdenticalNode#doTypeObjectOrFunctionJSProxy}
     *   Parameter: {@link IsCallableNode} isCallableNode</pre>
     */
    @Child private IsCallableNode typeObjectOrFunctionJSProxy_isCallableNode_;
    @UnsafeAccessedField @Child private ForeignObject0Data foreignObject0_cache;

    private JSTypeofIdenticalNodeGen(JavaScriptNode childNode, Type type) {
        super(childNode, type);
    }

    @ExplodeLoop
    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111111111111) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] || SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] || SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] || SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] || SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] || SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] || SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] || SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] || SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] || SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] || SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] || SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] || SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] */ && operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_ = (boolean) operandNodeValue;
                return doBoolean(operandNodeValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] */ && operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (int) operandNodeValue;
                return doNumber(operandNodeValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] */ && operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_ = (SafeInteger) operandNodeValue;
                return doNumber(operandNodeValue_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] */ && operandNodeValue instanceof Long) {
                long operandNodeValue_ = (long) operandNodeValue;
                return doNumber(operandNodeValue_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue)) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue);
                return doNumber(operandNodeValue_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] */ && operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_ = (Symbol) operandNodeValue;
                return doSymbol(operandNodeValue_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] */ && operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt) operandNodeValue;
                return doBigInt(operandNodeValue_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] */ && operandNodeValue instanceof TruffleString) {
                TruffleString operandNodeValue_ = (TruffleString) operandNodeValue;
                return doString(operandNodeValue_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] */) {
                assert DSLSupport.assertIdempotence((type == Type.Object || type == Type.Function));
                if ((JSGuards.isJSFunction(operandNodeValue))) {
                    return doTypeObjectOrFunctionJSFunction(operandNodeValue);
                }
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] */ && operandNodeValue instanceof JSProxyObject) {
                JSProxyObject operandNodeValue_ = (JSProxyObject) operandNodeValue;
                {
                    IsCallableNode isCallableNode__ = this.typeObjectOrFunctionJSProxy_isCallableNode_;
                    if (isCallableNode__ != null) {
                        assert DSLSupport.assertIdempotence((type == Type.Object || type == Type.Function));
                        return doTypeObjectOrFunctionJSProxy(operandNodeValue_, isCallableNode__);
                    }
                }
            }
            if ((state_0 & 0b110000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] || SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] */ && operandNodeValue instanceof JSDynamicObject) {
                JSDynamicObject operandNodeValue_ = (JSDynamicObject) operandNodeValue;
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] */) {
                    assert DSLSupport.assertIdempotence((type == Type.Object || type == Type.Function));
                    if ((!(JSGuards.isJSFunction(operandNodeValue_))) && (!(JSGuards.isJSProxy(operandNodeValue_)))) {
                        return doTypeObjectOrFunctionOther(operandNodeValue_);
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] */) {
                    assert DSLSupport.assertIdempotence((type != Type.Object));
                    assert DSLSupport.assertIdempotence((type != Type.Function));
                    return doTypePrimitive(operandNodeValue_);
                }
            }
            if ((state_0 & 0b11000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
                    ForeignObject0Data s12_ = this.foreignObject0_cache;
                    while (s12_ != null) {
                        if ((s12_.interop_.accepts(operandNodeValue)) && (JSGuards.isForeignObject(operandNodeValue))) {
                            return doForeignObject(operandNodeValue, s12_.interop_);
                        }
                        s12_ = s12_.next_;
                    }
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
                    if ((JSGuards.isForeignObject(operandNodeValue))) {
                        return this.foreignObject1Boundary(state_0, operandNodeValue);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object foreignObject1Boundary(int state_0, Object operandNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(operandNodeValue));
                return doForeignObject(operandNodeValue, interop__);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111111111110) == 0 /* only-active SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] */ && ((state_0 & 0b11111111111111) != 0  /* is-not SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] && SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] && SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] && SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */)) {
            return executeBoolean_boolean0(state_0, frameValue);
        } else if ((state_0 & 0b11111111111101) == 0 /* only-active SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] */ && ((state_0 & 0b11111111111111) != 0  /* is-not SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] && SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] && SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] && SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */)) {
            return executeBoolean_int1(state_0, frameValue);
        } else if ((state_0 & 0b11111111110111) == 0 /* only-active SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] */ && ((state_0 & 0b11111111111111) != 0  /* is-not SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] && SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] && SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] && SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */)) {
            return executeBoolean_long2(state_0, frameValue);
        } else if ((state_0 & 0b11111111101111) == 0 /* only-active SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] */ && ((state_0 & 0b11111111111111) != 0  /* is-not SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] && SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] && SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] && SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */)) {
            return executeBoolean_double3(state_0, frameValue);
        } else {
            return executeBoolean_generic4(state_0, frameValue);
        }
    }

    private boolean executeBoolean_boolean0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] */;
        return doBoolean(operandNodeValue_);
    }

    private boolean executeBoolean_int1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] */;
        return doNumber(operandNodeValue_);
    }

    private boolean executeBoolean_long2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long operandNodeValue_;
        try {
            operandNodeValue_ = super.operandNode.executeLong(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] */;
        return doNumber(operandNodeValue_);
    }

    private boolean executeBoolean_double3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        double operandNodeValue_;
        try {
            if ((state_0 & 0x18000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111111111111) != 0  /* is-not SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] && SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] && SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] && SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */)) {
                operandNodeValue_ = super.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0x14000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11111111111111) != 0  /* is-not SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] && SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] && SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] && SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] && SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] && SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] && SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */)) {
                operandNodeValue_int = super.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = super.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b10000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] */;
        return doNumber(operandNodeValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private boolean foreignObject1Boundary0(int state_0, Object operandNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(operandNodeValue_));
                return doForeignObject(operandNodeValue_, interop__);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private boolean executeBoolean_generic4(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state_0 & 0b11111111111111) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] || SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] || SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] || SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] || SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] || SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] || SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] || SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] || SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] || SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] || SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] || SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] || SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] */ && operandNodeValue_ instanceof Boolean) {
                boolean operandNodeValue__ = (boolean) operandNodeValue_;
                return doBoolean(operandNodeValue__);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] */ && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (int) operandNodeValue_;
                return doNumber(operandNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] */ && operandNodeValue_ instanceof SafeInteger) {
                SafeInteger operandNodeValue__ = (SafeInteger) operandNodeValue_;
                return doNumber(operandNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] */ && operandNodeValue_ instanceof Long) {
                long operandNodeValue__ = (long) operandNodeValue_;
                return doNumber(operandNodeValue__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=double, index=0] */, operandNodeValue_);
                return doNumber(operandNodeValue__);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] */ && operandNodeValue_ instanceof Symbol) {
                Symbol operandNodeValue__ = (Symbol) operandNodeValue_;
                return doSymbol(operandNodeValue__);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] */ && operandNodeValue_ instanceof BigInt) {
                BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
                return doBigInt(operandNodeValue__);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] */ && operandNodeValue_ instanceof TruffleString) {
                TruffleString operandNodeValue__ = (TruffleString) operandNodeValue_;
                return doString(operandNodeValue__);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] */) {
                assert DSLSupport.assertIdempotence((type == Type.Object || type == Type.Function));
                if ((JSGuards.isJSFunction(operandNodeValue_))) {
                    return doTypeObjectOrFunctionJSFunction(operandNodeValue_);
                }
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] */ && operandNodeValue_ instanceof JSProxyObject) {
                JSProxyObject operandNodeValue__ = (JSProxyObject) operandNodeValue_;
                {
                    IsCallableNode isCallableNode__ = this.typeObjectOrFunctionJSProxy_isCallableNode_;
                    if (isCallableNode__ != null) {
                        assert DSLSupport.assertIdempotence((type == Type.Object || type == Type.Function));
                        return doTypeObjectOrFunctionJSProxy(operandNodeValue__, isCallableNode__);
                    }
                }
            }
            if ((state_0 & 0b110000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] || SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] */ && operandNodeValue_ instanceof JSDynamicObject) {
                JSDynamicObject operandNodeValue__ = (JSDynamicObject) operandNodeValue_;
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] */) {
                    assert DSLSupport.assertIdempotence((type == Type.Object || type == Type.Function));
                    if ((!(JSGuards.isJSFunction(operandNodeValue__))) && (!(JSGuards.isJSProxy(operandNodeValue__)))) {
                        return doTypeObjectOrFunctionOther(operandNodeValue__);
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] */) {
                    assert DSLSupport.assertIdempotence((type != Type.Object));
                    assert DSLSupport.assertIdempotence((type != Type.Function));
                    return doTypePrimitive(operandNodeValue__);
                }
            }
            if ((state_0 & 0b11000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
                    ForeignObject0Data s12_ = this.foreignObject0_cache;
                    while (s12_ != null) {
                        if ((s12_.interop_.accepts(operandNodeValue_)) && (JSGuards.isForeignObject(operandNodeValue_))) {
                            return doForeignObject(operandNodeValue_, s12_.interop_);
                        }
                        s12_ = s12_.next_;
                    }
                }
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
                    if ((JSGuards.isForeignObject(operandNodeValue_))) {
                        return this.foreignObject1Boundary0(state_0, operandNodeValue_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        executeBoolean(frameValue);
        return;
    }

    private boolean executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if (operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_ = (boolean) operandNodeValue;
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] */;
            this.state_0_ = state_0;
            return doBoolean(operandNodeValue_);
        }
        if (operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (int) operandNodeValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] */;
            this.state_0_ = state_0;
            return doNumber(operandNodeValue_);
        }
        if (operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_ = (SafeInteger) operandNodeValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] */;
            this.state_0_ = state_0;
            return doNumber(operandNodeValue_);
        }
        if (operandNodeValue instanceof Long) {
            long operandNodeValue_ = (long) operandNodeValue;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] */;
            this.state_0_ = state_0;
            return doNumber(operandNodeValue_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue)) != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                state_0 = (state_0 | (doubleCast0 << 14) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b10000 /* add SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] */;
                this.state_0_ = state_0;
                return doNumber(operandNodeValue_);
            }
        }
        if (operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_ = (Symbol) operandNodeValue;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] */;
            this.state_0_ = state_0;
            return doSymbol(operandNodeValue_);
        }
        if (operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return doBigInt(operandNodeValue_);
        }
        if (operandNodeValue instanceof TruffleString) {
            TruffleString operandNodeValue_ = (TruffleString) operandNodeValue;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] */;
            this.state_0_ = state_0;
            return doString(operandNodeValue_);
        }
        if ((type == Type.Object || type == Type.Function) && (JSGuards.isJSFunction(operandNodeValue))) {
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] */;
            this.state_0_ = state_0;
            return doTypeObjectOrFunctionJSFunction(operandNodeValue);
        }
        if (operandNodeValue instanceof JSProxyObject) {
            JSProxyObject operandNodeValue_ = (JSProxyObject) operandNodeValue;
            if ((type == Type.Object || type == Type.Function)) {
                IsCallableNode isCallableNode__ = this.insert((IsCallableNode.create()));
                Objects.requireNonNull(isCallableNode__, "Specialization 'doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)' cache 'isCallableNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.typeObjectOrFunctionJSProxy_isCallableNode_ = isCallableNode__;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] */;
                this.state_0_ = state_0;
                return doTypeObjectOrFunctionJSProxy(operandNodeValue_, isCallableNode__);
            }
        }
        if (operandNodeValue instanceof JSDynamicObject) {
            JSDynamicObject operandNodeValue_ = (JSDynamicObject) operandNodeValue;
            if ((type == Type.Object || type == Type.Function) && (!(JSGuards.isJSFunction(operandNodeValue_))) && (!(JSGuards.isJSProxy(operandNodeValue_)))) {
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] */;
                this.state_0_ = state_0;
                return doTypeObjectOrFunctionOther(operandNodeValue_);
            }
            if ((type != Type.Object) && (type != Type.Function)) {
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] */;
                this.state_0_ = state_0;
                return doTypePrimitive(operandNodeValue_);
            }
        }
        if (((state_0 & 0b10000000000000)) == 0 /* is-not SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
            while (true) {
                int count12_ = 0;
                ForeignObject0Data s12_ = FOREIGN_OBJECT0_CACHE_UPDATER.getVolatile(this);
                ForeignObject0Data s12_original = s12_;
                while (s12_ != null) {
                    if ((s12_.interop_.accepts(operandNodeValue)) && (JSGuards.isForeignObject(operandNodeValue))) {
                        break;
                    }
                    count12_++;
                    s12_ = s12_.next_;
                }
                if (s12_ == null) {
                    if ((JSGuards.isForeignObject(operandNodeValue)) && count12_ < (JSConfig.InteropLibraryLimit)) {
                        // assert (s12_.interop_.accepts(operandNodeValue));
                        s12_ = this.insert(new ForeignObject0Data(s12_original));
                        InteropLibrary interop__ = s12_.insert((INTEROP_LIBRARY_.create(operandNodeValue)));
                        Objects.requireNonNull(interop__, "Specialization 'doForeignObject(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s12_.interop_ = interop__;
                        if (!FOREIGN_OBJECT0_CACHE_UPDATER.compareAndSet(this, s12_original, s12_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s12_ != null) {
                    return doForeignObject(operandNodeValue, s12_.interop_);
                }
                break;
            }
        }
        {
            InteropLibrary interop__ = null;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    if ((JSGuards.isForeignObject(operandNodeValue))) {
                        interop__ = (INTEROP_LIBRARY_.getUncached(operandNodeValue));
                        this.foreignObject0_cache = null;
                        state_0 = state_0 & 0xffffefff /* remove SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */;
                        state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doForeignObject(operandNodeValue, interop__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111111111111) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11111111111111) & ((state_0 & 0b11111111111111) - 1)) == 0 /* is-single  */) {
                ForeignObject0Data s12_ = this.foreignObject0_cache;
                if ((s12_ == null || s12_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[15];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "doBoolean";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBoolean(boolean)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doNumber";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doNumber";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(SafeInteger)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doNumber";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(long)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doNumber";
        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doNumber(double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doSymbol(Symbol)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doBigInt(BigInt)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doString(TruffleString)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doTypeObjectOrFunctionJSFunction";
        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSFunction(Object)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doTypeObjectOrFunctionJSProxy";
        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionJSProxy(JSProxyObject, IsCallableNode)] */) {
            {
                IsCallableNode isCallableNode__ = this.typeObjectOrFunctionJSProxy_isCallableNode_;
                if (isCallableNode__ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.typeObjectOrFunctionJSProxy_isCallableNode_));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doTypeObjectOrFunctionOther";
        if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypeObjectOrFunctionOther(JSDynamicObject)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doTypePrimitive";
        if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doTypePrimitive(JSDynamicObject)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            ForeignObject0Data s12_ = this.foreignObject0_cache;
            while (s12_ != null) {
                cached.add(Arrays.<Object>asList(s12_.interop_));
                s12_ = s12_.next_;
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[JSTypeofIdenticalNode.doForeignObject(Object, InteropLibrary)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.<Object>asList());
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[14] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static JSTypeofIdenticalNode create(JavaScriptNode childNode, Type type) {
        return new JSTypeofIdenticalNodeGen(childNode, type);
    }

    @GeneratedBy(JSTypeofIdenticalNode.class)
    @DenyReplace
    private static final class ForeignObject0Data extends Node implements SpecializationDataNode {

        @Child ForeignObject0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSTypeofIdenticalNode#doForeignObject}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
