/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SimpleBuffers;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.RandomMaskGen;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketConnectionRFC6455;

public class WebSocketClientFactory
extends AggregateLifeCycle {
    private static final Logger __log = Log.getLogger(WebSocketClientFactory.class.getName());
    private static final ByteArrayBuffer __ACCEPT = new ByteArrayBuffer.CaseInsensitive("Sec-WebSocket-Accept");
    private final Queue<WebSocketConnection> connections = new ConcurrentLinkedQueue<WebSocketConnection>();
    private final SslContextFactory _sslContextFactory = new SslContextFactory();
    private final ThreadPool _threadPool;
    private final WebSocketClientSelector _selector;
    private MaskGen _maskGen;
    private WebSocketBuffers _buffers;

    public WebSocketClientFactory() {
        this(null);
    }

    public WebSocketClientFactory(ThreadPool threadPool) {
        this(threadPool, new RandomMaskGen());
    }

    public WebSocketClientFactory(ThreadPool threadPool, MaskGen maskGen) {
        this(threadPool, maskGen, 8192);
    }

    public WebSocketClientFactory(ThreadPool threadPool, MaskGen maskGen, int bufferSize) {
        if (threadPool == null) {
            threadPool = new QueuedThreadPool();
        }
        this._threadPool = threadPool;
        this.addBean(this._threadPool);
        this._buffers = new WebSocketBuffers(bufferSize);
        this.addBean(this._buffers);
        this._maskGen = maskGen;
        this.addBean(this._maskGen);
        this._selector = new WebSocketClientSelector();
        this.addBean(this._selector);
        this.addBean(this._sslContextFactory);
    }

    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    public SelectorManager getSelectorManager() {
        return this._selector;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public MaskGen getMaskGen() {
        return this._maskGen;
    }

    public void setMaskGen(MaskGen maskGen) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this.removeBean(this._maskGen);
        this._maskGen = maskGen;
        this.addBean(maskGen);
    }

    public void setBufferSize(int bufferSize) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this.removeBean(this._buffers);
        this._buffers = new WebSocketBuffers(bufferSize);
        this.addBean(this._buffers);
    }

    public int getBufferSize() {
        return this._buffers.getBufferSize();
    }

    protected void doStop() throws Exception {
        this.closeConnections();
        super.doStop();
    }

    public WebSocketClient newWebSocketClient() {
        return new WebSocketClient(this);
    }

    protected SSLEngine newSslEngine(SocketChannel channel) throws IOException {
        SSLEngine sslEngine;
        if (channel != null) {
            String peerHost = channel.socket().getInetAddress().getHostAddress();
            int peerPort = channel.socket().getPort();
            sslEngine = this._sslContextFactory.newSslEngine(peerHost, peerPort);
        } else {
            sslEngine = this._sslContextFactory.newSslEngine();
        }
        sslEngine.setUseClientMode(true);
        sslEngine.beginHandshake();
        return sslEngine;
    }

    protected boolean addConnection(WebSocketConnection connection) {
        return this.isRunning() && this.connections.add(connection);
    }

    protected boolean removeConnection(WebSocketConnection connection) {
        return this.connections.remove(connection);
    }

    protected void closeConnections() {
        for (WebSocketConnection connection : this.connections) {
            connection.shutdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebSocketClientConnection
    extends WebSocketConnectionRFC6455 {
        private final WebSocketClientFactory factory;

        public WebSocketClientConnection(WebSocketClientFactory factory, WebSocket webSocket, EndPoint endPoint, WebSocketBuffers buffers, long timeStamp, int maxIdleTime, String protocol, List<Extension> extensions, int draftVersion, MaskGen maskGen) throws IOException {
            super(webSocket, endPoint, buffers, timeStamp, maxIdleTime, protocol, extensions, draftVersion, maskGen);
            this.factory = factory;
        }

        @Override
        public void onClose() {
            super.onClose();
            this.factory.removeConnection(this);
        }
    }

    class HandshakeConnection
    extends AbstractConnection
    implements AsyncConnection {
        private final AsyncEndPoint _endp;
        private final WebSocketClient.WebSocketFuture _future;
        private final String _key;
        private final HttpParser _parser;
        private String _accept;
        private String _error;
        private ByteArrayBuffer _handshake;

        public HandshakeConnection(AsyncEndPoint endpoint, WebSocketClient.WebSocketFuture future) {
            super(endpoint, System.currentTimeMillis());
            this._endp = endpoint;
            this._future = future;
            byte[] bytes = new byte[16];
            new Random().nextBytes(bytes);
            this._key = new String(B64Code.encode(bytes));
            SimpleBuffers buffers = new SimpleBuffers(WebSocketClientFactory.this._buffers.getBuffer(), null);
            this._parser = new HttpParser(buffers, this._endp, new HttpParser.EventHandler(){

                public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
                    if (status != 101) {
                        HandshakeConnection.this._error = "Bad response status " + status + " " + reason;
                        HandshakeConnection.this._endp.close();
                    }
                }

                public void parsedHeader(Buffer name, Buffer value) throws IOException {
                    if (__ACCEPT.equals(name)) {
                        HandshakeConnection.this._accept = value.toString();
                    }
                }

                public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
                    if (HandshakeConnection.this._error == null) {
                        HandshakeConnection.this._error = "Bad response: " + method + " " + url + " " + version;
                    }
                    HandshakeConnection.this._endp.close();
                }

                public void content(Buffer ref) throws IOException {
                    if (HandshakeConnection.this._error == null) {
                        HandshakeConnection.this._error = "Bad response. " + ref.length() + "B of content?";
                    }
                    HandshakeConnection.this._endp.close();
                }
            });
        }

        private boolean handshake() {
            if (this._handshake == null) {
                Map<String, String> cookies;
                String path = this._future.getURI().getPath();
                if (path == null || path.length() == 0) {
                    path = "/";
                }
                if (this._future.getURI().getRawQuery() != null) {
                    path = path + "?" + this._future.getURI().getRawQuery();
                }
                String origin = this._future.getOrigin();
                StringBuilder request = new StringBuilder(512);
                request.append("GET ").append(path).append(" HTTP/1.1\r\n").append("Host: ").append(this._future.getURI().getHost()).append(":").append(this._future.getURI().getPort()).append("\r\n").append("Upgrade: websocket\r\n").append("Connection: Upgrade\r\n").append("Sec-WebSocket-Key: ").append(this._key).append("\r\n");
                if (origin != null) {
                    request.append("Origin: ").append(origin).append("\r\n");
                }
                request.append("Sec-WebSocket-Version: ").append(13).append("\r\n");
                if (this._future.getProtocol() != null) {
                    request.append("Sec-WebSocket-Protocol: ").append(this._future.getProtocol()).append("\r\n");
                }
                if ((cookies = this._future.getCookies()) != null && cookies.size() > 0) {
                    for (String cookie : cookies.keySet()) {
                        request.append("Cookie: ").append(QuotedStringTokenizer.quoteIfNeeded(cookie, "\"\\\n\r\t\f\b%+ ;=")).append("=").append(QuotedStringTokenizer.quoteIfNeeded(cookies.get(cookie), "\"\\\n\r\t\f\b%+ ;=")).append("\r\n");
                    }
                }
                request.append("\r\n");
                this._handshake = new ByteArrayBuffer(request.toString(), false);
            }
            try {
                int len = this._handshake.length();
                int flushed = this._endp.flush(this._handshake);
                if (flushed < 0) {
                    throw new IOException("incomplete handshake");
                }
            }
            catch (IOException e) {
                this._future.handshakeFailed(e);
            }
            return this._handshake.length() == 0;
        }

        public Connection handle() throws IOException {
            while (this._endp.isOpen() && !this._parser.isComplete()) {
                if (!(this._handshake != null && this._handshake.length() <= 0 || this.handshake())) {
                    return this;
                }
                if (this._parser.parseAvailable()) continue;
                if (this._endp.isInputShutdown()) {
                    this._future.handshakeFailed(new IOException("Incomplete handshake response"));
                }
                return this;
            }
            if (this._error == null) {
                if (this._accept == null) {
                    this._error = "No Sec-WebSocket-Accept";
                } else if (!WebSocketConnectionRFC6455.hashKey(this._key).equals(this._accept)) {
                    this._error = "Bad Sec-WebSocket-Accept";
                } else {
                    WebSocketConnection connection = this.newWebSocketConnection();
                    Buffer header = this._parser.getHeaderBuffer();
                    if (header.hasContent()) {
                        connection.fillBuffersFrom(header);
                    }
                    WebSocketClientFactory.this._buffers.returnBuffer(header);
                    this._future.onConnection(connection);
                    return connection;
                }
            }
            this._endp.close();
            return this;
        }

        private WebSocketConnection newWebSocketConnection() throws IOException {
            __log.debug("newWebSocketConnection()", new Object[0]);
            return new WebSocketClientConnection(this._future._client.getFactory(), this._future.getWebSocket(), this._endp, WebSocketClientFactory.this._buffers, System.currentTimeMillis(), this._future.getMaxIdleTime(), this._future.getProtocol(), null, 13, this._future.getMaskGen());
        }

        public void onInputShutdown() throws IOException {
            this._endp.close();
        }

        public boolean isIdle() {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public void onClose() {
            if (this._error != null) {
                this._future.handshakeFailed(new ProtocolException(this._error));
            } else {
                this._future.handshakeFailed(new EOFException());
            }
        }
    }

    class WebSocketClientSelector
    extends SelectorManager {
        WebSocketClientSelector() {
        }

        public boolean dispatch(Runnable task) {
            return WebSocketClientFactory.this._threadPool.dispatch(task);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
            SelectChannelEndPoint result;
            WebSocketClient.WebSocketFuture holder = (WebSocketClient.WebSocketFuture)key.attachment();
            int maxIdleTime = holder.getMaxIdleTime();
            if (maxIdleTime < 0) {
                maxIdleTime = (int)this.getMaxIdleTime();
            }
            AsyncEndPoint endPoint = result = new SelectChannelEndPoint(channel, selectSet, key, maxIdleTime);
            if ("wss".equals(holder.getURI().getScheme())) {
                SSLEngine sslEngine = WebSocketClientFactory.this.newSslEngine(channel);
                SslConnection sslConnection = new SslConnection(sslEngine, endPoint);
                endPoint.setConnection(sslConnection);
                endPoint = sslConnection.getSslEndPoint();
            }
            AsyncConnection connection = selectSet.getManager().newConnection(channel, endPoint, holder);
            endPoint.setConnection(connection);
            return result;
        }

        public AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint, Object attachment) {
            WebSocketClient.WebSocketFuture holder = (WebSocketClient.WebSocketFuture)attachment;
            return new HandshakeConnection(endpoint, holder);
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
        }

        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
            LOG.debug("upgrade {} -> {}", oldConnection, endpoint.getConnection());
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            endpoint.getConnection().onClose();
        }

        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            if (!(attachment instanceof WebSocketClient.WebSocketFuture)) {
                super.connectionFailed(channel, ex, attachment);
            } else {
                __log.debug(ex);
                WebSocketClient.WebSocketFuture future = (WebSocketClient.WebSocketFuture)attachment;
                future.handshakeFailed(ex);
            }
        }
    }
}

