/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Random;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point2f;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Size;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"interMode", "borderMode", "borderValue", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WarpImageTransform
extends BaseImageTransform<Mat> {
    private float[] deltas;
    int interMode = 1;
    int borderMode = 0;
    Scalar borderValue = Scalar.ZERO;
    private Mat M;

    public WarpImageTransform(float delta) {
        this(null, delta, delta, delta, delta, delta, delta, delta, delta);
    }

    public WarpImageTransform(Random random, float delta) {
        this(random, delta, delta, delta, delta, delta, delta, delta, delta);
    }

    public WarpImageTransform(@JsonProperty(value="deltas[0]") float dx1, @JsonProperty(value="deltas[1]") float dy1, @JsonProperty(value="deltas[2]") float dx2, @JsonProperty(value="deltas[3]") float dy2, @JsonProperty(value="deltas[4]") float dx3, @JsonProperty(value="deltas[5]") float dy3, @JsonProperty(value="deltas[6]") float dx4, @JsonProperty(value="deltas[7]") float dy4) {
        this(null, dx1, dy1, dx2, dy2, dx3, dy3, dx4, dy4);
    }

    public WarpImageTransform(Random random, float dx1, float dy1, float dx2, float dy2, float dx3, float dy3, float dx4, float dy4) {
        super(random);
        this.deltas = new float[8];
        this.deltas[0] = dx1;
        this.deltas[1] = dy1;
        this.deltas[2] = dx2;
        this.deltas[3] = dy2;
        this.deltas[4] = dx3;
        this.deltas[5] = dy3;
        this.deltas[6] = dx4;
        this.deltas[7] = dy4;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        Mat mat = (Mat)this.converter.convert(image.getFrame());
        Point2f src = new Point2f(4L);
        Point2f dst = new Point2f(4L);
        src.put(new float[]{0.0f, 0.0f, mat.cols(), 0.0f, mat.cols(), mat.rows(), 0.0f, mat.rows()});
        for (int i = 0; i < 8; ++i) {
            dst.put((long)i, src.get((long)i) + this.deltas[i] * (random != null ? 2.0f * random.nextFloat() - 1.0f : 1.0f));
        }
        Mat result = new Mat();
        this.M = opencv_imgproc.getPerspectiveTransform((Point2f)src, (Point2f)dst);
        opencv_imgproc.warpPerspective((Mat)mat, (Mat)result, (Mat)this.M, (Size)mat.size(), (int)this.interMode, (int)this.borderMode, (Scalar)this.borderValue);
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        Mat src = new Mat(1, coordinates.length / 2, opencv_core.CV_32FC2, (Pointer)new FloatPointer(coordinates));
        Mat dst = new Mat();
        opencv_core.perspectiveTransform((Mat)src, (Mat)dst, (Mat)this.M);
        FloatBuffer buf = (FloatBuffer)dst.createBuffer();
        float[] transformed = new float[coordinates.length];
        buf.get(transformed);
        return transformed;
    }

    public float[] deltas() {
        return this.deltas;
    }

    public Mat M() {
        return this.M;
    }

    public WarpImageTransform deltas(float[] deltas) {
        this.deltas = deltas;
        return this;
    }

    public WarpImageTransform M(Mat M) {
        this.M = M;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WarpImageTransform)) {
            return false;
        }
        WarpImageTransform other = (WarpImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.interMode() != other.interMode()) {
            return false;
        }
        if (this.borderMode() != other.borderMode()) {
            return false;
        }
        if (!Arrays.equals(this.deltas(), other.deltas())) {
            return false;
        }
        Scalar this$borderValue = this.borderValue();
        Scalar other$borderValue = other.borderValue();
        if (this$borderValue == null ? other$borderValue != null : !this$borderValue.equals(other$borderValue)) {
            return false;
        }
        Mat this$M = this.M();
        Mat other$M = other.M();
        return !(this$M == null ? other$M != null : !this$M.equals(other$M));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WarpImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.interMode();
        result = result * 59 + this.borderMode();
        result = result * 59 + Arrays.hashCode(this.deltas());
        Scalar $borderValue = this.borderValue();
        result = result * 59 + ($borderValue == null ? 43 : $borderValue.hashCode());
        Mat $M = this.M();
        result = result * 59 + ($M == null ? 43 : $M.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WarpImageTransform(deltas=" + Arrays.toString(this.deltas()) + ", interMode=" + this.interMode() + ", borderMode=" + this.borderMode() + ", borderValue=" + this.borderValue() + ", M=" + this.M() + ")";
    }

    public int interMode() {
        return this.interMode;
    }

    public WarpImageTransform interMode(int interMode) {
        this.interMode = interMode;
        return this;
    }

    public int borderMode() {
        return this.borderMode;
    }

    public WarpImageTransform borderMode(int borderMode) {
        this.borderMode = borderMode;
        return this;
    }

    public Scalar borderValue() {
        return this.borderValue;
    }

    public WarpImageTransform borderValue(Scalar borderValue) {
        this.borderValue = borderValue;
        return this;
    }
}

