/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"rng", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RandomCropTransform
extends BaseImageTransform<Mat> {
    protected int outputHeight;
    protected int outputWidth;
    protected Random rng;
    private int x;
    private int y;

    public RandomCropTransform(@JsonProperty(value="outputHeight") int height, @JsonProperty(value="outputWidth") int width) {
        this(1234L, height, width);
    }

    public RandomCropTransform(long seed, int height, int width) {
        this(null, seed, height, width);
    }

    public RandomCropTransform(java.util.Random random, long seed, int height, int width) {
        super(random);
        this.outputHeight = height;
        this.outputWidth = width;
        this.rng = Nd4j.getRandom();
        this.rng.setSeed(seed);
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, java.util.Random random) {
        if (image == null) {
            return null;
        }
        if (image.getFrame().imageHeight < this.outputHeight || image.getFrame().imageWidth < this.outputWidth) {
            throw new UnsupportedOperationException("Output height/width cannot be more than the input image. Requested: " + this.outputHeight + "+x" + this.outputWidth + ", got " + image.getFrame().imageHeight + "+x" + image.getFrame().imageWidth);
        }
        int cropTop = image.getFrame().imageHeight - this.outputHeight;
        int cropLeft = image.getFrame().imageWidth - this.outputWidth;
        Mat mat = (Mat)this.converter.convert(image.getFrame());
        int top = this.rng.nextInt(cropTop + 1);
        int left = this.rng.nextInt(cropLeft + 1);
        this.y = Math.min(top, mat.rows() - 1);
        this.x = Math.min(left, mat.cols() - 1);
        Mat result = mat.apply(new Rect(this.x, this.y, this.outputWidth, this.outputHeight));
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = coordinates[i] - (float)this.x;
            transformed[i + 1] = coordinates[i + 1] - (float)this.y;
        }
        return transformed;
    }

    public int getOutputHeight() {
        return this.outputHeight;
    }

    public int getOutputWidth() {
        return this.outputWidth;
    }

    public Random getRng() {
        return this.rng;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setOutputHeight(int outputHeight) {
        this.outputHeight = outputHeight;
    }

    public void setOutputWidth(int outputWidth) {
        this.outputWidth = outputWidth;
    }

    public void setRng(Random rng) {
        this.rng = rng;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomCropTransform)) {
            return false;
        }
        RandomCropTransform other = (RandomCropTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOutputHeight() != other.getOutputHeight()) {
            return false;
        }
        if (this.getOutputWidth() != other.getOutputWidth()) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        Random this$rng = this.getRng();
        Random other$rng = other.getRng();
        return !(this$rng == null ? other$rng != null : !this$rng.equals(other$rng));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RandomCropTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOutputHeight();
        result = result * 59 + this.getOutputWidth();
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        Random $rng = this.getRng();
        result = result * 59 + ($rng == null ? 43 : $rng.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RandomCropTransform(outputHeight=" + this.getOutputHeight() + ", outputWidth=" + this.getOutputWidth() + ", rng=" + this.getRng() + ", x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

