/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.v2_0;

import groovy.lang.Binding;
import org.codehaus.gmaven.feature.Component;
import org.codehaus.gmaven.feature.Configuration;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.support.ComponentSupport;
import org.codehaus.gmaven.feature.support.FeatureSupport;
import org.codehaus.gmaven.runtime.Shell;
import org.codehaus.gmaven.runtime.support.util.NoExitSecurityManager;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.Main;
import org.codehaus.groovy.tools.shell.util.Logger;
import org.sonatype.gshell.io.StreamSet;

public class ShellFeature
extends FeatureSupport {
    public ShellFeature() {
        super(Shell.KEY);
    }

    protected Component doCreate() throws Exception {
        return new ShellImpl();
    }

    private class DefaultTask
    implements Shell.Keys,
    Task {
        private final IO io;
        private final String args;

        public DefaultTask(Configuration config) {
            String term;
            String color;
            assert (config != null);
            Logger.io = this.io = new IO();
            if (config.get("verbose", false)) {
                this.io.setVerbosity(IO.Verbosity.VERBOSE);
            }
            if (config.get("debug", false)) {
                this.io.setVerbosity(IO.Verbosity.DEBUG);
            }
            if (config.get("quiet", false)) {
                this.io.setVerbosity(IO.Verbosity.QUIET);
            }
            if ((color = config.get("color", Boolean.TRUE.toString())) != null) {
                Main.setColor((Object)color);
            }
            if ((term = config.get("terminal", (String)null)) != null) {
                Main.setTerminalType((String)term);
            }
            this.args = config.get("args", (String)null);
        }

        public void run(ClassLoader classLoader) throws Exception {
            assert (classLoader != null);
            Groovysh shell = new Groovysh(classLoader, new Binding(), this.io);
            shell.run(this.args);
        }
    }

    private static interface Task {
        public void run(ClassLoader var1) throws Exception;
    }

    private class ShellImpl
    extends ComponentSupport
    implements Shell,
    Shell.Keys {
        private ShellImpl() throws Exception {
            super((Feature)ShellFeature.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ClassLoader classLoader) throws Exception {
            assert (classLoader != null);
            boolean legacy = this.config().get("legacy", false);
            StreamSet streams = StreamSet.system();
            streams.out.println();
            SecurityManager sm = System.getSecurityManager();
            System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
            try {
                if (!legacy) {
                    new DefaultTask(this.config()).run(classLoader);
                } else {
                    this.log.warn("Legacy task not supported in 2.0.  Using default task.");
                    new DefaultTask(this.config()).run(classLoader);
                }
            }
            finally {
                System.setSecurityManager(sm);
                StreamSet.system((StreamSet)streams);
            }
            streams.out.println();
        }
    }
}

