/*
 * Decompiled with CFR 0.152.
 */
package org.cef.network;

import org.cef.network.CefPostDataElement_N;

public abstract class CefPostDataElement {
    CefPostDataElement() {
    }

    public static CefPostDataElement create() {
        return CefPostDataElement_N.createNative();
    }

    public abstract boolean isReadOnly();

    public abstract void setToEmpty();

    public abstract void setToFile(String var1);

    public abstract void setToBytes(int var1, byte[] var2);

    public abstract Type getType();

    public abstract String getFile();

    public abstract int getBytesCount();

    public abstract int getBytes(int var1, byte[] var2);

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        int n = this.getBytesCount();
        byte[] byArray = null;
        if (n > 0) {
            byArray = new byte[n];
        }
        boolean bl = false;
        if (string != null) {
            if (string.startsWith("text/")) {
                bl = true;
            } else if (string.startsWith("application/xml")) {
                bl = true;
            } else if (string.startsWith("application/xhtml")) {
                bl = true;
            } else if (string.startsWith("application/x-www-form-urlencoded")) {
                bl = true;
            }
        }
        String string2 = "";
        if (this.getType() == Type.PDE_TYPE_BYTES) {
            int n2 = this.getBytes(byArray.length, byArray);
            string2 = string2 + "    Content-Length: " + n + "\n";
            if (bl) {
                string2 = string2 + "\n    " + new String(byArray);
            } else {
                for (int i = 0; i < n2; ++i) {
                    if (i % 40 == 0) {
                        string2 = string2 + "\n    ";
                    }
                    string2 = string2 + String.format("%02X", byArray[i]) + " ";
                }
            }
            string2 = string2 + "\n";
        } else if (this.getType() == Type.PDE_TYPE_FILE) {
            string2 = string2 + "\n    Bytes of file: " + this.getFile() + "\n";
        }
        return string2;
    }

    public static enum Type {
        PDE_TYPE_EMPTY,
        PDE_TYPE_BYTES,
        PDE_TYPE_FILE;

    }
}

