/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WGLUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsExternalWGLContext
extends WindowsWGLContext {
    private WindowsExternalWGLContext(Drawable drawable, long l, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration) {
        super(drawable, null);
        this.contextHandle = l;
        if (DEBUG) {
            System.err.println(WindowsExternalWGLContext.getThreadName() + ": Created external OpenGL context " + WindowsExternalWGLContext.toHexString(l) + " for " + this);
        }
        GLContextShareSet.contextCreated(this);
        if (!this.setGLFunctionAvailability(false, 0, 0, 2, false, false)) {
            throw new InternalError("setGLFunctionAvailability !strictMatch failed");
        }
        this.getGLStateTracker().setEnabled(false);
    }

    protected static WindowsExternalWGLContext create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration;
        long l;
        if (DEBUG) {
            System.err.println("WindowsExternalWGLContext 0: werr: " + GDI.GetLastError());
        }
        if (0L == (l = WGL.wglGetCurrentContext())) {
            throw new GLException("Error: attempted to make an external GLContext without a context current, werr " + GDI.GetLastError());
        }
        long l2 = WGL.wglGetCurrentDC();
        if (0L == l2) {
            throw new GLException("Error: attempted to make an external GLDrawable without a drawable current, werr " + GDI.GetLastError());
        }
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault(NativeWindowFactory.TYPE_WINDOWS);
        int n = WGLUtil.GetPixelFormat(l2);
        if (0 == n) {
            int n2 = GDI.GetLastError();
            windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.createDefaultGraphicsConfiguration(new GLCapabilities(GLProfile.getDefault()), abstractGraphicsScreen);
            windowsWGLGraphicsConfiguration.markExternal();
            if (DEBUG) {
                System.err.println("WindowsExternalWGLContext invalid hdc/pfd werr " + n2 + ", using default cfg: " + windowsWGLGraphicsConfiguration);
            }
        } else {
            windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfiguration.createFromExternal(gLDrawableFactory, l2, n, gLProfile, abstractGraphicsScreen, true);
            if (DEBUG) {
                System.err.println("WindowsExternalWGLContext valid hdc/pfd, retrieved cfg: " + windowsWGLGraphicsConfiguration);
            }
        }
        return new WindowsExternalWGLContext(new Drawable(gLDrawableFactory, new WrappedSurface(windowsWGLGraphicsConfiguration, l2, 64, 64, true)), l, windowsWGLGraphicsConfiguration);
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
    }

    @Override
    protected void releaseImpl() throws GLException {
    }

    @Override
    protected void destroyImpl() throws GLException {
    }

    static class Drawable
    extends WindowsWGLDrawable {
        Drawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
            super(gLDrawableFactory, nativeSurface, true);
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Should not call this");
        }

        @Override
        public int getSurfaceWidth() {
            throw new GLException("Should not call this");
        }

        @Override
        public int getSurfaceHeight() {
            throw new GLException("Should not call this");
        }

        public void setSize(int n, int n2) {
            throw new GLException("Should not call this");
        }
    }
}

