/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.bcm.vc.iv;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.PNGPixelRect;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.PixelFormat;
import jogamp.newt.DisplayImpl;
import jogamp.newt.NEWTJNILibLoader;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.driver.bcm.vc.iv.ScreenDriver;
import jogamp.newt.driver.bcm.vc.iv.WindowDriver;
import jogamp.newt.driver.linux.LinuxMouseTracker;
import jogamp.opengl.egl.EGLDisplayUtil;

public class DisplayDriver
extends DisplayImpl {
    static final PNGPixelRect defaultPointerIconImage;
    private PointerIconImpl defaultPointerIcon = null;
    private long bcmHandle = 0L;
    private long activePointerIcon = 0L;
    private boolean activePointerIconVisible = false;
    private final Object pointerIconSync = new Object();

    public static void initSingleton() {
    }

    @Override
    protected void createNativeImpl() {
        this.bcmHandle = DisplayDriver.OpenBCMDisplay0();
        this.aDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(0L, "decon", 0);
        this.aDevice.open();
        this.defaultPointerIcon = (PointerIconImpl)this.createPointerIcon(defaultPointerIconImage, 0, 0);
        if (DEBUG_POINTER_ICON) {
            System.err.println("Display.PointerIcon.createDefault: " + this.defaultPointerIcon);
        }
        if (null != this.defaultPointerIcon) {
            LinuxMouseTracker linuxMouseTracker = LinuxMouseTracker.getSingleton();
            this.setPointerIconActive(this.defaultPointerIcon.getHandle(), linuxMouseTracker.getLastX(), linuxMouseTracker.getLastY());
        }
    }

    @Override
    protected void closeNativeImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        abstractGraphicsDevice.close();
        DisplayDriver.CloseBCMDisplay0(this.bcmHandle);
        this.bcmHandle = 0L;
    }

    final long getBCMHandle() {
        return this.bcmHandle;
    }

    @Override
    protected void dispatchMessagesNative() {
        DisplayDriver.DispatchMessages0();
    }

    @Override
    protected final long createPointerIconImpl(PixelFormat pixelFormat, int n, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        return DisplayDriver.CreatePointerIcon(this.bcmHandle, byteBuffer, n, n2, n3, n4);
    }

    @Override
    protected final void destroyPointerIconImpl(long l, long l2) {
        DisplayDriver.DestroyPointerIcon0(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPointerIconActive(long l, int n, int n2) {
        Object object = this.pointerIconSync;
        synchronized (object) {
            if (DEBUG_POINTER_ICON) {
                System.err.println("Display.PointerIcon.set.0: active [" + DisplayDriver.toHexString(this.activePointerIcon) + ", visible " + this.activePointerIconVisible + "] -> " + DisplayDriver.toHexString(l));
            }
            if (0L != this.activePointerIcon && this.activePointerIconVisible) {
                DisplayDriver.SetPointerIcon0(this.bcmHandle, this.activePointerIcon, false, n, n2);
            }
            if (0L == l && null != this.defaultPointerIcon) {
                l = this.defaultPointerIcon.getHandle();
            }
            if (0L != l) {
                DisplayDriver.SetPointerIcon0(this.bcmHandle, l, true, n, n2);
                this.activePointerIconVisible = true;
            } else {
                this.activePointerIconVisible = false;
            }
            this.activePointerIcon = l;
            if (DEBUG_POINTER_ICON) {
                System.err.println("Display.PointerIcon.set.X: active [" + DisplayDriver.toHexString(this.activePointerIcon) + ", visible " + this.activePointerIconVisible + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActivePointerIconVisible(boolean bl, int n, int n2) {
        Object object = this.pointerIconSync;
        synchronized (object) {
            if (DEBUG_POINTER_ICON) {
                System.err.println("Display.PointerIcon.visible: active [" + DisplayDriver.toHexString(this.activePointerIcon) + ", visible " + this.activePointerIconVisible + "] -> visible " + bl);
            }
            if (this.activePointerIconVisible != bl) {
                if (0L != this.activePointerIcon) {
                    DisplayDriver.SetPointerIcon0(this.bcmHandle, this.activePointerIcon, bl, n, n2);
                }
                this.activePointerIconVisible = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveActivePointerIcon(int n, int n2) {
        Object object = this.pointerIconSync;
        synchronized (object) {
            if (DEBUG_POINTER_ICON) {
                System.err.println("Display.PointerIcon.move: active [" + DisplayDriver.toHexString(this.activePointerIcon) + ", visible " + this.activePointerIconVisible + "], " + n + "/" + n2);
            }
            if (0L != this.activePointerIcon && this.activePointerIconVisible) {
                DisplayDriver.MovePointerIcon0(this.activePointerIcon, n, n2);
            }
        }
    }

    protected static native boolean initIDs();

    private static native long OpenBCMDisplay0();

    private static native void CloseBCMDisplay0(long var0);

    private static long CreatePointerIcon(long l, Buffer buffer, int n, int n2, int n3, int n4) {
        boolean bl = Buffers.isDirect(buffer);
        return DisplayDriver.CreatePointerIcon0(bl ? buffer : Buffers.getArray(buffer), bl ? Buffers.getDirectBufferByteOffset(buffer) : Buffers.getIndirectBufferByteOffset(buffer), bl, n, n2, n3, n4);
    }

    private static native long CreatePointerIcon0(Object var0, int var1, boolean var2, int var3, int var4, int var5, int var6);

    private static native void DestroyPointerIcon0(long var0);

    private static native void SetPointerIcon0(long var0, long var2, boolean var4, int var5, int var6);

    private static native void MovePointerIcon0(long var0, int var2, int var3);

    private static native void DispatchMessages0();

    static {
        NEWTJNILibLoader.loadNEWT();
        if (!DisplayDriver.initIDs()) {
            throw new NativeWindowException("Failed to initialize bcm.vc.iv Display jmethodIDs");
        }
        if (!ScreenDriver.initIDs()) {
            throw new NativeWindowException("Failed to initialize bcm.vc.iv Screen jmethodIDs");
        }
        if (!WindowDriver.initIDs()) {
            throw new NativeWindowException("Failed to initialize bcm.vc.iv Window jmethodIDs");
        }
        PNGPixelRect pNGPixelRect = null;
        if (DisplayImpl.isPNGUtilAvailable()) {
            IOUtil.ClassResources classResources = new IOUtil.ClassResources(DisplayDriver.class, new String[]{"newt/data/pointer-grey-alpha-16x24.png"});
            try {
                URLConnection uRLConnection = classResources.resolve(0);
                pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), PixelFormat.BGRA8888, false, 0, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        defaultPointerIconImage = pNGPixelRect;
    }
}

