/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.ProtonFactory;

public class ProtonFactoryLoader<C extends ProtonFactory> {
    public static final String IMPLEMENTATION_TYPE_PROPERTY = "qpid.proton.implementationtype";
    private static final Logger LOGGER = Logger.getLogger(ProtonFactoryLoader.class.getName());
    private final Class<C> _factoryInterface;
    private final ProtonFactory.ImplementationType _implementationType;

    public ProtonFactoryLoader() {
        this(null);
    }

    public ProtonFactoryLoader(Class<C> factoryInterface) {
        this(factoryInterface, ProtonFactoryLoader.getImpliedImplementationType());
    }

    static ProtonFactory.ImplementationType getImpliedImplementationType() {
        String implementationTypeFromSystemProperty = System.getProperty(IMPLEMENTATION_TYPE_PROPERTY);
        if (implementationTypeFromSystemProperty != null) {
            return ProtonFactory.ImplementationType.valueOf(implementationTypeFromSystemProperty);
        }
        return ProtonFactory.ImplementationType.ANY;
    }

    public ProtonFactoryLoader(Class<C> factoryInterface, ProtonFactory.ImplementationType implementationType) {
        this._factoryInterface = factoryInterface;
        this._implementationType = implementationType;
    }

    public C loadFactory() {
        return this.loadFactory(this._factoryInterface);
    }

    public C loadFactory(Class<C> factoryInterface) {
        if (factoryInterface == null) {
            throw new IllegalStateException("factoryInterface has not been set.");
        }
        ServiceLoader<ProtonFactory> serviceLoader = ServiceLoader.load(factoryInterface);
        for (ProtonFactory factory : serviceLoader) {
            if (this._implementationType != ProtonFactory.ImplementationType.ANY && factory.getImplementationType() != this._implementationType) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("loadFactory returning " + factory + " for loader's implementation type " + (Object)((Object)this._implementationType));
            }
            return (C)factory;
        }
        throw new IllegalStateException("Can't find service loader for " + factoryInterface.getName() + " for implementation type " + (Object)((Object)this._implementationType));
    }
}

