/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.module.xdoc.XdocSinkFactory;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.codehaus.plexus.i18n.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteMap {
    private String encoding;
    private I18N i18n;

    public SiteMap(String encoding, I18N i18n) {
        this.encoding = encoding;
        this.i18n = i18n;
    }

    public I18N getI18n() {
        return this.i18n;
    }

    public void setI18n(I18N i18n) {
        this.i18n = i18n;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(DecorationModel model, File targetDir, Locale locale) throws IOException {
        File outputDir = new File(targetDir, "xdoc");
        Sink sink = new XdocSinkFactory().createSink(outputDir, "sitemap.xml", this.encoding);
        try {
            this.extract(model, sink, locale);
        }
        finally {
            sink.close();
        }
    }

    private void extract(DecorationModel decoration, Sink sink, Locale locale) {
        sink.head();
        sink.title();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.section.title"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.description"));
        sink.paragraph_();
        for (Menu menu : decoration.getMenus()) {
            sink.section3();
            sink.sectionTitle3();
            sink.text(menu.getName());
            sink.sectionTitle3_();
            sink.horizontalRule();
            SiteMap.extractItems(menu.getItems(), sink);
            sink.section3_();
        }
        sink.section1_();
        sink.body_();
    }

    private static void extractItems(List<MenuItem> items, Sink sink) {
        if (items == null || items.isEmpty()) {
            return;
        }
        sink.list();
        for (MenuItem item : items) {
            sink.listItem();
            sink.link(SiteMap.relativePath(item.getHref()));
            sink.text(item.getName());
            sink.link_();
            SiteMap.extractItems(item.getItems(), sink);
            sink.listItem_();
        }
        sink.list_();
    }

    private static String relativePath(String href) {
        return href.startsWith("/") ? "." + href : href;
    }
}

