/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorMapJoinInnerStringOperator
extends VectorMapJoinInnerGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinInnerStringOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinInnerStringOperator.class.getName();
    private transient VectorMapJoinBytesHashMap hashMap;
    private transient int singleJoinColumn;

    public VectorMapJoinInnerStringOperator() {
    }

    public VectorMapJoinInnerStringOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinBytesHashMap)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            this.innerPerBatchSetup(batch);
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            int numSel = 0;
            BytesColumnVector joinColVector = (BytesColumnVector)batch.cols[this.singleJoinColumn];
            byte[][] vector = joinColVector.vector;
            int[] start = joinColVector.start;
            int[] length = joinColVector.length;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                byte[] keyBytes = vector[0];
                int keyStart = start[0];
                int keyLength = length[0];
                JoinUtil.JoinResult joinResult = this.hashMap.lookup(keyBytes, keyStart, keyLength, this.hashMapResults[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name()));
                }
                numSel = this.finishInnerRepeated(batch, joinResult, this.hashMapResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated"));
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                int saveKeyBatchIndex = -1;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex;
                    int n = batchIndex = selectedInUse ? selected[logical] : logical;
                    if (!haveSaveKey || StringExpr.compare(vector[saveKeyBatchIndex], start[saveKeyBatchIndex], length[saveKeyBatchIndex], vector[batchIndex], start[batchIndex], length[batchIndex]) != 0) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++hashMapResultCount;
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        saveKeyBatchIndex = batchIndex;
                        byte[] keyBytes = vector[batchIndex];
                        int keyStart = start[batchIndex];
                        int keyLength = length[batchIndex];
                        saveJoinResult = this.hashMap.lookup(keyBytes, keyStart, keyLength, this.hashMapResults[hashMapResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesHashMapResultIndices[equalKeySeriesCount] = hashMapResultCount;
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesIsSingleValue[equalKeySeriesCount] = this.hashMapResults[hashMapResultCount].isSingleRow();
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n2 = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n2] = this.equalKeySeriesDuplicateCounts[n2] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++hashMapResultCount;
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " allMatchs " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesHashMapResultIndices " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.equalKeySeriesHashMapResultIndices, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesIsSingleValue " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesIsSingleValue, 0, equalKeySeriesCount)) + " equalKeySeriesDuplicateCounts " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesDuplicateCounts, 0, equalKeySeriesCount)) + " spills " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinInnerStringOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount))));
                }
                numSel = this.finishInner(batch, this.allMatchs, allMatchCount, this.equalKeySeriesHashMapResultIndices, this.equalKeySeriesAllMatchIndices, this.equalKeySeriesIsSingleValue, this.equalKeySeriesDuplicateCounts, equalKeySeriesCount, this.spills, this.spillHashMapResultIndices, spillCount, this.hashMapResults, hashMapResultCount);
            }
            batch.selectedInUse = true;
            batch.size = numSel;
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

