/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestWebAppUtils {
    @Test
    public void testGetPassword() throws Exception {
        Configuration conf = this.provisionCredentialsForSSL();
        Assert.assertEquals((Object)"keypass", (Object)WebAppUtils.getPassword((Configuration)conf, (String)"ssl.server.keystore.keypassword"));
        Assert.assertEquals((Object)"storepass", (Object)WebAppUtils.getPassword((Configuration)conf, (String)"ssl.server.keystore.password"));
        Assert.assertEquals((Object)"trustpass", (Object)WebAppUtils.getPassword((Configuration)conf, (String)"ssl.server.truststore.password"));
        Assert.assertEquals(null, (Object)WebAppUtils.getPassword((Configuration)conf, (String)"invalid-alias"));
    }

    @Test
    public void testLoadSslConfiguration() throws Exception {
        Configuration conf = this.provisionCredentialsForSSL();
        TestBuilder builder = new TestBuilder();
        builder = (TestBuilder)WebAppUtils.loadSslConfiguration((HttpServer2.Builder)builder, (Configuration)conf);
        String keypass = "keypass";
        String storepass = "storepass";
        String trustpass = "trustpass";
        Assert.assertEquals((Object)keypass, (Object)builder.keypass);
        Assert.assertEquals((Object)storepass, (Object)builder.keystorePassword);
        Assert.assertEquals((Object)trustpass, (Object)builder.truststorePassword);
    }

    protected Configuration provisionCredentialsForSSL() throws IOException, Exception {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] keypass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        char[] trustpass = new char[]{'t', 'r', 'u', 's', 't', 'p', 'a', 's', 's'};
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.keystore.keypassword"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.keystore.password"));
        Assert.assertEquals(null, (Object)provider.getCredentialEntry("ssl.server.truststore.password"));
        try {
            provider.createCredentialEntry("ssl.server.keystore.keypassword", keypass);
            provider.createCredentialEntry("ssl.server.keystore.password", storepass);
            provider.createCredentialEntry("ssl.server.truststore.password", trustpass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Assert.assertArrayEquals((char[])keypass, (char[])provider.getCredentialEntry("ssl.server.keystore.keypassword").getCredential());
        Assert.assertArrayEquals((char[])storepass, (char[])provider.getCredentialEntry("ssl.server.keystore.password").getCredential());
        Assert.assertArrayEquals((char[])trustpass, (char[])provider.getCredentialEntry("ssl.server.truststore.password").getCredential());
        return conf;
    }

    public class TestBuilder
    extends HttpServer2.Builder {
        public String keypass;
        public String keystorePassword;
        public String truststorePassword;

        public HttpServer2.Builder trustStore(String location, String password, String type) {
            this.truststorePassword = password;
            return super.trustStore(location, password, type);
        }

        public HttpServer2.Builder keyStore(String location, String password, String type) {
            this.keystorePassword = password;
            return super.keyStore(location, password, type);
        }

        public HttpServer2.Builder keyPassword(String password) {
            this.keypass = password;
            return super.keyPassword(password);
        }
    }
}

