/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.filesystem.DefaultPartTimeExtractor;

@Experimental
public interface PartitionTimeExtractor
extends Serializable {
    public static final String DEFAULT = "default";
    public static final String CUSTOM = "custom";

    public LocalDateTime extract(List<String> var1, List<String> var2);

    public static PartitionTimeExtractor create(ClassLoader userClassLoader, String extractorKind, String extractorClass, String extractorPattern) {
        switch (extractorKind) {
            case "default": {
                return new DefaultPartTimeExtractor(extractorPattern);
            }
            case "custom": {
                try {
                    return (PartitionTimeExtractor)userClassLoader.loadClass(extractorClass).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Can not new instance for custom class from " + extractorClass, e);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported extractor kind: " + extractorKind);
    }
}

