/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.expressions.PlannerNamedWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerProctimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerRowtimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerWindowEnd;
import org.apache.flink.table.planner.expressions.PlannerWindowStart;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.rules.logical.WindowPropertiesHavingRule;
import org.apache.flink.table.planner.plan.rules.logical.WindowPropertiesRule;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

public final class WindowPropertiesRules$ {
    public static WindowPropertiesRules$ MODULE$;
    private final WindowPropertiesHavingRule WINDOW_PROPERTIES_HAVING_RULE;
    private final WindowPropertiesRule WINDOW_PROPERTIES_RULE;

    static {
        new WindowPropertiesRules$();
    }

    public WindowPropertiesHavingRule WINDOW_PROPERTIES_HAVING_RULE() {
        return this.WINDOW_PROPERTIES_HAVING_RULE;
    }

    public WindowPropertiesRule WINDOW_PROPERTIES_RULE() {
        return this.WINDOW_PROPERTIES_RULE;
    }

    public RelNode convertWindowNodes(RelBuilder builder, LogicalProject project, Option<LogicalFilter> filter, LogicalProject innerProject, LogicalWindowAggregate agg) {
        Seq seq;
        String string;
        LogicalWindow w = agg.getWindow();
        Symbol windowType = this.getWindowType(w);
        Seq startEndProperties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlannerNamedWindowProperty[]{new PlannerNamedWindowProperty(this.propertyName(w, "start"), new PlannerWindowStart(w.aliasAttribute())), new PlannerNamedWindowProperty(this.propertyName(w, "end"), new PlannerWindowEnd(w.aliasAttribute()))}));
        Symbol symbol = windowType;
        Option option = Symbol$.MODULE$.unapply((Object)symbol);
        if (!option.isEmpty() && "streamRowtime".equals(string = (String)option.get())) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlannerNamedWindowProperty[]{new PlannerNamedWindowProperty(this.propertyName(w, "rowtime"), new PlannerRowtimeAttribute(w.aliasAttribute())), new PlannerNamedWindowProperty(this.propertyName(w, "proctime"), new PlannerProctimeAttribute(w.aliasAttribute()))}));
        } else {
            String string2;
            Option option2 = Symbol$.MODULE$.unapply((Object)symbol);
            if (!option2.isEmpty() && "streamProctime".equals(string2 = (String)option2.get())) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlannerNamedWindowProperty[]{new PlannerNamedWindowProperty(this.propertyName(w, "proctime"), new PlannerProctimeAttribute(w.aliasAttribute()))}));
            } else {
                String string3;
                Option option3 = Symbol$.MODULE$.unapply((Object)symbol);
                if (!option3.isEmpty() && "batchRowtime".equals(string3 = (String)option3.get())) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlannerNamedWindowProperty[]{new PlannerNamedWindowProperty(this.propertyName(w, "rowtime"), new PlannerRowtimeAttribute(w.aliasAttribute()))}));
                } else {
                    throw new TableException("Unknown window type encountered. Please report this bug.");
                }
            }
        }
        Seq timeProperties = seq;
        Seq properties = (Seq)startEndProperties.$plus$plus((GenTraversableOnce)timeProperties, Seq$.MODULE$.canBuildFrom());
        builder.push(agg.copy((Seq<PlannerNamedWindowProperty>)properties));
        builder.project(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(innerProject.getProjects()).$plus$plus((GenTraversableOnce)properties.map((Function1 & Serializable & scala.Serializable)np -> builder.field(np.getName()), Seq$.MODULE$.canBuildFrom()))));
        filter.foreach((Function1 & Serializable & scala.Serializable)f -> builder.filter(MODULE$.replaceGroupAuxiliaries(f.getCondition(), w, builder)));
        builder.project(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.replaceGroupAuxiliaries((RexNode)expr, w, builder), Buffer$.MODULE$.canBuildFrom())), project.getRowType().getFieldNames());
        return builder.build();
    }

    private Symbol getWindowType(LogicalWindow window) {
        CallSite callSite;
        if (AggregateUtil$.MODULE$.isRowtimeAttribute(window.timeAttribute())) {
            callSite = SymbolLiteral.bootstrap("apply", "streamRowtime");
        } else if (AggregateUtil$.MODULE$.isProctimeAttribute(window.timeAttribute())) {
            callSite = SymbolLiteral.bootstrap("apply", "streamProctime");
        } else if (LogicalTypeChecks.hasRoot((LogicalType)window.timeAttribute().getOutputDataType().getLogicalType(), (LogicalTypeRoot)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            callSite = SymbolLiteral.bootstrap("apply", "batchRowtime");
        } else {
            throw new TableException("Unknown window type encountered. Please report this bug.");
        }
        return callSite;
    }

    private String propertyName(LogicalWindow window, String name) {
        return new StringBuilder(0).append(window.aliasAttribute().getName()).append(name).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RexNode replaceGroupAuxiliaries(RexNode node, LogicalWindow window, RelBuilder builder) {
        RexBuilder rexBuilder = builder.getRexBuilder();
        Symbol windowType = this.getWindowType(window);
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (this.isWindowStart(rexCall)) {
                return rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "start")), false);
            }
        }
        if (bl && this.isWindowEnd(rexCall)) {
            return rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "end")), false);
        }
        if (bl && this.isWindowRowtime(rexCall)) {
            String string;
            Option option;
            String string2;
            Symbol symbol = windowType;
            Option option2 = Symbol$.MODULE$.unapply((Object)symbol);
            boolean bl2 = !option2.isEmpty() && "streamRowtime".equals(string2 = (String)option2.get()) ? true : !(option = Symbol$.MODULE$.unapply((Object)symbol)).isEmpty() && "batchRowtime".equals(string = (String)option.get());
            if (!bl2) {
                Option option3 = Symbol$.MODULE$.unapply((Object)symbol);
                if (option3.isEmpty()) throw new TableException("Unknown window type encountered. Please report this bug.");
                String string3 = (String)option3.get();
                if (!"streamProctime".equals(string3)) throw new TableException("Unknown window type encountered. Please report this bug.");
                throw new ValidationException("A proctime window cannot provide a rowtime attribute.");
            }
            RexNode rexNode2 = rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "rowtime")), false);
            return rexNode2;
        }
        if (bl && this.isWindowProctime(rexCall)) {
            String string;
            Option option;
            String string4;
            Symbol symbol = windowType;
            Option option4 = Symbol$.MODULE$.unapply((Object)symbol);
            boolean bl3 = !option4.isEmpty() && "streamProctime".equals(string4 = (String)option4.get()) ? true : !(option = Symbol$.MODULE$.unapply((Object)symbol)).isEmpty() && "streamRowtime".equals(string = (String)option.get());
            if (!bl3) {
                Option option5 = Symbol$.MODULE$.unapply((Object)symbol);
                if (option5.isEmpty()) throw new TableException("Unknown window type encountered. Please report this bug.");
                String string5 = (String)option5.get();
                if (!"batchRowtime".equals(string5)) throw new TableException("Unknown window type encountered. Please report this bug.");
                throw new ValidationException("PROCTIME window property is not supported in batch queries.");
            }
            RexNode rexNode3 = rexBuilder.makeCast(rexCall.getType(), builder.field(this.propertyName(window, "proctime")), false);
            return rexNode3;
        }
        if (!bl) return rexNode;
        Buffer newOps = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.replaceGroupAuxiliaries((RexNode)x$1, window, builder), Buffer$.MODULE$.canBuildFrom());
        return rexCall.clone(rexCall.getType(), JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(newOps));
    }

    private boolean isWindowStart(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_START;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_START;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_START;
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowEnd(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_END;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_END;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_END;
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowRowtime(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_ROWTIME;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_ROWTIME;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_ROWTIME;
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isWindowProctime(RexNode node) {
        boolean bl;
        RexCall rexCall;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall && (rexCall = (RexCall)rexNode).getOperator().isGroupAuxiliary()) {
            boolean bl2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_PROCTIME;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_PROCTIME;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_PROCTIME;
                    SqlOperator sqlOperator4 = sqlOperator;
                    bl2 = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
                }
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasGroupAuxiliaries(RexNode node2) {
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node2;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (rexCall.getOperator().isGroupAuxiliary()) {
                return true;
            }
        }
        if (!bl) return false;
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).exists((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)WindowPropertiesRules$.MODULE$.hasGroupAuxiliaries(node)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasGroupFunction(RexNode node2) {
        boolean bl = false;
        RexCall rexCall = null;
        RexNode rexNode = node2;
        if (rexNode instanceof RexCall) {
            bl = true;
            rexCall = (RexCall)rexNode;
            if (rexCall.getOperator().isGroup()) {
                return true;
            }
        }
        if (!bl) return false;
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).exists((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)WindowPropertiesRules$.MODULE$.hasGroupFunction(node)));
    }

    private WindowPropertiesRules$() {
        MODULE$ = this;
        this.WINDOW_PROPERTIES_HAVING_RULE = new WindowPropertiesHavingRule();
        this.WINDOW_PROPERTIES_RULE = new WindowPropertiesRule();
    }
}

