/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.data.util.MapDataUtil;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods$;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.runtime.functions.SqlFunctionUtils;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalarOperatorGens$ {
    public static ScalarOperatorGens$ MODULE$;

    static {
        new ScalarOperatorGens$();
    }

    public GeneratedExpression generateBinaryArithmeticOperator(CodeGeneratorContext ctx, String operator, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        Function1<String, String> function1;
        LogicalType logicalType = resultType;
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            return this.generateDecimalBinaryArithmeticOperator(ctx, operator, decimalType, left, right);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String string = operator;
        if ("%".equals(string)) {
            Function1<String, String> function12;
            if (PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
                function12 = this.numericCasting(left.resultType(), resultType);
            } else {
                BigIntType castedType = TypeCheckUtils.isDecimal((LogicalType)left.resultType()) ? new BigIntType() : left.resultType();
                function12 = this.numericCasting(left.resultType(), (LogicalType)castedType);
            }
            function1 = function12;
        } else {
            function1 = this.numericCasting(left.resultType(), resultType);
        }
        Function1<String, String> leftCasting = function1;
        Function1<String, String> rightCasting = this.numericCasting(right.resultType(), resultType);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        return this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(7).append("(").append(resultTypeTerm).append(") (").append(leftCasting.apply(leftTerm)).append(" ").append(operator).append(" ").append(rightCasting.apply(rightTerm)).append(")").toString());
    }

    private GeneratedExpression generateDecimalBinaryArithmeticOperator(CodeGeneratorContext ctx, String operator, DecimalType resultType, GeneratedExpression left, GeneratedExpression right) {
        scala.collection.immutable.Map methods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"+"), (Object)"add"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)"subtract"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)"multiply"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/"), (Object)"divide"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"%"), (Object)"mod")}));
        return this.generateOperatorIfNotNull(ctx, (LogicalType)resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> {
            String method = (String)methods.apply((Object)operator);
            String leftCasted = (String)this.castToDec$1(left.resultType(), resultType).apply(leftTerm);
            String rightCasted = (String)this.castToDec$1(right.resultType(), resultType).apply(rightTerm);
            int precision = resultType.getPrecision();
            int scale = resultType.getScale();
            return new StringBuilder(9).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".").append(method).append("(").append(leftCasted).append(", ").append(rightCasted).append(", ").append(precision).append(", ").append(scale).append(")").toString();
        });
    }

    public GeneratedExpression generateUnaryArithmeticOperator(CodeGeneratorContext ctx, String operator, LogicalType resultType, GeneratedExpression operand) {
        return this.generateUnaryOperatorIfNotNull(ctx, resultType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)operandTerm -> {
            String string;
            if (TypeCheckUtils.isDecimal((LogicalType)operand.resultType())) {
                String string2 = operator;
                String string3 = "-";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    string = new StringBuilder(9).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".negate(").append((String)operandTerm).append(")").toString();
                    return string;
                }
            }
            if (TypeCheckUtils.isDecimal((LogicalType)operand.resultType())) {
                String string4 = operator;
                String string5 = "+";
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    string = String.valueOf(operandTerm);
                    return string;
                }
            }
            String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
            string = new StringBuilder(5).append("(").append(typeTerm).append(") ").append(operator).append("(").append((String)operandTerm).append(")").toString();
            return string;
        });
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateTemporalPlusMinus(CodeGeneratorContext ctx, boolean plus, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        block15: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        op = plus != false ? "+" : "-";
                                                        var15_7 = new Tuple2((Object)left.resultType().getTypeRoot(), (Object)right.resultType().getTypeRoot());
                                                        if (var15_7 == null) break block12;
                                                        var16_8 = (LogicalTypeRoot)var15_7._1();
                                                        var17_9 = (LogicalTypeRoot)var15_7._2();
                                                        if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var16_8) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var17_9)) break block12;
                                                        var13_10 = true;
                                                        break block13;
                                                    }
                                                    if (var15_7 == null) ** GOTO lbl-1000
                                                    var18_11 = (LogicalTypeRoot)var15_7._1();
                                                    var19_12 = (LogicalTypeRoot)var15_7._2();
                                                    if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var18_11) && LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var19_12)) {
                                                        var13_10 = true;
                                                    } else lbl-1000:
                                                    // 2 sources

                                                    {
                                                        var13_10 = false;
                                                    }
                                                }
                                                if (!var13_10) break block14;
                                                var6_13 = this.generateBinaryArithmeticOperator(ctx, op, left.resultType(), left, right);
                                                break block15;
                                            }
                                            if (var15_7 == null) break block16;
                                            var20_14 = (LogicalTypeRoot)var15_7._1();
                                            var21_15 = (LogicalTypeRoot)var15_7._2();
                                            if (!LogicalTypeRoot.DATE.equals(var20_14) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var21_15)) break block16;
                                            var22_16 = resultType.getTypeRoot();
                                            if (LogicalTypeRoot.DATE.equals(var22_16)) {
                                                var12_17 = this.generateOperatorIfNotNull(ctx, (LogicalType)new DateType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$1(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                            } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var22_16)) {
                                                var12_17 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$2(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                            } else {
                                                throw new MatchError((Object)var22_16);
                                            }
                                            var6_13 = var12_17;
                                            break block15;
                                        }
                                        if (var15_7 == null) break block17;
                                        var23_18 = (LogicalTypeRoot)var15_7._1();
                                        var24_19 = (LogicalTypeRoot)var15_7._2();
                                        if (!LogicalTypeRoot.DATE.equals(var23_18) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var24_19)) break block17;
                                        var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new DateType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$3(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                        break block15;
                                    }
                                    if (var15_7 == null) break block18;
                                    var25_20 = (LogicalTypeRoot)var15_7._1();
                                    var26_21 = (LogicalTypeRoot)var15_7._2();
                                    if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var25_20) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var26_21)) break block18;
                                    var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new TimeType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$4(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                    break block15;
                                }
                                if (var15_7 == null) break block19;
                                var27_22 = (LogicalTypeRoot)var15_7._1();
                                var28_23 = (LogicalTypeRoot)var15_7._2();
                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var27_22) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var28_23)) break block19;
                                var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new TimeType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$5(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)());
                                break block15;
                            }
                            if (var15_7 == null) break block20;
                            var29_24 = (LogicalTypeRoot)var15_7._1();
                            var30_25 = (LogicalTypeRoot)var15_7._2();
                            var11_26 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var29_24) != false ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var29_24) != false;
                            if (!var11_26 || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var30_25)) break block20;
                            var6_13 = this.generateOperatorIfNotNull(ctx, left.resultType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$6(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                            break block15;
                        }
                        if (var15_7 == null) break block21;
                        var31_27 = (LogicalTypeRoot)var15_7._1();
                        var32_28 = (LogicalTypeRoot)var15_7._2();
                        var10_29 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var31_27) != false ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var31_27) != false;
                        if (!var10_29 || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var32_28)) break block21;
                        var6_13 = this.generateOperatorIfNotNull(ctx, left.resultType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$7(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                        break block15;
                    }
                    if (var15_7 == null) break block22;
                    var33_30 = (LogicalTypeRoot)var15_7._1();
                    var34_31 = (LogicalTypeRoot)var15_7._2();
                    var9_32 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var33_30) != false ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var33_30) != false ? true : LogicalTypeRoot.DATE.equals(var33_30) != false);
                    if (!var9_32 || !(var8_33 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var34_31) != false ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var34_31) != false ? true : LogicalTypeRoot.DATE.equals(var34_31) != false)) || plus) break block22;
                    var35_34 = resultType.getTypeRoot();
                    if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var35_34)) {
                        var7_35 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$8(org.apache.flink.table.planner.codegen.GeneratedExpression org.apache.flink.table.planner.codegen.GeneratedExpression java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((GeneratedExpression)left, (GeneratedExpression)right));
                    } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var35_34)) {
                        var7_35 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$9(org.apache.flink.table.planner.codegen.GeneratedExpression org.apache.flink.table.planner.codegen.GeneratedExpression java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((GeneratedExpression)left, (GeneratedExpression)right, (String)op));
                    } else {
                        throw new MatchError((Object)var35_34);
                    }
                    var6_13 = var7_35;
                    break block15;
                }
                if (var15_7 == null) break block23;
                var36_36 = (LogicalTypeRoot)var15_7._1();
                t = (LogicalTypeRoot)var15_7._2();
                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var36_36) || !t.getFamilies().contains(LogicalTypeFamily.DATETIME) || plus) break block23;
                var6_13 = this.generateTimestampLtzMinus(ctx, resultType, left, right);
                break block15;
            }
            if (var15_7 == null) ** GOTO lbl-1000
            t = (LogicalTypeRoot)var15_7._1();
            var39_39 = (LogicalTypeRoot)var15_7._2();
            if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var39_39) && t.getFamilies().contains(LogicalTypeFamily.DATETIME) && !plus) {
                var6_13 = this.generateTimestampLtzMinus(ctx, resultType, left, right);
            } else lbl-1000:
            // 2 sources

            {
                throw new CodeGenException("Unsupported temporal arithmetic.");
            }
        }
        return var6_13;
    }

    private GeneratedExpression generateTimestampLtzMinus(CodeGeneratorContext ctx, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        GeneratedExpression generatedExpression;
        LogicalTypeRoot logicalTypeRoot = resultType.getTypeRoot();
        if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            generatedExpression = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(ll, rr) -> {
                block3: {
                    block2: {
                        Tuple2 tuple2 = new Tuple2((Object)left.resultType().getTypeRoot(), (Object)right.resultType().getTypeRoot());
                        if (tuple2 == null) break block2;
                        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
                        LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
                        if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot2)) break block3;
                    }
                    throw new CodeGenException("TIMESTAMP_LTZ only supports diff between the same type.");
                }
                String leftTerm = new StringBuilder(17).append((String)ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append((String)rr).append(".getMillisecond()").toString();
                String string = new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
                return string;
            });
        } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            generatedExpression = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(ll, rr) -> {
                block3: {
                    block2: {
                        Tuple2 tuple2 = new Tuple2((Object)left.resultType().getTypeRoot(), (Object)right.resultType().getTypeRoot());
                        if (tuple2 == null) break block2;
                        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
                        LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
                        if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot2)) break block3;
                    }
                    throw new CodeGenException("TIMESTAMP_LTZ only supports diff between the same type.");
                }
                String leftTerm = new StringBuilder(17).append((String)ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append((String)rr).append(".getMillisecond()").toString();
                String string = new StringBuilder(3).append(leftTerm).append(" - ").append(rightTerm).toString();
                return string;
            });
        } else {
            throw new CodeGenException("Unsupported temporal arithmetic.");
        }
        return generatedExpression;
    }

    public GeneratedExpression generateUnaryIntervalPlusMinus(CodeGeneratorContext ctx, boolean plus, GeneratedExpression operand) {
        String operator = plus ? "+" : "-";
        return this.generateUnaryArithmeticOperator(ctx, operator, operand.resultType(), operand);
    }

    public GeneratedExpression generateIn(CodeGeneratorContext ctx, GeneratedExpression needle, Seq<GeneratedExpression> haystack) {
        GeneratedExpression generatedExpression;
        if (haystack.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.literal()))) {
            LogicalType logicalType;
            Function1 & Serializable & scala.Serializable intersect;
            Option widerType = JavaScalaConversionUtil$.MODULE$.toScala(LogicalTypeMerging.findCommonType(Arrays.asList((Object[])new LogicalType[]{needle.resultType(), ((GeneratedExpression)haystack.head()).resultType()}))).orElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new CodeGenException(new StringBuilder(36).append("Unable to find common type of ").append(needle).append(" and ").append(haystack).append(".").toString());
            });
            Option option = widerType;
            if (option instanceof Some) {
                Some some = (Some)option;
                LogicalType t = (LogicalType)some.value();
                intersect = (Function1 & Serializable & scala.Serializable)value -> (String)MODULE$.numericCasting(value.resultType(), t).apply((Object)value.resultTerm());
            } else if (None$.MODULE$.equals(option)) {
                intersect = (Function1 & Serializable & scala.Serializable)value -> value.resultTerm();
            } else {
                throw new MatchError((Object)option);
            }
            Function1 & Serializable & scala.Serializable castNumeric = intersect;
            Option option2 = widerType;
            if (option2 instanceof Some) {
                LogicalType t;
                Some some = (Some)option2;
                logicalType = t = (LogicalType)some.value();
            } else if (None$.MODULE$.equals(option2)) {
                logicalType = needle.resultType();
            } else {
                throw new MatchError((Object)option2);
            }
            LogicalType resultType = logicalType;
            Seq elements = (Seq)haystack.map((Function1 & Serializable & scala.Serializable)element -> element.copy((String)castNumeric.apply(element), element.nullTerm(), element.code(), resultType, element.copy$default$5()), Seq$.MODULE$.canBuildFrom());
            String setTerm = ctx.addReusableHashSet((Seq<GeneratedExpression>)elements, resultType);
            GeneratedExpression castedNeedle = needle.copy((String)castNumeric.apply((Object)needle), needle.nullTerm(), needle.code(), resultType, needle.copy$default$5());
            Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError(seq);
            }
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            Tuple2 tuple22 = tuple2;
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType((LogicalType)new BooleanType());
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue((LogicalType)new BooleanType());
            String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n           |").append(castedNeedle.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n           |boolean ").append(nullTerm2).append(" = true;\n           |if (!").append(castedNeedle.nullTerm()).append(") {\n           |  ").append(resultTerm2).append(" = ").append(setTerm).append(".contains(").append(castedNeedle.resultTerm()).append(");\n           |  ").append(nullTerm2).append(" = !").append(resultTerm2).append(" && ").append(setTerm).append(".containsNull();\n           |}\n           |").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(55).append("\n           |").append(castedNeedle.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(setTerm).append(".contains(").append(castedNeedle.resultTerm()).append(");\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = (GeneratedExpression)((TraversableOnce)haystack.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.generateEquals(ctx, needle, (GeneratedExpression)x$3), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(left, right) -> MODULE$.generateOr(ctx, (GeneratedExpression)left, (GeneratedExpression)right));
        }
        return generatedExpression;
    }

    public GeneratedExpression generateEquals(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        GeneratedExpression generatedExpression;
        block16: {
            Function2 & Serializable & scala.Serializable intersect;
            while (true) {
                boolean canEqual = PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType());
                if (TypeCheckUtils.isCharacterString((LogicalType)left.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)right.resultType())) {
                    generatedExpression = this.generateOperatorIfNotNull(ctx, (LogicalType)new BooleanType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(9).append((String)leftTerm).append(".equals(").append((String)rightTerm).append(")").toString());
                    break block16;
                }
                if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType())) {
                    generatedExpression = this.generateComparison(ctx, "==", left, right);
                    break block16;
                }
                if (TypeCheckUtils.isArray((LogicalType)left.resultType()) && canEqual) {
                    generatedExpression = this.generateArrayComparison(ctx, left, right);
                    break block16;
                }
                if (TypeCheckUtils.isMap((LogicalType)left.resultType()) && canEqual) {
                    MapType mapType = (MapType)left.resultType();
                    generatedExpression = this.generateMapComparison(ctx, left, right, mapType.getKeyType(), mapType.getValueType());
                    break block16;
                }
                if (TypeCheckUtils.isMultiset((LogicalType)left.resultType()) && canEqual) {
                    MultisetType multisetType = (MultisetType)left.resultType();
                    generatedExpression = this.generateMapComparison(ctx, left, right, multisetType.getElementType(), (LogicalType)new IntType(false));
                    break block16;
                }
                if (TypeCheckUtils.isComparable((LogicalType)left.resultType()) && canEqual) {
                    generatedExpression = this.generateComparison(ctx, "==", left, right);
                    break block16;
                }
                if (TypeCheckUtils.isRaw((LogicalType)left.resultType()) && canEqual) {
                    Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                        throw new MatchError(seq);
                    }
                    String resultTerm = (String)((SeqLike)some.get()).apply(0);
                    String nullTerm = (String)((SeqLike)some.get()).apply(1);
                    Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
                    Tuple2 tuple22 = tuple2;
                    String resultTerm2 = (String)tuple22._1();
                    String nullTerm2 = (String)tuple22._2();
                    String genericSer = ctx.addReusableTypeSerializer(left.resultType());
                    String ser = new StringBuilder(21).append(genericSer).append(".getInnerSerializer()").toString();
                    BooleanType resultType = new BooleanType();
                    String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(262).append("\n         |").append(left.code()).append("\n         |").append(right.code()).append("\n         |boolean ").append(nullTerm2).append(" = ").append(left.nullTerm()).append(" || ").append(right.nullTerm()).append(";\n         |boolean ").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue((LogicalType)resultType)).append(";\n         |if (!").append(nullTerm2).append(") {\n         |  ").append(left.resultTerm()).append(".ensureMaterialized(").append(ser).append(");\n         |  ").append(right.resultTerm()).append(".ensureMaterialized(").append(ser).append(");\n         |  ").append(resultTerm2).append(" =\n         |    ").append(left.resultTerm()).append(".getBinarySection().equals(").append(right.resultTerm()).append(".getBinarySection());\n         |}\n         |").toString())).stripMargin();
                    generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, code, (LogicalType)resultType, GeneratedExpression$.MODULE$.apply$default$5());
                    break block16;
                }
                if (TypeCheckUtils.isTimePoint((LogicalType)left.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)right.resultType())) {
                    if (right.literal()) {
                        right = this.generateCastStringLiteralToDateTime(ctx, right, left.resultType());
                        continue;
                    }
                    right = this.generateCast(ctx, right, left.resultType());
                    continue;
                }
                if (!TypeCheckUtils.isTimePoint((LogicalType)right.resultType()) || !TypeCheckUtils.isCharacterString((LogicalType)left.resultType())) break;
                if (left.literal()) {
                    GeneratedExpression generatedExpression2 = this.generateCastStringLiteralToDateTime(ctx, left, right.resultType());
                    left = generatedExpression2;
                    continue;
                }
                GeneratedExpression generatedExpression3 = this.generateCast(ctx, left, right.resultType());
                left = generatedExpression3;
            }
            BooleanType booleanType = new BooleanType();
            boolean bl = this.generateOperatorIfNotNull$default$5();
            if (TypeCheckUtils.isReference((LogicalType)left.resultType())) {
                intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(9).append((String)leftTerm).append(".equals(").append((String)rightTerm).append(")").toString();
            } else if (TypeCheckUtils.isReference((LogicalType)right.resultType())) {
                intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(9).append((String)rightTerm).append(".equals(").append((String)leftTerm).append(")").toString();
            } else {
                throw new CodeGenException(new StringBuilder(25).append("Incomparable types: ").append(left.resultType()).append(" and ").append(String.valueOf(right.resultType())).toString());
            }
            generatedExpression = this.generateOperatorIfNotNull(ctx, (LogicalType)booleanType, left, right, bl, (Function2<String, String, String>)intersect);
        }
        return generatedExpression;
    }

    public GeneratedExpression generateIsNotDistinctFrom(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        return this.generateOr(ctx, this.generateAnd(ctx, this.generateIsNull(ctx, left), this.generateIsNull(ctx, right)), this.generateEquals(ctx, left, right));
    }

    public GeneratedExpression generateNotEquals(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        GeneratedExpression generatedExpression;
        if (TypeCheckUtils.isCharacterString((LogicalType)left.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)right.resultType())) {
            generatedExpression = this.generateOperatorIfNotNull(ctx, (LogicalType)new BooleanType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(10).append("!").append((String)leftTerm).append(".equals(").append((String)rightTerm).append(")").toString());
        } else if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType())) {
            generatedExpression = this.generateComparison(ctx, "!=", left, right);
        } else if (TypeCheckUtils.isTemporal((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            generatedExpression = this.generateComparison(ctx, "!=", left, right);
        } else if (TypeCheckUtils.isArray((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            GeneratedExpression equalsExpr = this.generateEquals(ctx, left, right);
            generatedExpression = new GeneratedExpression(new StringBuilder(3).append("(!").append(equalsExpr.resultTerm()).append(")").toString(), equalsExpr.nullTerm(), equalsExpr.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (TypeCheckUtils.isMap((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            GeneratedExpression equalsExpr = this.generateEquals(ctx, left, right);
            generatedExpression = new GeneratedExpression(new StringBuilder(3).append("(!").append(equalsExpr.resultTerm()).append(")").toString(), equalsExpr.nullTerm(), equalsExpr.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (TypeCheckUtils.isComparable((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            generatedExpression = this.generateComparison(ctx, "!=", left, right);
        } else {
            Function2 & Serializable & scala.Serializable intersect;
            BooleanType booleanType = new BooleanType();
            boolean bl = this.generateOperatorIfNotNull$default$5();
            if (TypeCheckUtils.isReference((LogicalType)left.resultType())) {
                intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(12).append("!(").append((String)leftTerm).append(".equals(").append((String)rightTerm).append("))").toString();
            } else if (TypeCheckUtils.isReference((LogicalType)right.resultType())) {
                intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(12).append("!(").append((String)rightTerm).append(".equals(").append((String)leftTerm).append("))").toString();
            } else {
                throw new CodeGenException(new StringBuilder(25).append("Incomparable types: ").append(left.resultType()).append(" and ").append(String.valueOf(right.resultType())).toString());
            }
            generatedExpression = this.generateOperatorIfNotNull(ctx, (LogicalType)booleanType, left, right, bl, (Function2<String, String, String>)intersect);
        }
        return generatedExpression;
    }

    public GeneratedExpression generateComparison(CodeGeneratorContext ctx, String operator, GeneratedExpression left, GeneratedExpression right) {
        Function2 & Serializable & scala.Serializable intersect;
        BooleanType booleanType = new BooleanType();
        boolean bl = this.generateOperatorIfNotNull$default$5();
        if (TypeCheckUtils.isDecimal((LogicalType)left.resultType()) || TypeCheckUtils.isDecimal((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".compare(").append((String)leftTerm).append(", ").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
        } else if (TypeCheckUtils.isTimestamp((LogicalType)left.resultType()) && TypeCheckUtils.isTimestamp((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isTimestampWithLocalZone((LogicalType)left.resultType()) && TypeCheckUtils.isTimestampWithLocalZone((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isTemporal((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
        } else if (TypeCheckUtils.isBoolean((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            Function2 & Serializable & scala.Serializable intersect2;
            String string = operator;
            boolean bl2 = "==".equals(string) ? true : "!=".equals(string);
            if (bl2) {
                intersect2 = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
            } else {
                boolean bl3 = ">".equals(string) ? true : ("<".equals(string) ? true : ("<=".equals(string) ? true : ">=".equals(string)));
                if (bl3) {
                    intersect2 = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(32).append("java.lang.Boolean.compare(").append((String)leftTerm).append(", ").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
                } else {
                    throw new CodeGenException(new StringBuilder(34).append("Unsupported boolean comparison '").append(operator).append("'.").toString());
                }
            }
            intersect = intersect2;
        } else if (TypeCheckUtils.isBinaryString((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            String utilName = SqlFunctionUtils.class.getCanonicalName();
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(24).append(utilName).append(".byteArrayCompare(").append((String)leftTerm).append(", ").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isComparable((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(52).append("((").append((String)leftTerm).append(" == null) ? ((").append((String)rightTerm).append(" == null) ? 0 : -1) : ((").append((String)rightTerm).append(" == null) ? ").append(new StringBuilder(23).append("1 : (").append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(")))) ").append(operator).append(" 0").toString()).toString();
        } else {
            throw new CodeGenException(new StringBuilder(25).append("Incomparable types: ").append(left.resultType()).append(" and ").append(String.valueOf(right.resultType())).toString());
        }
        return this.generateOperatorIfNotNull(ctx, (LogicalType)booleanType, left, right, bl, (Function2<String, String, String>)intersect);
    }

    public GeneratedExpression generateIsNull(CodeGeneratorContext ctx, GeneratedExpression operand) {
        GeneratedExpression generatedExpression;
        if (ctx.nullCheck()) {
            generatedExpression = new GeneratedExpression(operand.nullTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (!ctx.nullCheck() && TypeCheckUtils.isReference((LogicalType)operand.resultType())) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = ").append(operand.resultTerm()).append(" == null;\n           |").toString())).stripMargin();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, (LogicalType)new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = new GeneratedExpression("false", GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateIsNotNull(CodeGeneratorContext ctx, GeneratedExpression operand) {
        GeneratedExpression generatedExpression;
        if (ctx.nullCheck()) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(52).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = !").append(operand.nullTerm()).append(";\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, (LogicalType)new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (!ctx.nullCheck() && TypeCheckUtils.isReference((LogicalType)operand.resultType())) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = ").append(operand.resultTerm()).append(" != null;\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, (LogicalType)new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = new GeneratedExpression("true", GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(false), GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateAnd(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(767).append("\n         |").append(left.code()).append("\n         |\n         |boolean ").append(resultTerm2).append(" = false;\n         |boolean ").append(nullTerm2).append(" = false;\n         |if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(") {\n         |  // left expr is false, skip right expr\n         |} else {\n         |  ").append(right.code()).append("\n         |\n         |  if (!").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = ").append(left.resultTerm()).append(" && ").append(right.resultTerm()).append(";\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && ").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && !").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |}\n       ").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n         |").append(left.code()).append("\n         |boolean ").append(resultTerm2).append(" = false;\n         |if (").append(left.resultTerm()).append(") {\n         |  ").append(right.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(right.resultTerm()).append(";\n         |}\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateOr(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(763).append("\n         |").append(left.code()).append("\n         |\n        |boolean ").append(resultTerm2).append(" = true;\n         |boolean ").append(nullTerm2).append(" = false;\n         |if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(") {\n         |  // left expr is true, skip right expr\n         |} else {\n         |  ").append(right.code()).append("\n         |\n        |  if (!").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = ").append(left.resultTerm()).append(" || ").append(right.resultTerm()).append(";\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = true;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && ").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = true;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && !").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |}\n         |").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n         |").append(left.code()).append("\n         |boolean ").append(resultTerm2).append(" = true;\n         |if (!").append(left.resultTerm()).append(") {\n         |  ").append(right.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(right.resultTerm()).append(";\n         |}\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateNot(CodeGeneratorContext ctx, GeneratedExpression operand) {
        return this.generateUnaryOperatorIfNotNull(ctx, (LogicalType)new BooleanType(), operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(3).append("!(").append((String)operandTerm).append(")").toString());
    }

    public GeneratedExpression generateIsTrue(GeneratedExpression operand) {
        return new GeneratedExpression(operand.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsNotTrue(GeneratedExpression operand) {
        return new GeneratedExpression(new StringBuilder(3).append("(!").append(operand.resultTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsFalse(GeneratedExpression operand) {
        return new GeneratedExpression(new StringBuilder(8).append("(!").append(operand.resultTerm()).append(" && !").append(operand.nullTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsNotFalse(GeneratedExpression operand) {
        return new GeneratedExpression(new StringBuilder(6).append("(").append(operand.resultTerm()).append(" || ").append(operand.nullTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateReinterpret(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetType) {
        block6: {
            block21: {
                block23: {
                    block24: {
                        block22: {
                            block20: {
                                block19: {
                                    block18: {
                                        block8: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        block14: {
                                                            block13: {
                                                                block12: {
                                                                    block11: {
                                                                        block10: {
                                                                            block9: {
                                                                                block7: {
                                                                                    block5: {
                                                                                        var6_4 = new Tuple2((Object)operand.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
                                                                                        if (var6_4 == null || !PlannerTypeUtils.isInteroperable((LogicalType)operand.resultType(), (LogicalType)targetType)) break block5;
                                                                                        x$17 = targetType;
                                                                                        x$18 = operand.copy$default$1();
                                                                                        x$19 = operand.copy$default$2();
                                                                                        x$20 = operand.copy$default$3();
                                                                                        x$21 = operand.copy$default$5();
                                                                                        var4_10 = operand.copy(x$18, x$19, x$20, x$17, x$21);
                                                                                        break block6;
                                                                                    }
                                                                                    if (var6_4 == null) break block7;
                                                                                    var12_11 = (LogicalTypeRoot)var6_4._1();
                                                                                    var13_12 = (LogicalTypeRoot)var6_4._2();
                                                                                    if (!LogicalTypeRoot.DATE.equals(var12_11) || !LogicalTypeRoot.INTEGER.equals(var13_12)) break block7;
                                                                                    var5_13 = true;
                                                                                    break block8;
                                                                                }
                                                                                if (var6_4 == null) break block9;
                                                                                var14_14 = (LogicalTypeRoot)var6_4._1();
                                                                                var15_15 = (LogicalTypeRoot)var6_4._2();
                                                                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var14_14) || !LogicalTypeRoot.INTEGER.equals(var15_15)) break block9;
                                                                                var5_13 = true;
                                                                                break block8;
                                                                            }
                                                                            if (var6_4 == null) break block10;
                                                                            var16_16 = (LogicalTypeRoot)var6_4._1();
                                                                            var17_17 = (LogicalTypeRoot)var6_4._2();
                                                                            if (!LogicalTypeRoot.INTEGER.equals(var16_16) || !LogicalTypeRoot.DATE.equals(var17_17)) break block10;
                                                                            var5_13 = true;
                                                                            break block8;
                                                                        }
                                                                        if (var6_4 == null) break block11;
                                                                        var18_18 = (LogicalTypeRoot)var6_4._1();
                                                                        var19_19 = (LogicalTypeRoot)var6_4._2();
                                                                        if (!LogicalTypeRoot.INTEGER.equals(var18_18) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var19_19)) break block11;
                                                                        var5_13 = true;
                                                                        break block8;
                                                                    }
                                                                    if (var6_4 == null) break block12;
                                                                    var20_20 = (LogicalTypeRoot)var6_4._1();
                                                                    var21_21 = (LogicalTypeRoot)var6_4._2();
                                                                    if (!LogicalTypeRoot.INTEGER.equals(var20_20) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var21_21)) break block12;
                                                                    var5_13 = true;
                                                                    break block8;
                                                                }
                                                                if (var6_4 == null) break block13;
                                                                var22_22 = (LogicalTypeRoot)var6_4._1();
                                                                var23_23 = (LogicalTypeRoot)var6_4._2();
                                                                if (!LogicalTypeRoot.BIGINT.equals(var22_22) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var23_23)) break block13;
                                                                var5_13 = true;
                                                                break block8;
                                                            }
                                                            if (var6_4 == null) break block14;
                                                            var24_24 = (LogicalTypeRoot)var6_4._1();
                                                            var25_25 = (LogicalTypeRoot)var6_4._2();
                                                            if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var24_24) || !LogicalTypeRoot.INTEGER.equals(var25_25)) break block14;
                                                            var5_13 = true;
                                                            break block8;
                                                        }
                                                        if (var6_4 == null) break block15;
                                                        var26_26 = (LogicalTypeRoot)var6_4._1();
                                                        var27_27 = (LogicalTypeRoot)var6_4._2();
                                                        if (!LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var26_26) || !LogicalTypeRoot.BIGINT.equals(var27_27)) break block15;
                                                        var5_13 = true;
                                                        break block8;
                                                    }
                                                    if (var6_4 == null) break block16;
                                                    var28_28 = (LogicalTypeRoot)var6_4._1();
                                                    var29_29 = (LogicalTypeRoot)var6_4._2();
                                                    if (!LogicalTypeRoot.DATE.equals(var28_28) || !LogicalTypeRoot.BIGINT.equals(var29_29)) break block16;
                                                    var5_13 = true;
                                                    break block8;
                                                }
                                                if (var6_4 == null) break block17;
                                                var30_30 = (LogicalTypeRoot)var6_4._1();
                                                var31_31 = (LogicalTypeRoot)var6_4._2();
                                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var30_30) || !LogicalTypeRoot.BIGINT.equals(var31_31)) break block17;
                                                var5_13 = true;
                                                break block8;
                                            }
                                            if (var6_4 == null) ** GOTO lbl-1000
                                            var32_32 = (LogicalTypeRoot)var6_4._1();
                                            var33_33 = (LogicalTypeRoot)var6_4._2();
                                            if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var32_32) && LogicalTypeRoot.BIGINT.equals(var33_33)) {
                                                var5_13 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                var5_13 = false;
                                            }
                                        }
                                        if (!var5_13) break block18;
                                        var4_10 = this.internalExprCasting(operand, targetType);
                                        break block6;
                                    }
                                    if (var6_4 == null) break block19;
                                    var34_34 = (LogicalTypeRoot)var6_4._1();
                                    var35_35 = (LogicalTypeRoot)var6_4._2();
                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var34_34) || !LogicalTypeRoot.BIGINT.equals(var35_35)) break block19;
                                    var4_10 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateReinterpret$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                    break block6;
                                }
                                if (var6_4 == null) break block20;
                                var36_36 = (LogicalTypeRoot)var6_4._1();
                                var37_37 = (LogicalTypeRoot)var6_4._2();
                                if (!LogicalTypeRoot.BIGINT.equals(var36_36) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var37_37)) break block20;
                                var4_10 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateReinterpret$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                break block6;
                            }
                            if (var6_4 == null) break block21;
                            from = (LogicalTypeRoot)var6_4._1();
                            to = (LogicalTypeRoot)var6_4._2();
                            v0 = from;
                            var40_40 = to;
                            if (v0 != null) break block22;
                            if (var40_40 == null) break block23;
                            break block24;
                        }
                        if (v0.equals(var40_40)) break block23;
                    }
                    throw new CodeGenException(new StringBuilder(38).append("Unsupported reinterpret from '").append(from).append("' to '").append(to).append("'.").toString());
                }
                var4_10 = operand;
                break block6;
            }
            throw new MatchError((Object)var6_4);
        }
        return var4_10;
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateCast(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetType) {
        block27: {
            block102: {
                block100: {
                    block101: {
                        block99: {
                            block98: {
                                block91: {
                                    block97: {
                                        block96: {
                                            block95: {
                                                block94: {
                                                    block93: {
                                                        block92: {
                                                            block90: {
                                                                block77: {
                                                                    block89: {
                                                                        block88: {
                                                                            block87: {
                                                                                block86: {
                                                                                    block85: {
                                                                                        block84: {
                                                                                            block83: {
                                                                                                block82: {
                                                                                                    block81: {
                                                                                                        block80: {
                                                                                                            block79: {
                                                                                                                block78: {
                                                                                                                    block76: {
                                                                                                                        block63: {
                                                                                                                            block75: {
                                                                                                                                block74: {
                                                                                                                                    block73: {
                                                                                                                                        block72: {
                                                                                                                                            block71: {
                                                                                                                                                block70: {
                                                                                                                                                    block69: {
                                                                                                                                                        block68: {
                                                                                                                                                            block67: {
                                                                                                                                                                block66: {
                                                                                                                                                                    block65: {
                                                                                                                                                                        block64: {
                                                                                                                                                                            block62: {
                                                                                                                                                                                block61: {
                                                                                                                                                                                    block60: {
                                                                                                                                                                                        block59: {
                                                                                                                                                                                            block58: {
                                                                                                                                                                                                block57: {
                                                                                                                                                                                                    block56: {
                                                                                                                                                                                                        block55: {
                                                                                                                                                                                                            block54: {
                                                                                                                                                                                                                block53: {
                                                                                                                                                                                                                    block52: {
                                                                                                                                                                                                                        block51: {
                                                                                                                                                                                                                            block50: {
                                                                                                                                                                                                                                block49: {
                                                                                                                                                                                                                                    block48: {
                                                                                                                                                                                                                                        block47: {
                                                                                                                                                                                                                                            block46: {
                                                                                                                                                                                                                                                block45: {
                                                                                                                                                                                                                                                    block44: {
                                                                                                                                                                                                                                                        block43: {
                                                                                                                                                                                                                                                            block42: {
                                                                                                                                                                                                                                                                block41: {
                                                                                                                                                                                                                                                                    block40: {
                                                                                                                                                                                                                                                                        block39: {
                                                                                                                                                                                                                                                                            block38: {
                                                                                                                                                                                                                                                                                block37: {
                                                                                                                                                                                                                                                                                    block36: {
                                                                                                                                                                                                                                                                                        block35: {
                                                                                                                                                                                                                                                                                            block34: {
                                                                                                                                                                                                                                                                                                block33: {
                                                                                                                                                                                                                                                                                                    block32: {
                                                                                                                                                                                                                                                                                                        block31: {
                                                                                                                                                                                                                                                                                                            block30: {
                                                                                                                                                                                                                                                                                                                block29: {
                                                                                                                                                                                                                                                                                                                    block28: {
                                                                                                                                                                                                                                                                                                                        block25: {
                                                                                                                                                                                                                                                                                                                            block26: {
                                                                                                                                                                                                                                                                                                                                var31_4 = new Tuple2((Object)operand.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
                                                                                                                                                                                                                                                                                                                                if (var31_4 == null) break block25;
                                                                                                                                                                                                                                                                                                                                var32_5 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                                                                var33_6 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var32_5) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var33_6)) break block25;
                                                                                                                                                                                                                                                                                                                                v0 = ((TimestampType)operand.resultType()).getKind();
                                                                                                                                                                                                                                                                                                                                var34_7 = TimestampKind.PROCTIME;
                                                                                                                                                                                                                                                                                                                                if (!(v0 == null ? var34_7 != null : v0.equals(var34_7) == false)) break block26;
                                                                                                                                                                                                                                                                                                                                v1 = ((TimestampType)operand.resultType()).getKind();
                                                                                                                                                                                                                                                                                                                                var35_8 = TimestampKind.ROWTIME;
                                                                                                                                                                                                                                                                                                                                if (!(v1 == null ? var35_8 != null : v1.equals(var35_8) == false)) break block26;
                                                                                                                                                                                                                                                                                                                                v2 = ((TimestampType)targetType).getKind();
                                                                                                                                                                                                                                                                                                                                var36_9 = TimestampKind.PROCTIME;
                                                                                                                                                                                                                                                                                                                                if (!(v2 == null ? var36_9 != null : v2.equals(var36_9) == false)) break block26;
                                                                                                                                                                                                                                                                                                                                v3 = ((TimestampType)targetType).getKind();
                                                                                                                                                                                                                                                                                                                                var37_10 = TimestampKind.ROWTIME;
                                                                                                                                                                                                                                                                                                                                if (v3 != null ? v3.equals(var37_10) == false : var37_10 != null) break block25;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            x$22 = new TimestampType(operand.resultType().isNullable(), 3);
                                                                                                                                                                                                                                                                                                                            x$23 = operand.copy$default$1();
                                                                                                                                                                                                                                                                                                                            x$24 = operand.copy$default$2();
                                                                                                                                                                                                                                                                                                                            x$25 = operand.copy$default$3();
                                                                                                                                                                                                                                                                                                                            x$26 = operand.copy$default$5();
                                                                                                                                                                                                                                                                                                                            var4_16 = operand.copy(x$23, x$24, x$25, (LogicalType)x$22, x$26);
                                                                                                                                                                                                                                                                                                                            break block27;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (var31_4 == null) break block28;
                                                                                                                                                                                                                                                                                                                        var43_17 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                                                        var44_18 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var43_17) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var44_18)) break block28;
                                                                                                                                                                                                                                                                                                                        fromType = (TimestampType)operand.resultType();
                                                                                                                                                                                                                                                                                                                        toType = (TimestampType)targetType;
                                                                                                                                                                                                                                                                                                                        if (fromType.getPrecision() <= toType.getPrecision()) {
                                                                                                                                                                                                                                                                                                                            x$27 = targetType;
                                                                                                                                                                                                                                                                                                                            x$28 = operand.copy$default$1();
                                                                                                                                                                                                                                                                                                                            x$29 = operand.copy$default$2();
                                                                                                                                                                                                                                                                                                                            x$30 = operand.copy$default$3();
                                                                                                                                                                                                                                                                                                                            x$31 = operand.copy$default$5();
                                                                                                                                                                                                                                                                                                                            v4 = operand.copy(x$28, x$29, x$30, x$27, x$31);
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                            v4 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$1(org.apache.flink.table.types.logical.TimestampType java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((TimestampType)toType, (String)method));
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        var4_16 = v4;
                                                                                                                                                                                                                                                                                                                        break block27;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (var31_4 == null) break block29;
                                                                                                                                                                                                                                                                                                                    var53_27 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                                                    var54_28 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var53_27) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var54_28)) break block29;
                                                                                                                                                                                                                                                                                                                    fromType = (TimestampType)operand.resultType();
                                                                                                                                                                                                                                                                                                                    toType = (LocalZonedTimestampType)targetType;
                                                                                                                                                                                                                                                                                                                    method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_TIMESTAMP_WITH_LOCAL_ZONE());
                                                                                                                                                                                                                                                                                                                    if (fromType.getPrecision() < toType.getPrecision()) {
                                                                                                                                                                                                                                                                                                                        v5 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$2(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (String)method));
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        truncate_method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                        v5 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$3(org.apache.flink.table.planner.codegen.CodeGeneratorContext org.apache.flink.table.types.logical.LocalZonedTimestampType java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (LocalZonedTimestampType)toType, (String)method, (String)truncate_method));
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    var4_16 = v5;
                                                                                                                                                                                                                                                                                                                    break block27;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (var31_4 == null) break block30;
                                                                                                                                                                                                                                                                                                                var59_33 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                                                var60_34 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var59_33) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var60_34)) break block30;
                                                                                                                                                                                                                                                                                                                fromType = (LocalZonedTimestampType)operand.resultType();
                                                                                                                                                                                                                                                                                                                toType = (TimestampType)targetType;
                                                                                                                                                                                                                                                                                                                method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_ZONE_TO_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                if (fromType.getPrecision() < toType.getPrecision()) {
                                                                                                                                                                                                                                                                                                                    v6 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$4(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (String)method));
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    truncate_method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                    v6 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$5(org.apache.flink.table.planner.codegen.CodeGeneratorContext org.apache.flink.table.types.logical.TimestampType java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (TimestampType)toType, (String)method, (String)truncate_method));
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                var4_16 = v6;
                                                                                                                                                                                                                                                                                                                break block27;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (var31_4 == null) break block31;
                                                                                                                                                                                                                                                                                                            var65_39 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                                            var66_40 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var65_39) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var66_40)) break block31;
                                                                                                                                                                                                                                                                                                            fromType = (LocalZonedTimestampType)operand.resultType();
                                                                                                                                                                                                                                                                                                            toType = (LocalZonedTimestampType)targetType;
                                                                                                                                                                                                                                                                                                            if (fromType.getPrecision() <= toType.getPrecision()) {
                                                                                                                                                                                                                                                                                                                x$32 = targetType;
                                                                                                                                                                                                                                                                                                                x$33 = operand.copy$default$1();
                                                                                                                                                                                                                                                                                                                x$34 = operand.copy$default$2();
                                                                                                                                                                                                                                                                                                                x$35 = operand.copy$default$3();
                                                                                                                                                                                                                                                                                                                x$36 = operand.copy$default$5();
                                                                                                                                                                                                                                                                                                                v7 = operand.copy(x$33, x$34, x$35, x$32, x$36);
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                                                                v7 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$6(org.apache.flink.table.types.logical.LocalZonedTimestampType java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((LocalZonedTimestampType)toType, (String)method));
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            var4_16 = v7;
                                                                                                                                                                                                                                                                                                            break block27;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (var31_4 == null || !PlannerTypeUtils.isInteroperable((LogicalType)operand.resultType(), (LogicalType)targetType)) break block32;
                                                                                                                                                                                                                                                                                                        x$37 = targetType;
                                                                                                                                                                                                                                                                                                        x$38 = operand.copy$default$1();
                                                                                                                                                                                                                                                                                                        x$39 = operand.copy$default$2();
                                                                                                                                                                                                                                                                                                        x$40 = operand.copy$default$3();
                                                                                                                                                                                                                                                                                                        x$41 = operand.copy$default$5();
                                                                                                                                                                                                                                                                                                        var4_16 = operand.copy(x$38, x$39, x$40, x$37, x$41);
                                                                                                                                                                                                                                                                                                        break block27;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (var31_4 == null || !(var30_55 = LogicalTypeRoot.VARCHAR.equals(var80_54 = (LogicalTypeRoot)var31_4._2()) != false ? true : LogicalTypeRoot.CHAR.equals(var80_54) != false) || !TypeCheckUtils.isTimePoint((LogicalType)operand.resultType())) break block33;
                                                                                                                                                                                                                                                                                                    var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$7(org.apache.flink.table.planner.codegen.CodeGeneratorContext org.apache.flink.table.planner.codegen.GeneratedExpression scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (GeneratedExpression)operand));
                                                                                                                                                                                                                                                                                                    break block27;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (var31_4 == null) break block34;
                                                                                                                                                                                                                                                                                                var81_56 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                                var82_57 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                                if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var81_56) || !(var29_58 = LogicalTypeRoot.VARCHAR.equals(var82_57) != false ? true : LogicalTypeRoot.CHAR.equals(var82_57) != false)) break block34;
                                                                                                                                                                                                                                                                                                method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method);
                                                                                                                                                                                                                                                                                                timeUnitRange = CodeGenUtils$.MODULE$.qualifyEnum(TimeUnitRange.YEAR_TO_MONTH);
                                                                                                                                                                                                                                                                                                var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$8(java.lang.String java.lang.String scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((String)method, (String)timeUnitRange));
                                                                                                                                                                                                                                                                                                break block27;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (var31_4 == null) break block35;
                                                                                                                                                                                                                                                                                            var85_61 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                            var86_62 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                            if (!LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var85_61) || !(var28_63 = LogicalTypeRoot.VARCHAR.equals(var86_62) != false ? true : LogicalTypeRoot.CHAR.equals(var86_62) != false)) break block35;
                                                                                                                                                                                                                                                                                            method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method);
                                                                                                                                                                                                                                                                                            timeUnitRange = CodeGenUtils$.MODULE$.qualifyEnum(TimeUnitRange.DAY_TO_SECOND);
                                                                                                                                                                                                                                                                                            var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$9(java.lang.String java.lang.String scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((String)method, (String)timeUnitRange));
                                                                                                                                                                                                                                                                                            break block27;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (var31_4 == null) break block36;
                                                                                                                                                                                                                                                                                        var89_66 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                        var90_67 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                        if (!LogicalTypeRoot.ARRAY.equals(var89_66) || !(var27_68 = LogicalTypeRoot.VARCHAR.equals(var90_67) != false ? true : LogicalTypeRoot.CHAR.equals(var90_67) != false)) break block36;
                                                                                                                                                                                                                                                                                        var4_16 = this.generateCastArrayToString(ctx, operand, (ArrayType)operand.resultType(), targetType);
                                                                                                                                                                                                                                                                                        break block27;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (var31_4 == null) break block37;
                                                                                                                                                                                                                                                                                    var91_69 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                    var92_70 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                    var26_71 = LogicalTypeRoot.BINARY.equals(var91_69) != false ? true : LogicalTypeRoot.VARBINARY.equals(var91_69) != false;
                                                                                                                                                                                                                                                                                    if (!var26_71 || !(var25_72 = LogicalTypeRoot.VARCHAR.equals(var92_70) != false ? true : LogicalTypeRoot.CHAR.equals(var92_70) != false)) break block37;
                                                                                                                                                                                                                                                                                    charset = StandardCharsets.class.getCanonicalName();
                                                                                                                                                                                                                                                                                    var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$10(java.lang.String scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((String)charset));
                                                                                                                                                                                                                                                                                    break block27;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (var31_4 == null) break block38;
                                                                                                                                                                                                                                                                                var94_74 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                                var95_75 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                                if (!LogicalTypeRoot.MAP.equals(var94_74) || !(var24_76 = LogicalTypeRoot.VARCHAR.equals(var95_75) != false ? true : LogicalTypeRoot.CHAR.equals(var95_75) != false)) break block38;
                                                                                                                                                                                                                                                                                var4_16 = this.generateCastMapToString(ctx, operand, (MapType)operand.resultType(), targetType);
                                                                                                                                                                                                                                                                                break block27;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (var31_4 == null) break block39;
                                                                                                                                                                                                                                                                            var96_77 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                            var97_78 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                            if (!LogicalTypeRoot.ROW.equals(var96_77) || !(var23_79 = LogicalTypeRoot.VARCHAR.equals(var97_78) != false ? true : LogicalTypeRoot.CHAR.equals(var97_78) != false)) break block39;
                                                                                                                                                                                                                                                                            var4_16 = this.generateCastRowDataToString(ctx, operand, (RowType)operand.resultType(), targetType);
                                                                                                                                                                                                                                                                            break block27;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (var31_4 == null) break block40;
                                                                                                                                                                                                                                                                        var98_80 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                        var99_81 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                        if (!LogicalTypeRoot.RAW.equals(var98_80) || !(var22_82 = LogicalTypeRoot.VARCHAR.equals(var99_81) != false ? true : LogicalTypeRoot.CHAR.equals(var99_81) != false)) break block40;
                                                                                                                                                                                                                                                                        var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$11(org.apache.flink.table.planner.codegen.CodeGeneratorContext org.apache.flink.table.planner.codegen.GeneratedExpression scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (GeneratedExpression)operand));
                                                                                                                                                                                                                                                                        break block27;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (var31_4 == null || !(var21_84 = LogicalTypeRoot.VARCHAR.equals(var100_83 = (LogicalTypeRoot)var31_4._2()) != false ? true : LogicalTypeRoot.CHAR.equals(var100_83) != false)) break block41;
                                                                                                                                                                                                                                                                    var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$12(scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)());
                                                                                                                                                                                                                                                                    break block27;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (var31_4 == null) break block42;
                                                                                                                                                                                                                                                                var101_85 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                                var102_86 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                                var20_87 = LogicalTypeRoot.VARCHAR.equals(var101_85) != false ? true : LogicalTypeRoot.CHAR.equals(var101_85) != false;
                                                                                                                                                                                                                                                                if (!var20_87 || !LogicalTypeRoot.BOOLEAN.equals(var102_86)) break block42;
                                                                                                                                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$13(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                                                                                break block27;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (var31_4 == null || !(var19_89 = LogicalTypeRoot.VARCHAR.equals(var103_88 = (LogicalTypeRoot)var31_4._1()) != false ? true : LogicalTypeRoot.CHAR.equals(var103_88) != false) || !TypeCheckUtils.isNumeric((LogicalType)targetType)) break block43;
                                                                                                                                                                                                                                                            var104_90 = targetType;
                                                                                                                                                                                                                                                            if (var104_90 instanceof DecimalType) {
                                                                                                                                                                                                                                                                var105_91 = (DecimalType)var104_90;
                                                                                                                                                                                                                                                                var17_92 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$14(org.apache.flink.table.types.logical.DecimalType java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((DecimalType)var105_91));
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                var107_93 = targetType.getTypeRoot();
                                                                                                                                                                                                                                                                var18_94 = LogicalTypeRoot.TINYINT.equals(var107_93) != false ? "toByte" : (LogicalTypeRoot.SMALLINT.equals(var107_93) != false ? "toShort" : (LogicalTypeRoot.INTEGER.equals(var107_93) != false ? "toInt" : (LogicalTypeRoot.BIGINT.equals(var107_93) != false ? "toLong" : (LogicalTypeRoot.DOUBLE.equals(var107_93) != false ? "toDouble" : (LogicalTypeRoot.FLOAT.equals(var107_93) != false ? "toFloat" : null)))));
                                                                                                                                                                                                                                                                methodName = var18_94;
                                                                                                                                                                                                                                                                Predef$.MODULE$.assert(methodName != null, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$generateCast$15(), ()Ljava/lang/String;)());
                                                                                                                                                                                                                                                                var17_92 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$16(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((String)methodName));
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            var4_16 = var17_92;
                                                                                                                                                                                                                                                            break block27;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (var31_4 == null) break block44;
                                                                                                                                                                                                                                                        var108_96 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                        var109_97 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                        var16_98 = LogicalTypeRoot.VARCHAR.equals(var108_96) != false ? true : LogicalTypeRoot.CHAR.equals(var108_96) != false;
                                                                                                                                                                                                                                                        if (!var16_98 || !LogicalTypeRoot.DATE.equals(var109_97)) break block44;
                                                                                                                                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$17(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                                                                        break block27;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (var31_4 == null) break block45;
                                                                                                                                                                                                                                                    var110_99 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                    var111_100 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                    var15_101 = LogicalTypeRoot.VARCHAR.equals(var110_99) != false ? true : LogicalTypeRoot.CHAR.equals(var110_99) != false;
                                                                                                                                                                                                                                                    if (!var15_101 || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var111_100)) break block45;
                                                                                                                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$18(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                                                                    break block27;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (var31_4 == null) break block46;
                                                                                                                                                                                                                                                var112_102 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                                var113_103 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                                var14_104 = LogicalTypeRoot.VARCHAR.equals(var112_102) != false ? true : LogicalTypeRoot.CHAR.equals(var112_102) != false;
                                                                                                                                                                                                                                                if (!var14_104 || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var113_103)) break block46;
                                                                                                                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$19(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                                                                break block27;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (var31_4 == null) break block47;
                                                                                                                                                                                                                                            var114_105 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                            var115_106 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                            var13_107 = LogicalTypeRoot.VARCHAR.equals(var114_105) != false ? true : LogicalTypeRoot.CHAR.equals(var114_105) != false;
                                                                                                                                                                                                                                            if (!var13_107 || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var115_106)) break block47;
                                                                                                                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$20(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                                                                                                                            break block27;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (var31_4 == null) break block48;
                                                                                                                                                                                                                                        var116_108 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                        var117_109 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                        var12_110 = LogicalTypeRoot.VARCHAR.equals(var116_108) != false ? true : LogicalTypeRoot.CHAR.equals(var116_108) != false;
                                                                                                                                                                                                                                        if (!var12_110 || !(var11_111 = LogicalTypeRoot.VARBINARY.equals(var117_109) != false ? true : LogicalTypeRoot.BINARY.equals(var117_109) != false)) break block48;
                                                                                                                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$21(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                                                        break block27;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (var31_4 == null) break block49;
                                                                                                                                                                                                                                    var118_112 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                                    var119_113 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                                    if (!LogicalTypeRoot.BOOLEAN.equals(var118_112) || !LogicalTypeRoot.DECIMAL.equals(var119_113)) break block49;
                                                                                                                                                                                                                                    dt = (DecimalType)targetType;
                                                                                                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$22(org.apache.flink.table.types.logical.DecimalType java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((DecimalType)dt));
                                                                                                                                                                                                                                    break block27;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (var31_4 == null || !LogicalTypeRoot.BOOLEAN.equals(var121_115 = (LogicalTypeRoot)var31_4._1()) || !TypeCheckUtils.isNumeric((LogicalType)targetType)) break block50;
                                                                                                                                                                                                                                targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$23(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((String)targetTypeTerm));
                                                                                                                                                                                                                                break block27;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (var31_4 == null) break block51;
                                                                                                                                                                                                                            var123_117 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                            var124_118 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                            if (!LogicalTypeRoot.DECIMAL.equals(var123_117) || !LogicalTypeRoot.BOOLEAN.equals(var124_118)) break block51;
                                                                                                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$24(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                                            break block27;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (var31_4 == null || !LogicalTypeRoot.BOOLEAN.equals(var125_119 = (LogicalTypeRoot)var31_4._2()) || !TypeCheckUtils.isNumeric((LogicalType)operand.resultType())) break block52;
                                                                                                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$25(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                                        break block27;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (var31_4 == null || !TypeCheckUtils.isNumeric((LogicalType)operand.resultType()) || !TypeCheckUtils.isNumeric((LogicalType)targetType)) break block53;
                                                                                                                                                                                                                    operandCasting = this.numericCasting(operand.resultType(), targetType);
                                                                                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$26(scala.Function1 java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(operandCasting));
                                                                                                                                                                                                                    break block27;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (var31_4 == null) break block54;
                                                                                                                                                                                                                var127_121 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                                var128_122 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                                if (!LogicalTypeRoot.DATE.equals(var127_121) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var128_122)) break block54;
                                                                                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$27(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                                break block27;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (var31_4 == null) break block55;
                                                                                                                                                                                                            var129_123 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                            var130_124 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var129_123) || !LogicalTypeRoot.DATE.equals(var130_124)) break block55;
                                                                                                                                                                                                            targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$28(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((String)targetTypeTerm));
                                                                                                                                                                                                            break block27;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (var31_4 == null) break block56;
                                                                                                                                                                                                        var132_126 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                        var133_127 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var132_126) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var133_127)) break block56;
                                                                                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$29(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                        break block27;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (var31_4 == null) break block57;
                                                                                                                                                                                                    var134_128 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                    var135_129 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var134_128) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var135_129)) break block57;
                                                                                                                                                                                                    targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$30(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((String)targetTypeTerm));
                                                                                                                                                                                                    break block27;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (var31_4 == null) break block58;
                                                                                                                                                                                                var137_131 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                                var138_132 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                                if (!LogicalTypeRoot.DATE.equals(var137_131) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var138_132)) break block58;
                                                                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$31(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                                                                                break block27;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (var31_4 == null) break block59;
                                                                                                                                                                                            var139_133 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                            var140_134 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var139_133) || !LogicalTypeRoot.DATE.equals(var140_134)) break block59;
                                                                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$32(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                                                                            break block27;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (var31_4 == null) break block60;
                                                                                                                                                                                        var141_135 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                        var142_136 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var141_135) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var142_136)) break block60;
                                                                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$33(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                                                                        break block27;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (var31_4 == null) break block61;
                                                                                                                                                                                    var143_137 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                    var144_138 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var143_137) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var144_138)) break block61;
                                                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$34(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                                                                    break block27;
                                                                                                                                                                                }
                                                                                                                                                                                if (var31_4 == null) break block62;
                                                                                                                                                                                var145_139 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                                var146_140 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                                if (!LogicalTypeRoot.TINYINT.equals(var145_139) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var146_140)) break block62;
                                                                                                                                                                                var10_141 = true;
                                                                                                                                                                                break block63;
                                                                                                                                                                            }
                                                                                                                                                                            if (var31_4 == null) break block64;
                                                                                                                                                                            var147_142 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                            var148_143 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                            if (!LogicalTypeRoot.SMALLINT.equals(var147_142) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var148_143)) break block64;
                                                                                                                                                                            var10_141 = true;
                                                                                                                                                                            break block63;
                                                                                                                                                                        }
                                                                                                                                                                        if (var31_4 == null) break block65;
                                                                                                                                                                        var149_144 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                        var150_145 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                        if (!LogicalTypeRoot.INTEGER.equals(var149_144) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var150_145)) break block65;
                                                                                                                                                                        var10_141 = true;
                                                                                                                                                                        break block63;
                                                                                                                                                                    }
                                                                                                                                                                    if (var31_4 == null) break block66;
                                                                                                                                                                    var151_146 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                    var152_147 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                    if (!LogicalTypeRoot.BIGINT.equals(var151_146) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var152_147)) break block66;
                                                                                                                                                                    var10_141 = true;
                                                                                                                                                                    break block63;
                                                                                                                                                                }
                                                                                                                                                                if (var31_4 == null) break block67;
                                                                                                                                                                var153_148 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                                var154_149 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                                if (!LogicalTypeRoot.FLOAT.equals(var153_148) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var154_149)) break block67;
                                                                                                                                                                var10_141 = true;
                                                                                                                                                                break block63;
                                                                                                                                                            }
                                                                                                                                                            if (var31_4 == null) break block68;
                                                                                                                                                            var155_150 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                            var156_151 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                            if (!LogicalTypeRoot.DOUBLE.equals(var155_150) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var156_151)) break block68;
                                                                                                                                                            var10_141 = true;
                                                                                                                                                            break block63;
                                                                                                                                                        }
                                                                                                                                                        if (var31_4 == null) break block69;
                                                                                                                                                        var157_152 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                        var158_153 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                        if (!LogicalTypeRoot.DECIMAL.equals(var157_152) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var158_153)) break block69;
                                                                                                                                                        var10_141 = true;
                                                                                                                                                        break block63;
                                                                                                                                                    }
                                                                                                                                                    if (var31_4 == null) break block70;
                                                                                                                                                    var159_154 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                    var160_155 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var159_154) || !LogicalTypeRoot.TINYINT.equals(var160_155)) break block70;
                                                                                                                                                    var10_141 = true;
                                                                                                                                                    break block63;
                                                                                                                                                }
                                                                                                                                                if (var31_4 == null) break block71;
                                                                                                                                                var161_156 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                                var162_157 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var161_156) || !LogicalTypeRoot.SMALLINT.equals(var162_157)) break block71;
                                                                                                                                                var10_141 = true;
                                                                                                                                                break block63;
                                                                                                                                            }
                                                                                                                                            if (var31_4 == null) break block72;
                                                                                                                                            var163_158 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                            var164_159 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var163_158) || !LogicalTypeRoot.INTEGER.equals(var164_159)) break block72;
                                                                                                                                            var10_141 = true;
                                                                                                                                            break block63;
                                                                                                                                        }
                                                                                                                                        if (var31_4 == null) break block73;
                                                                                                                                        var165_160 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                        var166_161 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var165_160) || !LogicalTypeRoot.BIGINT.equals(var166_161)) break block73;
                                                                                                                                        var10_141 = true;
                                                                                                                                        break block63;
                                                                                                                                    }
                                                                                                                                    if (var31_4 == null) break block74;
                                                                                                                                    var167_162 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                    var168_163 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var167_162) || !LogicalTypeRoot.FLOAT.equals(var168_163)) break block74;
                                                                                                                                    var10_141 = true;
                                                                                                                                    break block63;
                                                                                                                                }
                                                                                                                                if (var31_4 == null) break block75;
                                                                                                                                var169_164 = (LogicalTypeRoot)var31_4._1();
                                                                                                                                var170_165 = (LogicalTypeRoot)var31_4._2();
                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var169_164) || !LogicalTypeRoot.DOUBLE.equals(var170_165)) break block75;
                                                                                                                                var10_141 = true;
                                                                                                                                break block63;
                                                                                                                            }
                                                                                                                            if (var31_4 == null) ** GOTO lbl-1000
                                                                                                                            var171_166 = (LogicalTypeRoot)var31_4._1();
                                                                                                                            var172_167 = (LogicalTypeRoot)var31_4._2();
                                                                                                                            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var171_166) && LogicalTypeRoot.DECIMAL.equals(var172_167)) {
                                                                                                                                var10_141 = true;
                                                                                                                            } else lbl-1000:
                                                                                                                            // 2 sources

                                                                                                                            {
                                                                                                                                var10_141 = false;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (var10_141) {
                                                                                                                            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals((Object)targetType.getTypeRoot())) {
                                                                                                                                throw new ValidationException("The cast conversion from NUMERIC type to TIMESTAMP type is not allowed, it's recommended to use TO_TIMESTAMP(FROM_UNIXTIME(numeric_col)) instead, note the numeric is in seconds.");
                                                                                                                            }
                                                                                                                            throw new ValidationException("The cast conversion from TIMESTAMP type to NUMERIC type is not allowed, it's recommended to use UNIX_TIMESTAMP(CAST(timestamp_col AS STRING)) instead.");
                                                                                                                        }
                                                                                                                        if (var31_4 == null) break block76;
                                                                                                                        var173_168 = (LogicalTypeRoot)var31_4._1();
                                                                                                                        var174_169 = (LogicalTypeRoot)var31_4._2();
                                                                                                                        if (!LogicalTypeRoot.TINYINT.equals(var173_168) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var174_169)) break block76;
                                                                                                                        var9_170 = true;
                                                                                                                        break block77;
                                                                                                                    }
                                                                                                                    if (var31_4 == null) break block78;
                                                                                                                    var175_171 = (LogicalTypeRoot)var31_4._1();
                                                                                                                    var176_172 = (LogicalTypeRoot)var31_4._2();
                                                                                                                    if (!LogicalTypeRoot.SMALLINT.equals(var175_171) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var176_172)) break block78;
                                                                                                                    var9_170 = true;
                                                                                                                    break block77;
                                                                                                                }
                                                                                                                if (var31_4 == null) break block79;
                                                                                                                var177_173 = (LogicalTypeRoot)var31_4._1();
                                                                                                                var178_174 = (LogicalTypeRoot)var31_4._2();
                                                                                                                if (!LogicalTypeRoot.INTEGER.equals(var177_173) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var178_174)) break block79;
                                                                                                                var9_170 = true;
                                                                                                                break block77;
                                                                                                            }
                                                                                                            if (var31_4 == null) break block80;
                                                                                                            var179_175 = (LogicalTypeRoot)var31_4._1();
                                                                                                            var180_176 = (LogicalTypeRoot)var31_4._2();
                                                                                                            if (!LogicalTypeRoot.BIGINT.equals(var179_175) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var180_176)) break block80;
                                                                                                            var9_170 = true;
                                                                                                            break block77;
                                                                                                        }
                                                                                                        if (var31_4 == null) break block81;
                                                                                                        var181_177 = (LogicalTypeRoot)var31_4._1();
                                                                                                        var182_178 = (LogicalTypeRoot)var31_4._2();
                                                                                                        if (!LogicalTypeRoot.FLOAT.equals(var181_177) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var182_178)) break block81;
                                                                                                        var9_170 = true;
                                                                                                        break block77;
                                                                                                    }
                                                                                                    if (var31_4 == null) break block82;
                                                                                                    var183_179 = (LogicalTypeRoot)var31_4._1();
                                                                                                    var184_180 = (LogicalTypeRoot)var31_4._2();
                                                                                                    if (!LogicalTypeRoot.DOUBLE.equals(var183_179) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var184_180)) break block82;
                                                                                                    var9_170 = true;
                                                                                                    break block77;
                                                                                                }
                                                                                                if (var31_4 == null) break block83;
                                                                                                var185_181 = (LogicalTypeRoot)var31_4._1();
                                                                                                var186_182 = (LogicalTypeRoot)var31_4._2();
                                                                                                if (!LogicalTypeRoot.DECIMAL.equals(var185_181) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var186_182)) break block83;
                                                                                                var9_170 = true;
                                                                                                break block77;
                                                                                            }
                                                                                            if (var31_4 == null) break block84;
                                                                                            var187_183 = (LogicalTypeRoot)var31_4._1();
                                                                                            var188_184 = (LogicalTypeRoot)var31_4._2();
                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var187_183) || !LogicalTypeRoot.TINYINT.equals(var188_184)) break block84;
                                                                                            var9_170 = true;
                                                                                            break block77;
                                                                                        }
                                                                                        if (var31_4 == null) break block85;
                                                                                        var189_185 = (LogicalTypeRoot)var31_4._1();
                                                                                        var190_186 = (LogicalTypeRoot)var31_4._2();
                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var189_185) || !LogicalTypeRoot.SMALLINT.equals(var190_186)) break block85;
                                                                                        var9_170 = true;
                                                                                        break block77;
                                                                                    }
                                                                                    if (var31_4 == null) break block86;
                                                                                    var191_187 = (LogicalTypeRoot)var31_4._1();
                                                                                    var192_188 = (LogicalTypeRoot)var31_4._2();
                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var191_187) || !LogicalTypeRoot.INTEGER.equals(var192_188)) break block86;
                                                                                    var9_170 = true;
                                                                                    break block77;
                                                                                }
                                                                                if (var31_4 == null) break block87;
                                                                                var193_189 = (LogicalTypeRoot)var31_4._1();
                                                                                var194_190 = (LogicalTypeRoot)var31_4._2();
                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var193_189) || !LogicalTypeRoot.BIGINT.equals(var194_190)) break block87;
                                                                                var9_170 = true;
                                                                                break block77;
                                                                            }
                                                                            if (var31_4 == null) break block88;
                                                                            var195_191 = (LogicalTypeRoot)var31_4._1();
                                                                            var196_192 = (LogicalTypeRoot)var31_4._2();
                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var195_191) || !LogicalTypeRoot.FLOAT.equals(var196_192)) break block88;
                                                                            var9_170 = true;
                                                                            break block77;
                                                                        }
                                                                        if (var31_4 == null) break block89;
                                                                        var197_193 = (LogicalTypeRoot)var31_4._1();
                                                                        var198_194 = (LogicalTypeRoot)var31_4._2();
                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var197_193) || !LogicalTypeRoot.DOUBLE.equals(var198_194)) break block89;
                                                                        var9_170 = true;
                                                                        break block77;
                                                                    }
                                                                    if (var31_4 == null) ** GOTO lbl-1000
                                                                    var199_195 = (LogicalTypeRoot)var31_4._1();
                                                                    var200_196 = (LogicalTypeRoot)var31_4._2();
                                                                    if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var199_195) && LogicalTypeRoot.DECIMAL.equals(var200_196)) {
                                                                        var9_170 = true;
                                                                    } else lbl-1000:
                                                                    // 2 sources

                                                                    {
                                                                        var9_170 = false;
                                                                    }
                                                                }
                                                                if (var9_170) {
                                                                    if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)targetType.getTypeRoot())) {
                                                                        throw new ValidationException("The cast conversion from NUMERIC type to TIMESTAMP_LTZ type is not allowed, it's recommended to use TO_TIMESTAMP_LTZ(numeric_col, precision) instead.");
                                                                    }
                                                                    throw new ValidationException("The cast conversion from TIMESTAMP_LTZ type to NUMERIC type is not allowed.");
                                                                }
                                                                if (var31_4 == null) break block90;
                                                                var201_197 = (LogicalTypeRoot)var31_4._1();
                                                                var202_198 = (LogicalTypeRoot)var31_4._2();
                                                                if (!LogicalTypeRoot.DATE.equals(var201_197) || !LogicalTypeRoot.INTEGER.equals(var202_198)) break block90;
                                                                var8_199 = true;
                                                                break block91;
                                                            }
                                                            if (var31_4 == null) break block92;
                                                            var203_200 = (LogicalTypeRoot)var31_4._1();
                                                            var204_201 = (LogicalTypeRoot)var31_4._2();
                                                            if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var203_200) || !LogicalTypeRoot.INTEGER.equals(var204_201)) break block92;
                                                            var8_199 = true;
                                                            break block91;
                                                        }
                                                        if (var31_4 == null) break block93;
                                                        var205_202 = (LogicalTypeRoot)var31_4._1();
                                                        var206_203 = (LogicalTypeRoot)var31_4._2();
                                                        if (!LogicalTypeRoot.INTEGER.equals(var205_202) || !LogicalTypeRoot.DATE.equals(var206_203)) break block93;
                                                        var8_199 = true;
                                                        break block91;
                                                    }
                                                    if (var31_4 == null) break block94;
                                                    var207_204 = (LogicalTypeRoot)var31_4._1();
                                                    var208_205 = (LogicalTypeRoot)var31_4._2();
                                                    if (!LogicalTypeRoot.INTEGER.equals(var207_204) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var208_205)) break block94;
                                                    var8_199 = true;
                                                    break block91;
                                                }
                                                if (var31_4 == null) break block95;
                                                var209_206 = (LogicalTypeRoot)var31_4._1();
                                                var210_207 = (LogicalTypeRoot)var31_4._2();
                                                if (!LogicalTypeRoot.INTEGER.equals(var209_206) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var210_207)) break block95;
                                                var8_199 = true;
                                                break block91;
                                            }
                                            if (var31_4 == null) break block96;
                                            var211_208 = (LogicalTypeRoot)var31_4._1();
                                            var212_209 = (LogicalTypeRoot)var31_4._2();
                                            if (!LogicalTypeRoot.BIGINT.equals(var211_208) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var212_209)) break block96;
                                            var8_199 = true;
                                            break block91;
                                        }
                                        if (var31_4 == null) break block97;
                                        var213_210 = (LogicalTypeRoot)var31_4._1();
                                        var214_211 = (LogicalTypeRoot)var31_4._2();
                                        if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var213_210) || !LogicalTypeRoot.INTEGER.equals(var214_211)) break block97;
                                        var8_199 = true;
                                        break block91;
                                    }
                                    if (var31_4 == null) ** GOTO lbl-1000
                                    var215_212 = (LogicalTypeRoot)var31_4._1();
                                    var216_213 = (LogicalTypeRoot)var31_4._2();
                                    if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var215_212) && LogicalTypeRoot.BIGINT.equals(var216_213)) {
                                        var8_199 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        var8_199 = false;
                                    }
                                }
                                if (!var8_199) break block98;
                                var4_16 = this.internalExprCasting(operand, targetType);
                                break block27;
                            }
                            if (var31_4 == null) break block99;
                            var217_214 = (LogicalTypeRoot)var31_4._1();
                            var218_215 = (LogicalTypeRoot)var31_4._2();
                            if (!LogicalTypeRoot.DATE.equals(var217_214) || !LogicalTypeRoot.BIGINT.equals(var218_215)) break block99;
                            var7_216 = true;
                            break block100;
                        }
                        if (var31_4 == null) break block101;
                        var219_217 = (LogicalTypeRoot)var31_4._1();
                        var220_218 = (LogicalTypeRoot)var31_4._2();
                        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var219_217) || !LogicalTypeRoot.BIGINT.equals(var220_218)) break block101;
                        var7_216 = true;
                        break block100;
                    }
                    if (var31_4 == null) ** GOTO lbl-1000
                    var221_219 = (LogicalTypeRoot)var31_4._1();
                    var222_220 = (LogicalTypeRoot)var31_4._2();
                    if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var221_219) && LogicalTypeRoot.BIGINT.equals(var222_220)) {
                        var7_216 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var7_216 = false;
                    }
                }
                if (!var7_216) break block102;
                var4_16 = this.internalExprCasting(operand, targetType);
                break block27;
            }
            if (var31_4 == null) ** GOTO lbl-1000
            var223_221 = (LogicalTypeRoot)var31_4._1();
            var224_222 = (LogicalTypeRoot)var31_4._2();
            var6_223 = LogicalTypeRoot.ROW.equals(var223_221) != false ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(var223_221) != false;
            if (var6_223 && (var5_224 = LogicalTypeRoot.ROW.equals(var224_222) != false ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(var224_222) != false) && LogicalTypeCasts.supportsExplicitCast((LogicalType)operand.resultType(), (LogicalType)targetType)) {
                var4_16 = this.generateCastRowToRow(ctx, operand, targetType);
            } else lbl-1000:
            // 2 sources

            {
                if (var31_4 != null) {
                    throw new CodeGenException(new StringBuilder(31).append("Unsupported cast from '").append(operand.resultType()).append("' to '").append(targetType).append("'.").toString());
                }
                throw new MatchError((Object)var31_4);
            }
        }
        return var4_16;
    }

    public GeneratedExpression generateIfElse(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType resultType, int i) {
        GeneratedExpression generatedExpression;
        if (i == operands.size() - 1) {
            generatedExpression = this.generateCast(ctx, (GeneratedExpression)operands.apply(i), resultType);
        } else {
            CodeGenUtils$.MODULE$.requireBoolean((GeneratedExpression)operands.apply(i));
            GeneratedExpression condition = (GeneratedExpression)operands.apply(i);
            GeneratedExpression trueAction = this.generateCast(ctx, (GeneratedExpression)operands.apply(i + 1), resultType);
            GeneratedExpression falseAction = this.generateIfElse(ctx, operands, resultType, i + 2);
            Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError(seq);
            }
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            Tuple2 tuple22 = tuple2;
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType);
            String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n           |").append(condition.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n           |boolean ").append(nullTerm2).append(";\n           |if (").append(condition.resultTerm()).append(") {\n           |  ").append(trueAction.code()).append("\n           |  ").append(nullTerm2).append(" = ").append(trueAction.nullTerm()).append(";\n           |  if (!").append(nullTerm2).append(") {\n           |    ").append(resultTerm2).append(" = ").append(trueAction.resultTerm()).append(";\n           |  }\n           |}\n           |else {\n           |  ").append(falseAction.code()).append("\n           |  ").append(nullTerm2).append(" = ").append(falseAction.nullTerm()).append(";\n           |  if (!").append(nullTerm2).append(") {\n           |    ").append(resultTerm2).append(" = ").append(falseAction.resultTerm()).append(";\n           |  }\n           |}\n           |").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(176).append("\n           |").append(condition.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(";\n           |if (").append(condition.resultTerm()).append(") {\n           |  ").append(trueAction.code()).append("\n           |  ").append(resultTerm2).append(" = ").append(trueAction.resultTerm()).append(";\n           |}\n           |else {\n           |  ").append(falseAction.code()).append("\n           |  ").append(resultTerm2).append(" = ").append(falseAction.resultTerm()).append(";\n           |}\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public int generateIfElse$default$4() {
        return 0;
    }

    public GeneratedExpression generateDot(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands) {
        if (operands.size() > 2) {
            throw new CodeGenException("A DOT operator with more than 2 operands is not supported yet.");
        }
        Preconditions.checkArgument((boolean)((GeneratedExpression)operands.apply(1)).literal());
        Preconditions.checkArgument((boolean)TypeCheckUtils.isCharacterString((LogicalType)((GeneratedExpression)operands.apply(1)).resultType()));
        Preconditions.checkArgument((boolean)(((GeneratedExpression)operands.head()).resultType() instanceof RowType));
        String fieldName = ((GeneratedExpression)operands.apply(1)).literalValue().get().toString();
        int fieldIdx = ((RowType)((GeneratedExpression)operands.head()).resultType()).getFieldIndex(fieldName);
        GeneratedExpression access = GenerateUtils$.MODULE$.generateFieldAccess(ctx, ((GeneratedExpression)operands.head()).resultType(), ((GeneratedExpression)operands.head()).resultTerm(), fieldIdx);
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(access.resultType());
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(access.resultType());
        String resultCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(";\n         |boolean ").append(nullTerm2).append(";\n         |if (").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(") {\n         |  ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |  ").append(nullTerm2).append(" = true;\n         |}\n         |else {\n         |  ").append(access.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(access.resultTerm()).append(";\n         |  ").append(nullTerm2).append(" = ").append(access.nullTerm()).append(";\n         |}\n         |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(access.code()).append("\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(access.resultTerm()).append(";\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, resultCode, access.resultType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        GeneratedExpression generatedExpression;
        List fieldTypes = LogicalTypeChecks.getFieldTypes((LogicalType)rowType);
        boolean isLiteral = elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal()));
        boolean isPrimitive = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalarOperatorGens$.$anonfun$generateRow$2(x$1)));
        if (isLiteral) {
            generatedExpression = this.generateLiteralRow(ctx, rowType, elements);
        } else if (isPrimitive) {
            Seq mapped = (Seq)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GeneratedExpression generatedExpression;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (element.literal()) {
                        generatedExpression = element;
                    } else {
                        LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).apply(idx);
                        String resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(tpe);
                        generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), tpe, (Option<Object>)new Some(null));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                GeneratedExpression generatedExpression2 = generatedExpression;
                return generatedExpression2;
            }, Seq$.MODULE$.canBuildFrom());
            GeneratedExpression row = this.generateLiteralRow(ctx, rowType, (Seq<GeneratedExpression>)mapped);
            String code = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                GeneratedExpression element = (GeneratedExpression)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).apply(idx);
                String string = element.literal() ? "" : (ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n               |").append(element.code()).append("\n               |if (").append(element.nullTerm()).append(") {\n               |  ").append(CodeGenUtils$.MODULE$.binaryRowSetNull(idx, row.resultTerm(), tpe)).append(";\n               |} else {\n               |  ").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, row.resultTerm(), tpe, element.resultTerm())).append(";\n               |}\n           ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("\n               |").append(element.code()).append("\n               |").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, row.resultTerm(), tpe, element.resultTerm())).append(";\n           ").toString())).stripMargin());
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
            generatedExpression = new GeneratedExpression(row.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), code, rowType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = this.generateNonLiteralRow(ctx, rowType, elements);
        }
        return generatedExpression;
    }

    private GeneratedExpression generateLiteralRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        Preconditions.checkArgument((boolean)elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal())));
        GeneratedExpression expr = this.generateNonLiteralRow(ctx, rowType, elements);
        ctx.addReusableInitStatement(expr.code());
        return new GeneratedExpression(expr.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), rowType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateNonLiteralRow(CodeGeneratorContext ctx, LogicalType rowType, Seq<GeneratedExpression> elements) {
        List fieldTypes = LogicalTypeChecks.getFieldTypes((LogicalType)rowType);
        String rowTerm = CodeGenUtils$.MODULE$.newName("row");
        String writerTerm = CodeGenUtils$.MODULE$.newName("writer");
        String writerCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryRowWriter.class));
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).apply(idx);
            String string = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n             |").append(element.code()).append("\n             |if (").append(element.nullTerm()).append(") {\n             |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteNull(idx, writerTerm, tpe)).append(";\n             |} else {\n             |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, tpe)).append(";\n             |}\n           ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(43).append("\n             |").append(element.code()).append("\n             |").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, tpe)).append(";\n           ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n         |").append(writerTerm).append(".reset();\n         |").append(writeCode).append("\n         |").append(writerTerm).append(".complete();\n       ").toString())).stripMargin();
        ctx.addReusableMember(new StringBuilder(11).append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(" ").append(rowTerm).append(" = new ").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append("(").append(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).length()).append(");").toString());
        ctx.addReusableMember(new StringBuilder(11).append(writerCls).append(" ").append(writerTerm).append(" = new ").append(writerCls).append("(").append(rowTerm).append(");").toString());
        return new GeneratedExpression(rowTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, rowType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArray(CodeGeneratorContext ctx, LogicalType resultType, Seq<GeneratedExpression> elements) {
        GeneratedExpression generatedExpression;
        Preconditions.checkArgument((boolean)(resultType instanceof ArrayType));
        ArrayType arrayType = (ArrayType)resultType;
        LogicalType elementType = arrayType.getElementType();
        boolean isLiteral = elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal()));
        boolean isPrimitive = PlannerTypeUtils.isPrimitive((LogicalType)elementType);
        if (isLiteral) {
            generatedExpression = this.generateLiteralArray(ctx, arrayType, elements);
        } else if (isPrimitive) {
            Seq mapped = (Seq)elements.map((Function1 & Serializable & scala.Serializable)element -> {
                GeneratedExpression generatedExpression;
                if (element.literal()) {
                    generatedExpression = element;
                } else {
                    String resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType);
                    generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), elementType, (Option<Object>)new Some(null));
                }
                return generatedExpression;
            }, Seq$.MODULE$.canBuildFrom());
            GeneratedExpression array = this.generateLiteralArray(ctx, arrayType, (Seq<GeneratedExpression>)mapped);
            String code = this.generatePrimitiveArrayUpdateCode(ctx, array.resultTerm(), elementType, elements);
            generatedExpression = new GeneratedExpression(array.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = this.generateNonLiteralArray(ctx, arrayType, elements);
        }
        return generatedExpression;
    }

    private String generatePrimitiveArrayUpdateCode(CodeGeneratorContext ctx, String arrayTerm, LogicalType elementType, Seq<GeneratedExpression> elements) {
        return ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = element.literal() ? "" : (ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           |").append(element.code()).append("\n           |if (").append(element.nullTerm()).append(") {\n           |  ").append(CodeGenUtils$.MODULE$.binaryArraySetNull(idx, arrayTerm, elementType)).append(";\n           |} else {\n           |  ").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, arrayTerm, elementType, element.resultTerm())).append(";\n           |}\n             ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n           |").append(element.code()).append("\n           |").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, arrayTerm, elementType, element.resultTerm())).append(";\n             ").toString())).stripMargin());
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private GeneratedExpression generateLiteralArray(CodeGeneratorContext ctx, ArrayType arrayType, Seq<GeneratedExpression> elements) {
        Preconditions.checkArgument((boolean)elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal())));
        GeneratedExpression expr = this.generateNonLiteralArray(ctx, arrayType, elements);
        ctx.addReusableInitStatement(expr.code());
        return new GeneratedExpression(expr.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateNonLiteralArray(CodeGeneratorContext ctx, ArrayType arrayType, Seq<GeneratedExpression> elements) {
        LogicalType elementType = arrayType.getElementType();
        String arrayTerm = CodeGenUtils$.MODULE$.newName("array");
        String writerTerm = CodeGenUtils$.MODULE$.newName("writer");
        String writerCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryArrayWriter.class));
        int elementSize = BinaryArrayData.calculateFixLengthPartSize((LogicalType)elementType);
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n           |").append(element.code()).append("\n           |if (").append(element.nullTerm()).append(") {\n           |  ").append(CodeGenUtils$.MODULE$.binaryArraySetNull(idx, writerTerm, elementType)).append(";\n           |} else {\n           |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, elementType)).append(";\n           |}\n          ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n         |").append(writerTerm).append(".reset();\n         |").append(writeCode).append("\n         |").append(writerTerm).append(".complete();\n         ").toString())).stripMargin();
        String memberStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(56).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(arrayTerm).append(" = new ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append("();\n         |").append(writerCls).append(" ").append(writerTerm).append(" = new ").append(writerCls).append("(").append(arrayTerm).append(", ").append(elements.length()).append(", ").append(elementSize).append(");\n       ").toString())).stripMargin();
        ctx.addReusableMember(memberStmt);
        return new GeneratedExpression(arrayTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayElementAt(CodeGeneratorContext ctx, GeneratedExpression array, GeneratedExpression index) {
        int n;
        Some some;
        Object v;
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some2.get()).apply(0);
        String nullTerm = (String)((SeqLike)some2.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        LogicalType componentInfo = ((ArrayType)array.resultType()).getElementType();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(componentInfo);
        String defaultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(componentInfo);
        Option<Object> option = index.literalValue();
        if (option instanceof Some && (v = (some = (Some)option).value()) instanceof Integer && (n = BoxesRunTime.unboxToInt((Object)v)) < 1) {
            throw new ValidationException(new StringBuilder(59).append("Array element access needs an index starting at 1 but was ").append(n).append(".").toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String idxStr = new StringBuilder(4).append(index.resultTerm()).append(" - 1").toString();
        String arrayIsNull = new StringBuilder(11).append(array.resultTerm()).append(".isNullAt(").append(idxStr).append(")").toString();
        String arrayGet = CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, idxStr, array.resultTerm(), componentInfo);
        String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n        |").append(array.code()).append("\n        |").append(index.code()).append("\n        |boolean ").append(nullTerm2).append(" = ").append(array.nullTerm()).append(" || ").append(index.nullTerm()).append(" ||\n        |   ").append(idxStr).append(" < 0 || ").append(idxStr).append(" >= ").append(array.resultTerm()).append(".size() || ").append(arrayIsNull).append(";\n        |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(nullTerm2).append(" ? ").append(defaultTerm).append(" : ").append(arrayGet).append(";\n        |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, componentInfo, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayElement(CodeGeneratorContext ctx, GeneratedExpression array) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        LogicalType resultType = ((ArrayType)array.resultType()).getElementType();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType);
        String arrayLengthCode = new StringBuilder(14).append(array.nullTerm()).append(" ? 0 : ").append(array.resultTerm()).append(".size()").toString();
        String arrayGet = CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, 0, array.resultTerm(), resultType);
        String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(368).append("\n         |").append(array.code()).append("\n         |boolean ").append(nullTerm2).append(";\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(";\n         |switch (").append(arrayLengthCode).append(") {\n         |  case 0:\n         |    ").append(nullTerm2).append(" = true;\n         |    ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |    break;\n         |  case 1:\n         |    ").append(nullTerm2).append(" = ").append(array.resultTerm()).append(".isNullAt(0);\n         |    ").append(resultTerm2).append(" = ").append(nullTerm2).append(" ? ").append(defaultValue).append(" : ").append(arrayGet).append(";\n         |    break;\n         |  default:\n         |    throw new RuntimeException(\"Array has more than one element.\");\n         |}\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayCardinality(CodeGeneratorContext ctx, GeneratedExpression array) {
        return this.generateUnaryOperatorIfNotNull(ctx, (LogicalType)new IntType(), array, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$14 -> new StringBuilder(7).append(array.resultTerm()).append(".size()").toString());
    }

    public GeneratedExpression generateMap(CodeGeneratorContext ctx, LogicalType resultType, Seq<GeneratedExpression> elements) {
        String string;
        Preconditions.checkArgument((boolean)(resultType instanceof MapType));
        MapType mapType = (MapType)resultType;
        String baseMap = CodeGenUtils$.MODULE$.newName("map");
        Seq keyElements = elements.grouped(2).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            GeneratedExpression key;
            Seq seq = x0$6;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            GeneratedExpression generatedExpression = key = (GeneratedExpression)((SeqLike)some.get()).apply(0);
            return generatedExpression;
        }).toSeq();
        LogicalType keyType = mapType.getKeyType();
        GeneratedExpression keyExpr = this.generateArray(ctx, (LogicalType)new ArrayType(keyType), (Seq<GeneratedExpression>)keyElements);
        boolean isKeyFixLength = PlannerTypeUtils.isPrimitive((LogicalType)keyType);
        Seq valueElements = elements.grouped(2).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            GeneratedExpression value;
            Seq seq = x0$7;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            GeneratedExpression generatedExpression = value = (GeneratedExpression)((SeqLike)some.get()).apply(1);
            return generatedExpression;
        }).toSeq();
        LogicalType valueType = mapType.getValueType();
        GeneratedExpression valueExpr = this.generateArray(ctx, (LogicalType)new ArrayType(valueType), (Seq<GeneratedExpression>)valueElements);
        boolean isValueFixLength = PlannerTypeUtils.isPrimitive((LogicalType)valueType);
        ctx.addReusableMember(new StringBuilder(9).append(CodeGenUtils$.MODULE$.MAP_DATA()).append(" ").append(baseMap).append(" = null;").toString());
        if (isKeyFixLength && isValueFixLength) {
            String binaryMap = CodeGenUtils$.MODULE$.newName("binaryMap");
            ctx.addReusableMember(new StringBuilder(9).append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(" ").append(binaryMap).append(" = null;").toString());
            String init = new StringBuilder(16).append(binaryMap).append(" = ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(".valueOf(").append(keyExpr.resultTerm()).append(", ").append(valueExpr.resultTerm()).append(");").toString();
            ctx.addReusableInitStatement(init);
            String keyArrayTerm = CodeGenUtils$.MODULE$.newName("keyArray");
            String valueArrayTerm = CodeGenUtils$.MODULE$.newName("valueArray");
            String keyUpdate = this.generatePrimitiveArrayUpdateCode(ctx, keyArrayTerm, keyType, (Seq<GeneratedExpression>)keyElements);
            String valueUpdate = this.generatePrimitiveArrayUpdateCode(ctx, valueArrayTerm, valueType, (Seq<GeneratedExpression>)valueElements);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(101).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(keyArrayTerm).append(" = ").append(binaryMap).append(".keyArray();\n         |").append(keyUpdate).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(valueArrayTerm).append(" = ").append(binaryMap).append(".valueArray();\n         |").append(valueUpdate).append("\n         |").append(baseMap).append(" = ").append(binaryMap).append(";\n       ").toString())).stripMargin();
        } else {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n         |").append(keyExpr.code()).append("\n         |").append(valueExpr.code()).append("\n         |").append(baseMap).append(" = ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(".valueOf(").append(keyExpr.resultTerm()).append(", ").append(valueExpr.resultTerm()).append(");\n       ").toString())).stripMargin();
        }
        String code = string;
        return new GeneratedExpression(baseMap, GeneratedExpression$.MODULE$.NEVER_NULL(), code, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateMapGet(CodeGeneratorContext ctx, GeneratedExpression map, GeneratedExpression key) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String tmpKey = CodeGenUtils$.MODULE$.newName("key");
        String length = CodeGenUtils$.MODULE$.newName("length");
        String keys = CodeGenUtils$.MODULE$.newName("keys");
        String values = CodeGenUtils$.MODULE$.newName("values");
        String index = CodeGenUtils$.MODULE$.newName("index");
        String found = CodeGenUtils$.MODULE$.newName("found");
        String tmpValue = CodeGenUtils$.MODULE$.newName("value");
        MapType mapType = (MapType)map.resultType();
        LogicalType keyType = mapType.getKeyType();
        LogicalType valueType = mapType.getValueType();
        String keyTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
        String valueTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
        String valueDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType);
        String binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
        String genericMapTerm = CodeGenUtils$.MODULE$.newName("genericMap");
        String boxedValueTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(valueType);
        String mapTerm = map.resultTerm();
        GeneratedExpression equal = this.generateEquals(ctx, new GeneratedExpression(key.resultTerm(), key.nullTerm(), GeneratedExpression$.MODULE$.NO_CODE(), key.resultType(), key.literalValue()), new GeneratedExpression(tmpKey, GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), keyType, GeneratedExpression$.MODULE$.apply$default$5()));
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(995).append("\n         |if (").append(mapTerm).append(" instanceof ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(") {\n         |  ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(" ").append(binaryMapTerm).append(" = (").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(") ").append(mapTerm).append(";\n         |  final int ").append(length).append(" = ").append(binaryMapTerm).append(".size();\n         |  final ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(keys).append(" = ").append(binaryMapTerm).append(".keyArray();\n         |  final ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(values).append(" = ").append(binaryMapTerm).append(".valueArray();\n         |\n         |  int ").append(index).append(" = 0;\n         |  boolean ").append(found).append(" = false;\n         |  if (").append(key.nullTerm()).append(") {\n         |    while (").append(index).append(" < ").append(length).append(" && !").append(found).append(") {\n         |      if (").append(keys).append(".isNullAt(").append(index).append(")) {\n         |        ").append(found).append(" = true;\n         |      } else {\n         |        ").append(index).append("++;\n         |      }\n         |    }\n         |  } else {\n         |    while (").append(index).append(" < ").append(length).append(" && !").append(found).append(") {\n         |      final ").append(keyTypeTerm).append(" ").append(tmpKey).append(" = ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, index, keys, keyType)).append(";\n         |      ").append(equal.code()).append("\n         |      if (").append(equal.resultTerm()).append(") {\n         |        ").append(found).append(" = true;\n         |      } else {\n         |        ").append(index).append("++;\n         |      }\n         |    }\n         |  }\n         |\n         |  if (!").append(found).append(" || ").append(values).append(".isNullAt(").append(index).append(")) {\n         |    ").append(nullTerm2).append(" = true;\n         |  } else {\n         |    ").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, index, values, valueType)).append(";\n         |  }\n         |} else {\n         |  ").append(CodeGenUtils$.MODULE$.GENERIC_MAP()).append(" ").append(genericMapTerm).append(" = (").append(CodeGenUtils$.MODULE$.GENERIC_MAP()).append(") ").append(mapTerm).append(";\n         |  ").append(boxedValueTypeTerm).append(" ").append(tmpValue).append(" =\n         |    (").append(boxedValueTypeTerm).append(") ").append(genericMapTerm).append(".get((").append(keyTypeTerm).append(") ").append(key.resultTerm()).append(");\n         |  if (").append(tmpValue).append(" == null) {\n         |    ").append(nullTerm2).append(" = true;\n         |  } else {\n         |    ").append(resultTerm2).append(" = ").append(tmpValue).append(";\n         |  }\n         |}\n        ").toString())).stripMargin();
        String accessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n         |").append(map.code()).append("\n         |").append(key.code()).append("\n         |boolean ").append(nullTerm2).append(" = (").append(map.nullTerm()).append(" || ").append(key.nullTerm()).append(");\n         |").append(valueTypeTerm).append(" ").append(resultTerm2).append(" = ").append(valueDefault).append(";\n         |if (!").append(nullTerm2).append(") {\n         | ").append(code).append("\n         |}\n        ").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, accessCode, valueType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateMapCardinality(CodeGeneratorContext ctx, GeneratedExpression map) {
        return this.generateUnaryOperatorIfNotNull(ctx, (LogicalType)new IntType(), map, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$16 -> new StringBuilder(7).append(map.resultTerm()).append(".size()").toString());
    }

    private GeneratedExpression generateCastRowToRow(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetRowType) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, targetRowType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)x0$8 -> {
            Seq seq = x0$8;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)seq);
            }
            String rowTerm = (String)((SeqLike)some.get()).apply(0);
            Buffer fieldExprs = (Buffer)((TraversableLike)((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operand.resultType().getChildren()).zip((GenIterable)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(targetRowType.getChildren()), Buffer$.MODULE$.canBuildFrom())).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                int idx;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$9;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        idx = tuple22._2$mcI$sp();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                LogicalType sourceType = (LogicalType)tuple2._1();
                LogicalType targetType = (LogicalType)tuple2._2();
                String sourceTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(sourceType);
                String sourceTerm = CodeGenUtils$.MODULE$.newName("field");
                String sourceAccessCode = CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, idx, rowTerm, sourceType);
                GeneratedExpression sourceExpr = new GeneratedExpression(sourceTerm, new StringBuilder(11).append(rowTerm).append(".isNullAt(").append(idx).append(")").toString(), new StringBuilder(8).append(sourceTypeTerm).append(" ").append(sourceTerm).append(" = (").append(sourceTypeTerm).append(") ").append(sourceAccessCode).append(";").toString(), sourceType, GeneratedExpression$.MODULE$.apply$default$5());
                GeneratedExpression generatedExpression = MODULE$.generateCast(ctx, sourceExpr, targetType);
                return generatedExpression;
            }, Buffer$.MODULE$.canBuildFrom());
            GeneratedExpression generateRowExpr = MODULE$.generateRow(ctx, targetRowType, (Seq<GeneratedExpression>)fieldExprs);
            Tuple2 tuple2 = new Tuple2((Object)generateRowExpr.code(), (Object)generateRowExpr.resultTerm());
            return tuple2;
        });
    }

    private GeneratedExpression generateCastStringLiteralToDateTime(CodeGeneratorContext ctx, GeneratedExpression stringLiteral, LogicalType expectType) {
        Preconditions.checkArgument((boolean)stringLiteral.literal());
        String rightTerm = stringLiteral.resultTerm();
        String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(expectType);
        String defaultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(expectType);
        String term = CodeGenUtils$.MODULE$.newName("stringToTime");
        String code = this.stringToLocalTimeCode(expectType, rightTerm);
        String stmt = new StringBuilder(11).append(typeTerm).append(" ").append(term).append(" = ").append(stringLiteral.nullTerm()).append(" ? ").append(defaultTerm).append(" : ").append(code).append(";").toString();
        ctx.addReusableMember(stmt);
        LogicalType x$42 = expectType;
        String x$43 = term;
        String x$44 = stringLiteral.copy$default$2();
        String x$45 = stringLiteral.copy$default$3();
        Option<Object> x$46 = stringLiteral.copy$default$5();
        return stringLiteral.copy(x$43, x$44, x$45, x$42, x$46);
    }

    private GeneratedExpression generateCastArrayToString(CodeGeneratorContext ctx, GeneratedExpression operand, ArrayType at, LogicalType targetType) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)terms -> {
            String builderCls = StringBuilder.class.getCanonicalName();
            String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
            ctx.addReusableMember(new StringBuilder(11).append(builderCls).append(" ").append(builderTerm).append(" = new ").append(builderCls).append("();").toString());
            String arrayTerm = (String)terms.head();
            String indexTerm = CodeGenUtils$.MODULE$.newName("i");
            String numTerm = CodeGenUtils$.MODULE$.newName("num");
            LogicalType elementType = at.getElementType();
            String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
            String elementTerm = CodeGenUtils$.MODULE$.newName("element");
            String elementNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String elementCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n             |").append(elementCls).append(" ").append(elementTerm).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType)).append(";\n             |boolean ").append(elementNullTerm).append(" = ").append(arrayTerm).append(".isNullAt(").append(indexTerm).append(");\n             |if (!").append(elementNullTerm).append(") {\n             |  ").append(elementTerm).append(" = (").append(elementCls).append(") ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, indexTerm, arrayTerm, elementType)).append(";\n             |}\n             ").toString())).stripMargin();
            GeneratedExpression elementExpr = new GeneratedExpression(elementTerm, elementNullTerm, elementCode, elementType, GeneratedExpression$.MODULE$.apply$default$5());
            GeneratedExpression castExpr = MODULE$.generateCast(ctx, elementExpr, targetType);
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(428).append("\n             |").append(builderTerm).append(".setLength(0);\n             |").append(builderTerm).append(".append(\"[\");\n             |int ").append(numTerm).append(" = ").append(arrayTerm).append(".size();\n             |for (int ").append(indexTerm).append(" = 0; ").append(indexTerm).append(" < ").append(numTerm).append("; ").append(indexTerm).append("++) {\n             |  if (").append(indexTerm).append(" != 0) {\n             |    ").append(builderTerm).append(".append(\", \");\n             |  }\n             |\n             |  ").append(castExpr.code()).append("\n             |  if (").append(castExpr.nullTerm()).append(") {\n             |    ").append(builderTerm).append(".append(\"null\");\n             |  } else {\n             |    ").append(builderTerm).append(".append(").append(castExpr.resultTerm()).append(");\n             |  }\n             |}\n             |").append(builderTerm).append(".append(\"]\");\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)new StringBuilder(11).append(builderTerm).append(".toString()").toString());
        });
    }

    private GeneratedExpression generateCastMapToString(CodeGeneratorContext ctx, GeneratedExpression operand, MapType mt, LogicalType targetType) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)terms -> {
            String resultTerm = CodeGenUtils$.MODULE$.newName("toStringResult");
            String builderCls = StringBuilder.class.getCanonicalName();
            String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
            ctx.addReusableMember(new StringBuilder(11).append(builderCls).append(" ").append(builderTerm).append(" = new ").append(builderCls).append("();").toString());
            String mapTerm = (String)terms.head();
            String genericMapTerm = CodeGenUtils$.MODULE$.newName("genericMap");
            String binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
            String keyArrayTerm = CodeGenUtils$.MODULE$.newName("keyArray");
            String valueArrayTerm = CodeGenUtils$.MODULE$.newName("valueArray");
            String indexTerm = CodeGenUtils$.MODULE$.newName("i");
            String numTerm = CodeGenUtils$.MODULE$.newName("num");
            LogicalType keyType = mt.getKeyType();
            String keyCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
            String keyTerm = CodeGenUtils$.MODULE$.newName("key");
            String keyNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String keyCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n             |").append(keyCls).append(" ").append(keyTerm).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue(keyType)).append(";\n             |boolean ").append(keyNullTerm).append(" = ").append(keyArrayTerm).append(".isNullAt(").append(indexTerm).append(");\n             |if (!").append(keyNullTerm).append(") {\n             |  ").append(keyTerm).append(" = (").append(keyCls).append(") ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, indexTerm, keyArrayTerm, keyType)).append(";\n             |}\n             ").toString())).stripMargin();
            GeneratedExpression keyExpr = new GeneratedExpression(keyTerm, keyNullTerm, keyCode, keyType, GeneratedExpression$.MODULE$.apply$default$5());
            GeneratedExpression keyCastExpr = MODULE$.generateCast(ctx, keyExpr, targetType);
            LogicalType valueType = mt.getValueType();
            String valueCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
            String valueTerm = CodeGenUtils$.MODULE$.newName("value");
            String valueNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String valueCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n             |").append(valueCls).append(" ").append(valueTerm).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType)).append(";\n             |boolean ").append(valueNullTerm).append(" = ").append(valueArrayTerm).append(".isNullAt(").append(indexTerm).append(");\n             |if (!").append(valueNullTerm).append(") {\n             |  ").append(valueTerm).append(" = (").append(valueCls).append(") ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, indexTerm, valueArrayTerm, valueType)).append(";\n             |}\n             ").toString())).stripMargin();
            GeneratedExpression valueExpr = new GeneratedExpression(valueTerm, valueNullTerm, valueCode, valueType, GeneratedExpression$.MODULE$.apply$default$5());
            GeneratedExpression valueCastExpr = MODULE$.generateCast(ctx, valueExpr, targetType);
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(988).append("\n             |String ").append(resultTerm).append(";\n             |if (").append(mapTerm).append(" instanceof ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(") {\n             |  ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(" ").append(binaryMapTerm).append(" = (").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(") ").append(mapTerm).append(";\n             |  ").append(CodeGenUtils$.MODULE$.ARRAY_DATA()).append(" ").append(keyArrayTerm).append(" = ").append(binaryMapTerm).append(".keyArray();\n             |  ").append(CodeGenUtils$.MODULE$.ARRAY_DATA()).append(" ").append(valueArrayTerm).append(" = ").append(binaryMapTerm).append(".valueArray();\n             |\n             |  ").append(builderTerm).append(".setLength(0);\n             |  ").append(builderTerm).append(".append(\"{\");\n             |\n             |  int ").append(numTerm).append(" = ").append(binaryMapTerm).append(".size();\n             |  for (int ").append(indexTerm).append(" = 0; ").append(indexTerm).append(" < ").append(numTerm).append("; ").append(indexTerm).append("++) {\n             |    if (").append(indexTerm).append(" != 0) {\n             |      ").append(builderTerm).append(".append(\", \");\n             |    }\n             |\n             |    ").append(keyCastExpr.code()).append("\n             |    if (").append(keyCastExpr.nullTerm()).append(") {\n             |      ").append(builderTerm).append(".append(\"null\");\n             |    } else {\n             |      ").append(builderTerm).append(".append(").append(keyCastExpr.resultTerm()).append(");\n             |    }\n             |    ").append(builderTerm).append(".append(\"=\");\n             |\n             |    ").append(valueCastExpr.code()).append("\n             |    if (").append(valueCastExpr.nullTerm()).append(") {\n             |      ").append(builderTerm).append(".append(\"null\");\n             |    } else {\n             |      ").append(builderTerm).append(".append(").append(valueCastExpr.resultTerm()).append(");\n             |    }\n             |  }\n             |  ").append(builderTerm).append(".append(\"}\");\n             |\n             |  ").append(resultTerm).append(" = ").append(builderTerm).append(".toString();\n             |} else {\n             |  ").append(CodeGenUtils$.MODULE$.GENERIC_MAP()).append(" ").append(genericMapTerm).append(" = (").append(CodeGenUtils$.MODULE$.GENERIC_MAP()).append(") ").append(mapTerm).append(";\n             |  ").append(resultTerm).append(" = ").append(genericMapTerm).append(".toString();\n             |}\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)resultTerm);
        });
    }

    private GeneratedExpression generateCastRowDataToString(CodeGeneratorContext ctx, GeneratedExpression operand, RowType brt, LogicalType targetType) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), targetType, (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)terms -> {
            String builderCls = StringBuilder.class.getCanonicalName();
            String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
            ctx.addReusableMember(new StringBuilder(11).append(builderCls).append(" ").append(builderTerm).append(" = new ").append(builderCls).append("();").toString());
            String rowTerm = (String)terms.head();
            String appendCode = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(brt.getChildren()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                LogicalType elementType = (LogicalType)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
                String elementTerm = CodeGenUtils$.MODULE$.newName("element");
                GeneratedExpression elementExpr = new GeneratedExpression(elementTerm, new StringBuilder(11).append(rowTerm).append(".isNullAt(").append(idx).append(")").toString(), new StringBuilder(8).append(elementCls).append(" ").append(elementTerm).append(" = (").append(elementCls).append(") ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, idx, rowTerm, elementType)).append(";").toString(), elementType, GeneratedExpression$.MODULE$.apply$default$5());
                GeneratedExpression castExpr = MODULE$.generateCast(ctx, elementExpr, targetType);
                String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("\n               |").append((Object)(idx != 0 ? new StringBuilder(13).append(builderTerm).append(".append(\",\");").toString() : "")).append("\n               |").append(castExpr.code()).append("\n               |if (").append(castExpr.nullTerm()).append(") {\n               |  ").append(builderTerm).append(".append(\"null\");\n               |} else {\n               |  ").append(builderTerm).append(".append(").append(castExpr.resultTerm()).append(");\n               |}\n               ").toString())).stripMargin();
                return string;
            }, Buffer$.MODULE$.canBuildFrom())).mkString("\n");
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n             |").append(builderTerm).append(".setLength(0);\n             |").append(builderTerm).append(".append(\"(\");\n             |").append(appendCode).append("\n             |").append(builderTerm).append(".append(\")\");\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)new StringBuilder(11).append(builderTerm).append(".toString()").toString());
        });
    }

    private GeneratedExpression generateArrayComparison(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, (LogicalType)new BooleanType(), (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> {
            String leftTerm = (String)args.head();
            String rightTerm = (String)args.apply(1);
            String resultTerm = CodeGenUtils$.MODULE$.newName("compareResult");
            LogicalType elementType = ((ArrayType)left.resultType()).getElementType();
            String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
            String elementDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType);
            String leftElementTerm = CodeGenUtils$.MODULE$.newName("leftElement");
            String leftElementNullTerm = CodeGenUtils$.MODULE$.newName("leftElementIsNull");
            GeneratedExpression leftElementExpr = new GeneratedExpression(leftElementTerm, leftElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5());
            String rightElementTerm = CodeGenUtils$.MODULE$.newName("rightElement");
            String rightElementNullTerm = CodeGenUtils$.MODULE$.newName("rightElementIsNull");
            GeneratedExpression rightElementExpr = new GeneratedExpression(rightElementTerm, rightElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5());
            String indexTerm = CodeGenUtils$.MODULE$.newName("index");
            GeneratedExpression elementEqualsExpr = MODULE$.generateEquals(ctx, leftElementExpr, rightElementExpr);
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(875).append("\n             |boolean ").append(resultTerm).append(";\n             |if (").append(leftTerm).append(" instanceof ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" && ").append(rightTerm).append(" instanceof ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(") {\n             |  ").append(resultTerm).append(" = ").append(leftTerm).append(".equals(").append(rightTerm).append(");\n             |} else {\n             |  if (").append(leftTerm).append(".size() == ").append(rightTerm).append(".size()) {\n             |    ").append(resultTerm).append(" = true;\n             |    for (int ").append(indexTerm).append(" = 0; ").append(indexTerm).append(" < ").append(leftTerm).append(".size(); ").append(indexTerm).append("++) {\n             |      ").append(elementCls).append(" ").append(leftElementTerm).append(" = ").append(elementDefault).append(";\n             |      boolean ").append(leftElementNullTerm).append(" = ").append(leftTerm).append(".isNullAt(").append(indexTerm).append(");\n             |      if (!").append(leftElementNullTerm).append(") {\n             |        ").append(leftElementTerm).append(" =\n             |          ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, indexTerm, leftTerm, elementType)).append(";\n             |      }\n             |\n             |      ").append(elementCls).append(" ").append(rightElementTerm).append(" = ").append(elementDefault).append(";\n             |      boolean ").append(rightElementNullTerm).append(" = ").append(rightTerm).append(".isNullAt(").append(indexTerm).append(");\n             |      if (!").append(rightElementNullTerm).append(") {\n             |        ").append(rightElementTerm).append(" =\n             |          ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, indexTerm, rightTerm, elementType)).append(";\n             |      }\n             |\n             |      ").append(elementEqualsExpr.code()).append("\n             |      if (!").append(elementEqualsExpr.resultTerm()).append(") {\n             |        ").append(resultTerm).append(" = false;\n             |        break;\n             |      }\n             |    }\n             |  } else {\n             |    ").append(resultTerm).append(" = false;\n             |  }\n             |}\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)resultTerm);
        });
    }

    private GeneratedExpression generateMapComparison(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right, LogicalType keyType, LogicalType valueType) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, (LogicalType)new BooleanType(), (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> {
            String leftTerm = (String)args.head();
            String rightTerm = (String)args.apply(1);
            String resultTerm = CodeGenUtils$.MODULE$.newName("compareResult");
            String mapCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any())})));
            String keyCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(keyType);
            String valueCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(valueType);
            String leftMapTerm = CodeGenUtils$.MODULE$.newName("leftMap");
            String leftKeyTerm = CodeGenUtils$.MODULE$.newName("leftKey");
            String leftValueTerm = CodeGenUtils$.MODULE$.newName("leftValue");
            String leftValueNullTerm = CodeGenUtils$.MODULE$.newName("leftValueIsNull");
            GeneratedExpression leftValueExpr = new GeneratedExpression(leftValueTerm, leftValueNullTerm, "", valueType, GeneratedExpression$.MODULE$.apply$default$5());
            String rightMapTerm = CodeGenUtils$.MODULE$.newName("rightMap");
            String rightValueTerm = CodeGenUtils$.MODULE$.newName("rightValue");
            String rightValueNullTerm = CodeGenUtils$.MODULE$.newName("rightValueIsNull");
            GeneratedExpression rightValueExpr = new GeneratedExpression(rightValueTerm, rightValueNullTerm, "", valueType, GeneratedExpression$.MODULE$.apply$default$5());
            String entryTerm = CodeGenUtils$.MODULE$.newName("entry");
            String entryCls = Map.Entry.class.getCanonicalName();
            GeneratedExpression valueEqualsExpr = MODULE$.generateEquals(ctx, leftValueExpr, rightValueExpr);
            String internalTypeCls = LogicalType.class.getCanonicalName();
            String keyTypeTerm = ctx.addReusableObject(keyType, "keyType", internalTypeCls);
            String valueTypeTerm = ctx.addReusableObject(valueType, "valueType", internalTypeCls);
            String mapDataUtil = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(MapDataUtil.class));
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(862).append("\n             |boolean ").append(resultTerm).append(";\n             |if (").append(leftTerm).append(".size() == ").append(rightTerm).append(".size()) {\n             |  ").append(resultTerm).append(" = true;\n             |  ").append(mapCls).append(" ").append(leftMapTerm).append(" = ").append(mapDataUtil).append("\n             |      .convertToJavaMap(").append(leftTerm).append(", ").append(keyTypeTerm).append(", ").append(valueTypeTerm).append(");\n             |  ").append(mapCls).append(" ").append(rightMapTerm).append(" = ").append(mapDataUtil).append("\n             |      .convertToJavaMap(").append(rightTerm).append(", ").append(keyTypeTerm).append(", ").append(valueTypeTerm).append(");\n             |\n             |  for (").append(entryCls).append(" ").append(entryTerm).append(" : ").append(leftMapTerm).append(".entrySet()) {\n             |    ").append(keyCls).append(" ").append(leftKeyTerm).append(" = (").append(keyCls).append(") ").append(entryTerm).append(".getKey();\n             |    if (").append(rightMapTerm).append(".containsKey(").append(leftKeyTerm).append(")) {\n             |      ").append(valueCls).append(" ").append(leftValueTerm).append(" = (").append(valueCls).append(") ").append(entryTerm).append(".getValue();\n             |      ").append(valueCls).append(" ").append(rightValueTerm).append(" = (").append(valueCls).append(") ").append(rightMapTerm).append(".get(").append(leftKeyTerm).append(");\n             |      boolean ").append(leftValueNullTerm).append(" = (").append(leftValueTerm).append(" == null);\n             |      boolean ").append(rightValueNullTerm).append(" = (").append(rightValueTerm).append(" == null);\n             |\n             |      ").append(valueEqualsExpr.code()).append("\n             |      if (!").append(valueEqualsExpr.resultTerm()).append(") {\n             |        ").append(resultTerm).append(" = false;\n             |        break;\n             |      }\n             |    } else {\n             |      ").append(resultTerm).append(" = false;\n             |      break;\n             |    }\n             |  }\n             |} else {\n             |  ").append(resultTerm).append(" = false;\n             |}\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)resultTerm);
        });
    }

    private GeneratedExpression generateUnaryOperatorIfNotNull(CodeGeneratorContext ctx, LogicalType returnType, GeneratedExpression operand, boolean resultNullable, Function1<String, String> expr) {
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), resultNullable, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)args -> (String)expr.apply(args.head()));
    }

    private boolean generateUnaryOperatorIfNotNull$default$4() {
        return false;
    }

    private GeneratedExpression generateOperatorIfNotNull(CodeGeneratorContext ctx, LogicalType returnType, GeneratedExpression left, GeneratedExpression right, boolean resultNullable, Function2<String, String, String> expr) {
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), resultNullable, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)args -> (String)expr.apply(args.head(), args.apply(1)));
    }

    private boolean generateOperatorIfNotNull$default$5() {
        return false;
    }

    private GeneratedExpression internalExprCasting(GeneratedExpression expr, LogicalType targetType) {
        LogicalType x$47 = targetType;
        String x$48 = expr.copy$default$1();
        String x$49 = expr.copy$default$2();
        String x$50 = expr.copy$default$3();
        Option<Object> x$51 = expr.copy$default$5();
        return expr.copy(x$48, x$49, x$50, x$47, x$51);
    }

    private Function1<String, String> numericCasting(LogicalType operandType, LogicalType resultType) {
        Function1 & Serializable & scala.Serializable intersect;
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        if (PlannerTypeUtils.isInteroperable((LogicalType)operandType, (LogicalType)resultType)) {
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> String.valueOf(operandTerm);
        } else if (TypeCheckUtils.isDecimal((LogicalType)resultType) && TypeCheckUtils.isDecimal((LogicalType)operandType)) {
            DecimalType dt = (DecimalType)resultType;
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(20).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".castToDecimal(").append((String)operandTerm).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString();
        } else if (TypeCheckUtils.isDecimal((LogicalType)resultType) && TypeCheckUtils.isNumeric((LogicalType)operandType)) {
            DecimalType dt = (DecimalType)resultType;
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(15).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".castFrom(").append((String)operandTerm).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString();
        } else if (TypeCheckUtils.isNumeric((LogicalType)resultType) && TypeCheckUtils.isDecimal((LogicalType)operandType)) {
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(3).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".").append(ScalarOperatorGens$.decToPrimMethod$1(resultType)).append("(").append((String)operandTerm).append(")").toString();
        } else if (TypeCheckUtils.isNumeric((LogicalType)operandType) && TypeCheckUtils.isNumeric((LogicalType)resultType)) {
            String resultTypeValue = new StringBuilder(7).append(resultTypeTerm).append("Value()").toString();
            String boxedTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(operandType);
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(9).append("(new ").append(boxedTypeTerm).append("(").append((String)operandTerm).append(")).").append(resultTypeValue).toString();
        } else if (TypeCheckUtils.isTimeInterval((LogicalType)resultType) && TypeCheckUtils.isInteger((LogicalType)operandType)) {
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(5).append("((").append(resultTypeTerm).append(") ").append((String)operandTerm).append(")").toString();
        } else {
            throw new CodeGenException(new StringBuilder(30).append("Unsupported casting from ").append(operandType).append(" to ").append(resultType).append(".").toString());
        }
        return intersect;
    }

    private String stringToLocalTimeCode(LogicalType targetType, String operandTerm) {
        String string;
        LogicalTypeRoot logicalTypeRoot = targetType.getTypeRoot();
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            string = new StringBuilder(13).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_DATE())).append("(").append(operandTerm).append(".toString())").toString();
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            string = new StringBuilder(13).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIME())).append("(").append(operandTerm).append(".toString())").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(39).append("\n           |").append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP())).append("(").append(operandTerm).append(".toString())\n           |").toString())).stripMargin();
        } else {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    private String localTimeToStringCode(CodeGeneratorContext ctx, LogicalType fromType, String operandTerm) {
        String string;
        LogicalTypeRoot logicalTypeRoot = fromType.getTypeRoot();
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            string = new StringBuilder(2).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.UNIX_DATE_TO_STRING.method)).append("(").append(operandTerm).append(")").toString();
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            string = new StringBuilder(2).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.UNIX_TIME_TO_STRING())).append("(").append(operandTerm).append(")").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            int precision = ((TimestampType)fromType).getPrecision();
            string = new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_STRING())).append("(").append(operandTerm).append(", ").append(precision).append(")").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_STRING_TIME_ZONE());
            String zone = ctx.addReusableSessionTimeZone();
            int precision = ((LocalZonedTimestampType)fromType).getPrecision();
            string = new StringBuilder(6).append(method).append("(").append(operandTerm).append(", ").append(zone).append(", ").append(precision).append(")").toString();
        } else {
            throw new MatchError((Object)logicalTypeRoot);
        }
        return string;
    }

    private final Function1 castToDec$1(LogicalType t, DecimalType resultType$2) {
        LogicalType logicalType = t;
        Function1<String, String> function1 = logicalType instanceof DecimalType ? operandTerm -> String.valueOf(operandTerm) : this.numericCasting(t, (LogicalType)resultType$2);
        return function1;
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$1(String op$1, String l, String r) {
        return new StringBuilder(35).append(l).append(" ").append(op$1).append(" (java.lang.Math.toIntExact(").append(r).append(" / ").append(86400000L).append("L))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$2(String op$1, String l, String r) {
        return new StringBuilder(26).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis((").append(l).append(" * ").append(86400000L).append("L) ").append(op$1).append(" ").append(r).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$3(String op$1, String l, String r) {
        return new StringBuilder(6).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.ADD_MONTHS())).append("(").append(l).append(", ").append(op$1).append("(").append(r).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$4(String op$1, String l, String r) {
        return new StringBuilder(36).append("java.lang.Math.toIntExact(((").append(l).append(" + ").append(86400000L).append("L) ").append(op$1).append(" (").append(new StringBuilder(38).append("java.lang.Math.toIntExact(").append(r).append(" % ").append(86400000L).append("L))) % ").append(86400000L).append("L)").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$5(String l, String r) {
        return String.valueOf(l);
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$6(String op$1, String l, String r) {
        String leftTerm = new StringBuilder(17).append(l).append(".getMillisecond()").toString();
        String nanoTerm = new StringBuilder(23).append(l).append(".getNanoOfMillisecond()").toString();
        return new StringBuilder(22).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(leftTerm).append(" ").append(op$1).append(" ").append(r).append(", ").append(nanoTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$7(String op$1, String l, String r) {
        String leftTerm = new StringBuilder(17).append(l).append(".getMillisecond()").toString();
        String nanoTerm = new StringBuilder(23).append(l).append(".getNanoOfMillisecond()").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n               |").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(\n               |  ").append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.ADD_MONTHS())).append("(").append(leftTerm).append(", ").append(op$1).append("(").append(r).append(")),\n               |  ").append(nanoTerm).append(")\n             ").toString())).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$8(GeneratedExpression left$1, GeneratedExpression right$1, String ll, String rr) {
        Tuple2 tuple2 = new Tuple2((Object)left$1.resultType().getTypeRoot(), (Object)right$1.resultType().getTypeRoot());
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot2)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                return new StringBuilder(0).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append(new StringBuilder(8).append("(").append(leftTerm).append(", ").append(rr).append(" * ").append(86400000L).append("L)").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot3)) {
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(0).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append(new StringBuilder(8).append("(").append(ll).append(" * ").append(86400000L).append("L, ").append(rightTerm).append(")").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot4)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot5)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(leftTerm).append(", ").append(rr).append(")").toString();
            }
        }
        if (tuple2 == null) return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(ll).append(", ").append(rr).append(")").toString();
        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
        LogicalTypeRoot logicalTypeRoot6 = (LogicalTypeRoot)tuple2._2();
        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(ll).append(", ").append(rr).append(")").toString();
        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot6)) return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(ll).append(", ").append(rr).append(")").toString();
        String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
        return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.SUBTRACT_MONTHS())).append("(").append(ll).append(", ").append(rightTerm).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$9(GeneratedExpression left$1, GeneratedExpression right$1, String op$1, String ll, String rr) {
        Tuple2 tuple2 = new Tuple2((Object)left$1.resultType().getTypeRoot(), (Object)right$1.resultType().getTypeRoot());
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot2)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(2).append(leftTerm).append(" ").append(op$1).append(" ").append(rightTerm).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot3)) {
                return new StringBuilder(14).append("(").append(ll).append(" * ").append(86400000L).append("L) ").append(op$1).append(" (").append(rr).append(" * ").append(86400000L).append("L)").toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot4)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                return new StringBuilder(8).append(leftTerm).append(" ").append(op$1).append(" (").append(rr).append(" * ").append(86400000L).append("L)").toString();
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
        LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)tuple2._2();
        if (!LogicalTypeRoot.DATE.equals(logicalTypeRoot)) throw new MatchError((Object)tuple2);
        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot5)) throw new MatchError((Object)tuple2);
        String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
        return new StringBuilder(8).append("(").append(ll).append(" * ").append(86400000L).append("L) ").append(op$1).append(" ").append(rightTerm).toString();
    }

    public static final /* synthetic */ String $anonfun$generateReinterpret$1(String operandTerm) {
        return new StringBuilder(17).append(operandTerm).append(".getMillisecond()").toString();
    }

    public static final /* synthetic */ String $anonfun$generateReinterpret$2(String operandTerm) {
        return new StringBuilder(18).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$1(TimestampType toType$1, String method$1, String operandTerm) {
        return new StringBuilder(4).append(method$1).append("(").append(operandTerm).append(", ").append(toType$1.getPrecision()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$2(CodeGeneratorContext ctx$2, String method$2, String operandTerm) {
        String timeZone = ctx$2.addReusableSessionTimeZone();
        return new StringBuilder(4).append(method$2).append("(").append(operandTerm).append(", ").append(timeZone).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$3(CodeGeneratorContext ctx$2, LocalZonedTimestampType toType$2, String method$2, String truncate_method$1, String operandTerm) {
        String timeZone = ctx$2.addReusableSessionTimeZone();
        return new StringBuilder(8).append(truncate_method$1).append("(").append(method$2).append("(").append(operandTerm).append(", ").append(timeZone).append("), ").append(toType$2.getPrecision()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$4(CodeGeneratorContext ctx$2, String method$3, String operandTerm) {
        String zone = ctx$2.addReusableSessionTimeZone();
        return new StringBuilder(4).append(method$3).append("(").append(operandTerm).append(", ").append(zone).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$5(CodeGeneratorContext ctx$2, TimestampType toType$3, String method$3, String truncate_method$2, String operandTerm) {
        String zone = ctx$2.addReusableSessionTimeZone();
        return new StringBuilder(8).append(truncate_method$2).append("(").append(method$3).append("(").append(operandTerm).append(", ").append(zone).append("), ").append(toType$3.getPrecision()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$6(LocalZonedTimestampType toType$4, String method$4, String operandTerm) {
        return new StringBuilder(4).append(method$4).append("(").append(operandTerm).append(", ").append(toType$4.getPrecision()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$7(CodeGeneratorContext ctx$2, GeneratedExpression operand$2, Seq operandTerm) {
        return String.valueOf(MODULE$.localTimeToStringCode(ctx$2, operand$2.resultType(), (String)operandTerm.head()));
    }

    public static final /* synthetic */ String $anonfun$generateCast$8(String method$5, String timeUnitRange$1, Seq terms) {
        return new StringBuilder(4).append(method$5).append("(").append(terms.head()).append(", ").append(timeUnitRange$1).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$9(String method$6, String timeUnitRange$2, Seq terms) {
        return new StringBuilder(7).append(method$6).append("(").append(terms.head()).append(", ").append(timeUnitRange$2).append(", 3)").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$10(String charset$1, Seq terms) {
        return new StringBuilder(22).append("(new String(").append(terms.head()).append(", ").append(charset$1).append(".UTF_8))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$11(CodeGeneratorContext ctx$2, GeneratedExpression operand$2, Seq terms) {
        DataFormatConverters.DataFormatConverter converter = DataFormatConverters.getConverterForDataType((DataType)LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)operand$2.resultType()));
        String converterTerm = ctx$2.addReusableObject(converter, "converter", ctx$2.addReusableObject$default$3());
        return new StringBuilder(19).append(" \"\" + ").append(converterTerm).append(".toExternal(").append(terms.head()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$12(Seq terms) {
        return new StringBuilder(6).append(" \"\" + ").append(terms.head()).toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$13(String operandTerm) {
        return new StringBuilder(15).append(CodeGenUtils$.MODULE$.BINARY_STRING_UTIL()).append(".toBooleanSQL(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$14(DecimalType x2$1, String operandTerm) {
        return new StringBuilder(16).append(CodeGenUtils$.MODULE$.BINARY_STRING_UTIL()).append(".toDecimal(").append(operandTerm).append(", ").append(x2$1.getPrecision()).append(", ").append(x2$1.getScale()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$15() {
        return "Unexpected data type.";
    }

    public static final /* synthetic */ String $anonfun$generateCast$16(String methodName$1, String operandTerm) {
        return new StringBuilder(12).append("(").append(CodeGenUtils$.MODULE$.BINARY_STRING_UTIL()).append(".").append(methodName$1).append("(").append(operandTerm).append(".trim()))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$17(String operandTerm) {
        return new StringBuilder(13).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_DATE())).append("(").append(operandTerm).append(".toString())").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$18(String operandTerm) {
        return new StringBuilder(13).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIME())).append("(").append(operandTerm).append(".toString())").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$19(String operandTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(40).append("\n             |").append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP())).append("(").append(operandTerm).append(".toString())\n           ").toString())).stripMargin();
    }

    public static final /* synthetic */ String $anonfun$generateCast$20(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableSessionTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP_TIME_ZONE());
        return new StringBuilder(33).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(method).append("(").append(operandTerm).append(".toString(), ").append(zone).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$21(String operandTerm) {
        return new StringBuilder(10).append(operandTerm).append(".toBytes()").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$22(DecimalType dt$1, String operandTerm) {
        return new StringBuilder(15).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".castFrom(").append(operandTerm).append(", ").append(dt$1.getPrecision()).append(", ").append(dt$1.getScale()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$23(String targetTypeTerm$1, String operandTerm) {
        return new StringBuilder(13).append("(").append(targetTypeTerm$1).append(") (").append(operandTerm).append(" ? 1 : 0)").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$24(String operandTerm) {
        return new StringBuilder(16).append(CodeGenUtils$.MODULE$.DECIMAL_UTIL()).append(".castToBoolean(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$25(String operandTerm) {
        return new StringBuilder(5).append(operandTerm).append(" != 0").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$26(Function1 operandCasting$1, String operandTerm) {
        return String.valueOf(operandCasting$1.apply((Object)operandTerm));
    }

    public static final /* synthetic */ String $anonfun$generateCast$27(String operandTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |").append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(\n             |  ").append(operandTerm).append(" * ").append(DateTimeUtils.class.getCanonicalName()).append(".MILLIS_PER_DAY)\n           ").toString())).stripMargin();
    }

    public static final /* synthetic */ String $anonfun$generateCast$28(String targetTypeTerm$2, String operandTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(83).append("\n             |(").append(targetTypeTerm$2).append(") (").append(operandTerm).append(".getMillisecond() /\n             |  ").append(DateTimeUtils.class.getCanonicalName()).append(".MILLIS_PER_DAY)\n           ").toString())).stripMargin();
    }

    public static final /* synthetic */ String $anonfun$generateCast$29(String operandTerm) {
        return new StringBuilder(18).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$30(String targetTypeTerm$3, String operandTerm) {
        return new StringBuilder(24).append("(").append(targetTypeTerm$3).append(") (").append(operandTerm).append(".getMillisecond() % ").append(new StringBuilder(16).append(DateTimeUtils.class.getCanonicalName()).append(".MILLIS_PER_DAY)").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$31(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableSessionTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.DATE_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE());
        return new StringBuilder(22).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(method).append("(").append(operandTerm).append(", ").append(zone).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$32(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableSessionTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_DATE());
        return new StringBuilder(21).append(method).append("(").append(operandTerm).append(".getMillisecond(), ").append(zone).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$33(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableSessionTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIME_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE());
        return new StringBuilder(22).append(CodeGenUtils$.MODULE$.TIMESTAMP_DATA()).append(".fromEpochMillis(").append(method).append("(").append(operandTerm).append(", ").append(zone).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$34(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableSessionTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME());
        return new StringBuilder(21).append(method).append("(").append(operandTerm).append(".getMillisecond(), ").append(zone).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$generateRow$2(LogicalType x$1) {
        return PlannerTypeUtils.isPrimitive((LogicalType)x$1);
    }

    private static final String decToPrimMethod$1(LogicalType targetType) {
        String string;
        LogicalTypeRoot logicalTypeRoot = targetType.getTypeRoot();
        if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            string = "castToByte";
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            string = "castToShort";
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            string = "castToInt";
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            string = "castToLong";
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            string = "castToFloat";
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            string = "castToDouble";
        } else if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = "castToBoolean";
        } else {
            throw new CodeGenException(new StringBuilder(36).append("Unsupported decimal casting type: '").append(targetType).append("'").toString());
        }
        return string;
    }

    private ScalarOperatorGens$() {
        MODULE$ = this;
    }
}

