/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.catalog.FlinkSchema;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.CatalogTableStatisticsConverter;

class DatabaseCalciteSchema
extends FlinkSchema {
    private final String databaseName;
    private final String catalogName;
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;

    public DatabaseCalciteSchema(String databaseName, String catalogName, CatalogManager catalog, boolean isStreamingMode) {
        this.databaseName = databaseName;
        this.catalogName = catalogName;
        this.catalogManager = catalog;
        this.isStreamingMode = isStreamingMode;
    }

    @Override
    public Table getTable(String tableName) {
        ObjectIdentifier identifier = ObjectIdentifier.of((String)this.catalogName, (String)this.databaseName, (String)tableName);
        return this.catalogManager.getTable(identifier).map(result -> {
            ResolvedCatalogBaseTable resolvedBaseTable = result.getResolvedTable();
            FlinkStatistic statistic = this.getStatistic(result.isTemporary(), resolvedBaseTable, identifier);
            return new CatalogSchemaTable(identifier, (CatalogManager.TableLookupResult)result, statistic, (Catalog)this.catalogManager.getCatalog(this.catalogName).orElseThrow(IllegalStateException::new), this.isStreamingMode);
        }).orElse(null);
    }

    private FlinkStatistic getStatistic(boolean isTemporary, ResolvedCatalogBaseTable<?> resolvedCatalogBaseTable, ObjectIdentifier tableIdentifier) {
        if (isTemporary || resolvedCatalogBaseTable.getOrigin() instanceof QueryOperationCatalogView) {
            return FlinkStatistic.UNKNOWN();
        }
        if (resolvedCatalogBaseTable.getOrigin() instanceof CatalogTable) {
            Catalog catalog = (Catalog)this.catalogManager.getCatalog(this.catalogName).get();
            return FlinkStatistic.builder().tableStats(DatabaseCalciteSchema.extractTableStats(catalog, tableIdentifier)).uniqueKeys(DatabaseCalciteSchema.extractUniqueKeys(resolvedCatalogBaseTable.getResolvedSchema())).build();
        }
        return FlinkStatistic.UNKNOWN();
    }

    private static TableStats extractTableStats(Catalog catalog, ObjectIdentifier objectIdentifier) {
        ObjectPath tablePath = objectIdentifier.toObjectPath();
        try {
            CatalogTableStatistics tableStatistics = catalog.getTableStatistics(tablePath);
            CatalogColumnStatistics columnStatistics = catalog.getTableColumnStatistics(tablePath);
            return CatalogTableStatisticsConverter.convertToTableStats(tableStatistics, columnStatistics);
        }
        catch (TableNotExistException e) {
            throw new ValidationException(String.format("Could not get statistic for table: [%s, %s, %s]", objectIdentifier.getCatalogName(), tablePath.getDatabaseName(), tablePath.getObjectName()), (Throwable)e);
        }
    }

    private static Set<Set<String>> extractUniqueKeys(ResolvedSchema schema) {
        Optional primaryKeyConstraint = schema.getPrimaryKey();
        if (primaryKeyConstraint.isPresent()) {
            HashSet primaryKey = new HashSet(((UniqueConstraint)primaryKeyConstraint.get()).getColumns());
            HashSet<Set<String>> uniqueKeys = new HashSet<Set<String>>();
            uniqueKeys.add(primaryKey);
            return uniqueKeys;
        }
        return null;
    }

    @Override
    public Set<String> getTableNames() {
        return this.catalogManager.listTables(this.catalogName, this.databaseName);
    }

    @Override
    public Schema getSubSchema(String s) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

