/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.PartitionSpec;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.OverAggregateUtil$;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class OverAggregateUtil$ {
    public static final OverAggregateUtil$ MODULE$;

    static {
        new OverAggregateUtil$();
    }

    public OverSpec createOverSpec(Window logicalWindow) {
        ImmutableList<Window.Group> groups = logicalWindow.groups.asList();
        PartitionSpec partition2 = new PartitionSpec(((Window.Group)JavaConversions$.MODULE$.asScalaBuffer(groups).head()).keys.toArray());
        ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(groups).tail()).foreach((Function1)new Serializable(partition2){
            public static final long serialVersionUID = 0L;
            private final PartitionSpec partition$1;

            public final void apply(Window.Group g) {
                if (this.partition$1.equals(new PartitionSpec(g.keys.toArray()))) {
                    return;
                }
                throw new TableException("OverSpec requires all groups should have same partition key.");
            }
            {
                this.partition$1 = partition$1;
            }
        });
        return new OverSpec(partition2, JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(groups).map((Function1)new Serializable(logicalWindow){
            public static final long serialVersionUID = 0L;
            private final Window logicalWindow$1;

            public final OverSpec.GroupSpec apply(Window.Group x$1) {
                return OverAggregateUtil$.MODULE$.createGroupSpec(x$1, this.logicalWindow$1);
            }
            {
                this.logicalWindow$1 = logicalWindow$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())), logicalWindow.constants.asList(), this.calcOriginalInputFields(logicalWindow));
    }

    public OverSpec.GroupSpec createGroupSpec(Window.Group windowGroup, Window window) {
        return new OverSpec.GroupSpec(SortUtil$.MODULE$.getSortSpec((Seq<RelFieldCollation>)JavaConversions$.MODULE$.asScalaBuffer(windowGroup.orderKeys.getFieldCollations())), windowGroup.isRows, windowGroup.lowerBound, windowGroup.upperBound, windowGroup.getAggregateCalls(window));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Window.Group> splitOutOffsetOrInsensitiveGroup(Seq<Window.Group> windowGroups) {
        void var2_2;
        ArrayBuffer newWindowGroups = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        windowGroups.foreach((Function1)new Serializable(newWindowGroups){
            public static final long serialVersionUID = 0L;
            public final ArrayBuffer newWindowGroups$1;

            public final void apply(Window.Group group) {
                ObjectRef lastAggCall = ObjectRef.create(null);
                ArrayBuffer aggCallsBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                JavaConversions$.MODULE$.asScalaBuffer(group.aggCalls).foreach((Function1)new Serializable(this, lastAggCall, aggCallsBuffer, group){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.splitOutOffsetOrInsensitiveGroup.1 $outer;
                    private final ObjectRef lastAggCall$1;
                    private final ArrayBuffer aggCallsBuffer$1;
                    private final Window.Group group$1;

                    public final void apply(Window.RexWinAggCall aggCall) {
                        if ((Window.RexWinAggCall)this.lastAggCall$1.elem != null && !OverAggregateUtil$.MODULE$.org$apache$flink$table$planner$plan$utils$OverAggregateUtil$$compareAggCall$1((Window.RexWinAggCall)this.lastAggCall$1.elem, aggCall)) {
                            JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.$outer.newWindowGroups$1).add(OverAggregateUtil$.MODULE$.org$apache$flink$table$planner$plan$utils$OverAggregateUtil$$createNewGroup$1(this.group$1, (Seq)this.aggCallsBuffer$1));
                            this.aggCallsBuffer$1.clear();
                        }
                        JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.aggCallsBuffer$1).add(aggCall);
                        this.lastAggCall$1.elem = aggCall;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.lastAggCall$1 = lastAggCall$1;
                        this.aggCallsBuffer$1 = aggCallsBuffer$1;
                        this.group$1 = group$1;
                    }
                });
                if (aggCallsBuffer.nonEmpty()) {
                    JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.newWindowGroups$1).add(OverAggregateUtil$.MODULE$.org$apache$flink$table$planner$plan$utils$OverAggregateUtil$$createNewGroup$1(group, (Seq)aggCallsBuffer));
                    aggCallsBuffer.clear();
                }
            }
            {
                this.newWindowGroups$1 = newWindowGroups$1;
            }
        });
        return var2_2;
    }

    public int calcOriginalInputFields(Window logicWindow) {
        return logicWindow.getRowType().getFieldCount() - ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer(logicWindow.groups).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Buffer<Window.RexWinAggCall> apply(Window.Group x$2) {
                return JavaConversions$.MODULE$.asScalaBuffer(x$2.aggCalls);
            }
        }, Buffer$.MODULE$.canBuildFrom())).size();
    }

    public long getLongBoundary(OverSpec overSpec, RexWindowBound windowBound) {
        return Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)this.getBoundary(overSpec, windowBound)));
    }

    public Object getBoundary(Window logicWindow, RexWindowBound windowBound) {
        return this.getBoundary(windowBound, (Seq<RexLiteral>)JavaConversions$.MODULE$.asScalaBuffer(logicWindow.getConstants()), this.calcOriginalInputFields(logicWindow));
    }

    public Object getBoundary(OverSpec overSpec, RexWindowBound windowBound) {
        return this.getBoundary(windowBound, (Seq<RexLiteral>)JavaConversions$.MODULE$.asScalaBuffer(overSpec.getConstants()), overSpec.getOriginalInputFields());
    }

    private Object getBoundary(RexWindowBound windowBound, Seq<RexLiteral> constants2, int originalInputFields) {
        Number number;
        if (windowBound.isCurrentRow()) {
            number = BoxesRunTime.boxToLong((long)0L);
        } else {
            RexInputRef ref = (RexInputRef)windowBound.getOffset();
            int boundIndex = ref.getIndex() - originalInputFields;
            int flag = windowBound.isPreceding() ? -1 : 1;
            RexLiteral literal = (RexLiteral)JavaConversions$.MODULE$.seqAsJavaList(constants2).get(boundIndex);
            SqlTypeName sqlTypeName = literal.getType().getSqlTypeName();
            Number number2 = ((Object)((Object)SqlTypeName.DECIMAL)).equals((Object)sqlTypeName) ? ((BigDecimal)literal.getValue3()).multiply(new BigDecimal(flag)) : BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(literal.getValueAs(Long.class)) * (long)flag));
            number = number2;
        }
        return number;
    }

    public RelCollation createCollation(Window.Group windowGroup) {
        RelCollation relCollation;
        int[] groupSet = windowGroup.keys.toArray();
        List<RelFieldCollation> collations = windowGroup.orderKeys.getFieldCollations();
        int[] orderKeyIndexes = SortUtil$.MODULE$.getSortSpec((Seq<RelFieldCollation>)JavaConversions$.MODULE$.asScalaBuffer(collations)).getFieldIndices();
        if (Predef$.MODULE$.intArrayOps(groupSet).nonEmpty() || Predef$.MODULE$.intArrayOps(orderKeyIndexes).nonEmpty()) {
            Buffer collectionIndexes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(collations).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(RelFieldCollation x$3) {
                    return x$3.getFieldIndex();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            int[] intersectIds = (int[])Predef$.MODULE$.intArrayOps(orderKeyIndexes).intersect((GenSeq)Predef$.MODULE$.wrapIntArray(groupSet));
            Tuple3[] groupCollation = (Tuple3[])Predef$.MODULE$.intArrayOps(groupSet).map((Function1)new Serializable(collations, collectionIndexes, intersectIds){
                public static final long serialVersionUID = 0L;
                private final List collations$1;
                private final Buffer collectionIndexes$1;
                private final int[] intersectIds$1;

                public final Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> apply(int idx) {
                    Tuple3 tuple3;
                    if (Predef$.MODULE$.intArrayOps(this.intersectIds$1).contains((Object)BoxesRunTime.boxToInteger((int)idx))) {
                        int index = this.collectionIndexes$1.indexOf((Object)BoxesRunTime.boxToInteger((int)idx));
                        RelFieldCollation collation = (RelFieldCollation)this.collations$1.get(index);
                        tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)collation.getFieldIndex()), (Object)((Object)collation.getDirection()), (Object)((Object)collation.nullDirection));
                    } else {
                        tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)idx), (Object)((Object)RelFieldCollation.Direction.ASCENDING), (Object)((Object)RelFieldCollation.NullDirection.FIRST));
                    }
                    return tuple3;
                }
                {
                    this.collations$1 = collations$1;
                    this.collectionIndexes$1 = collectionIndexes$1;
                    this.intersectIds$1 = intersectIds$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            Buffer orderCollation = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(collations).filter((Function1)new Serializable(intersectIds){
                public static final long serialVersionUID = 0L;
                private final int[] intersectIds$1;

                public final boolean apply(RelFieldCollation c) {
                    return !Predef$.MODULE$.intArrayOps(this.intersectIds$1).contains((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()));
                }
                {
                    this.intersectIds$1 = intersectIds$1;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> apply(RelFieldCollation c) {
                    return new Tuple3((Object)BoxesRunTime.boxToInteger((int)c.getFieldIndex()), (Object)((Object)c.getDirection()), (Object)((Object)c.nullDirection));
                }
            }, Buffer$.MODULE$.canBuildFrom());
            ArrayList<RelFieldCollation> fields2 = new ArrayList<RelFieldCollation>();
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])groupCollation).$plus$plus((GenTraversableOnce)orderCollation, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).foreach((Function1)new Serializable(fields2){
                public static final long serialVersionUID = 0L;
                private final ArrayList fields$1;

                public final boolean apply(Tuple3<Object, RelFieldCollation.Direction, RelFieldCollation.NullDirection> field) {
                    return this.fields$1.add(FlinkRelOptUtil$.MODULE$.ofRelFieldCollation(BoxesRunTime.unboxToInt((Object)field._1()), (RelFieldCollation.Direction)((Object)field._2()), (RelFieldCollation.NullDirection)((Object)field._3())));
                }
                {
                    this.fields$1 = fields$1;
                }
            });
            relCollation = RelCollations.of(fields2);
        } else {
            relCollation = RelCollations.EMPTY;
        }
        return relCollation;
    }

    public boolean needCollationTrait(Window logicalWindow, Window.Group windowGroup) {
        boolean bl;
        if (!windowGroup.lowerBound.isPreceding() && !windowGroup.upperBound.isFollowing() && windowGroup.isRows) {
            long offsetLower = BoxesRunTime.unboxToLong((Object)this.getBoundary(windowGroup.lowerBound, (Seq<RexLiteral>)JavaConversions$.MODULE$.asScalaBuffer(logicalWindow.constants).toList(), this.calcOriginalInputFields(logicalWindow)));
            long offsetUpper = BoxesRunTime.unboxToLong((Object)this.getBoundary(windowGroup.upperBound, (Seq<RexLiteral>)JavaConversions$.MODULE$.asScalaBuffer(logicalWindow.constants).toList(), this.calcOriginalInputFields(logicalWindow)));
            bl = offsetLower != 0L || offsetUpper != 0L || !windowGroup.orderKeys.getFieldCollations().isEmpty();
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean org$apache$flink$table$planner$plan$utils$OverAggregateUtil$$compareAggCall$1(Window.RexWinAggCall c1, Window.RexWinAggCall c2) {
        boolean bl;
        boolean allowsFraming1 = c1.getOperator().allowsFraming();
        boolean allowsFraming2 = c2.getOperator().allowsFraming();
        if (allowsFraming1 || allowsFraming2) {
            bl = allowsFraming1 == allowsFraming2;
        } else {
            Class<?> clazz = c1.getOperator().getClass();
            Class<?> clazz2 = c2.getOperator().getClass();
            bl = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        }
        return bl;
    }

    public final Window.Group org$apache$flink$table$planner$plan$utils$OverAggregateUtil$$createNewGroup$1(Window.Group windowGroup, Seq newAggCalls) {
        return new Window.Group(windowGroup.keys, windowGroup.isRows, windowGroup.lowerBound, windowGroup.upperBound, windowGroup.orderKeys, JavaConversions$.MODULE$.seqAsJavaList(newAggCalls));
    }

    private OverAggregateUtil$() {
        MODULE$ = this;
    }
}

