/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;

public class DirectConvertRule
implements CallExpressionConvertRule {
    private static final Map<FunctionDefinition, SqlOperator> DEFINITION_OPERATOR_MAP = new HashMap<FunctionDefinition, SqlOperator>();

    @Override
    public Optional<RexNode> convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        SqlOperator operator = DEFINITION_OPERATOR_MAP.get(call.getFunctionDefinition());
        return Optional.ofNullable(operator).map(op -> context.getRelBuilder().call((SqlOperator)op, (Iterable<? extends RexNode>)ExpressionConverter.toRexNodes(context, call.getChildren())));
    }

    static {
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.AND, FlinkSqlOperatorTable.AND);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.OR, FlinkSqlOperatorTable.OR);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.NOT, FlinkSqlOperatorTable.NOT);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.IF, FlinkSqlOperatorTable.CASE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, FlinkSqlOperatorTable.EQUALS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, FlinkSqlOperatorTable.GREATER_THAN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, FlinkSqlOperatorTable.LESS_THAN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.NOT_EQUALS, FlinkSqlOperatorTable.NOT_EQUALS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_NULL, FlinkSqlOperatorTable.IS_NULL);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_NULL, FlinkSqlOperatorTable.IS_NOT_NULL);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_TRUE, FlinkSqlOperatorTable.IS_TRUE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_FALSE, FlinkSqlOperatorTable.IS_FALSE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_TRUE, FlinkSqlOperatorTable.IS_NOT_TRUE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_FALSE, FlinkSqlOperatorTable.IS_NOT_FALSE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CHAR_LENGTH, FlinkSqlOperatorTable.CHAR_LENGTH);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.INIT_CAP, FlinkSqlOperatorTable.INITCAP);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, FlinkSqlOperatorTable.LIKE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LOWER, FlinkSqlOperatorTable.LOWER);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LOWERCASE, FlinkSqlOperatorTable.LOWER);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SIMILAR, FlinkSqlOperatorTable.SIMILAR_TO);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SUBSTRING, FlinkSqlOperatorTable.SUBSTRING);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.UPPER, FlinkSqlOperatorTable.UPPER);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.UPPERCASE, FlinkSqlOperatorTable.UPPER);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.POSITION, FlinkSqlOperatorTable.POSITION);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.OVERLAY, FlinkSqlOperatorTable.OVERLAY);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CONCAT, FlinkSqlOperatorTable.CONCAT_FUNCTION);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CONCAT_WS, FlinkSqlOperatorTable.CONCAT_WS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LPAD, FlinkSqlOperatorTable.LPAD);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.RPAD, FlinkSqlOperatorTable.RPAD);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.REGEXP_EXTRACT, FlinkSqlOperatorTable.REGEXP_EXTRACT);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.FROM_BASE64, FlinkSqlOperatorTable.FROM_BASE64);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TO_BASE64, FlinkSqlOperatorTable.TO_BASE64);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.UUID, FlinkSqlOperatorTable.UUID);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LTRIM, FlinkSqlOperatorTable.LTRIM);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.RTRIM, FlinkSqlOperatorTable.RTRIM);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.REPEAT, FlinkSqlOperatorTable.REPEAT);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.REGEXP_REPLACE, FlinkSqlOperatorTable.REGEXP_REPLACE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.MINUS, FlinkSqlOperatorTable.MINUS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.DIVIDE, FlinkSqlOperatorTable.DIVIDE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TIMES, FlinkSqlOperatorTable.MULTIPLY);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.FLOOR, FlinkSqlOperatorTable.FLOOR);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CEIL, FlinkSqlOperatorTable.CEIL);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ABS, FlinkSqlOperatorTable.ABS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.EXP, FlinkSqlOperatorTable.EXP);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LOG10, FlinkSqlOperatorTable.LOG10);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LOG2, FlinkSqlOperatorTable.LOG2);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LN, FlinkSqlOperatorTable.LN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LOG, FlinkSqlOperatorTable.LOG);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.POWER, FlinkSqlOperatorTable.POWER);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.MOD, FlinkSqlOperatorTable.MOD);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.MINUS_PREFIX, FlinkSqlOperatorTable.UNARY_MINUS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SIN, FlinkSqlOperatorTable.SIN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.COS, FlinkSqlOperatorTable.COS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SINH, FlinkSqlOperatorTable.SINH);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TAN, FlinkSqlOperatorTable.TAN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TANH, FlinkSqlOperatorTable.TANH);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.COT, FlinkSqlOperatorTable.COT);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ASIN, FlinkSqlOperatorTable.ASIN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ACOS, FlinkSqlOperatorTable.ACOS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ATAN, FlinkSqlOperatorTable.ATAN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ATAN2, FlinkSqlOperatorTable.ATAN2);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.COSH, FlinkSqlOperatorTable.COSH);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.DEGREES, FlinkSqlOperatorTable.DEGREES);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.RADIANS, FlinkSqlOperatorTable.RADIANS);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SIGN, FlinkSqlOperatorTable.SIGN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ROUND, FlinkSqlOperatorTable.ROUND);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.PI, FlinkSqlOperatorTable.PI);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.E, FlinkSqlOperatorTable.E);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.RAND, FlinkSqlOperatorTable.RAND);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.RAND_INTEGER, FlinkSqlOperatorTable.RAND_INTEGER);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.BIN, FlinkSqlOperatorTable.BIN);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.HEX, FlinkSqlOperatorTable.HEX);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TRUNCATE, FlinkSqlOperatorTable.TRUNCATE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.EXTRACT, FlinkSqlOperatorTable.EXTRACT);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_DATE, FlinkSqlOperatorTable.CURRENT_DATE);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_TIME, FlinkSqlOperatorTable.CURRENT_TIME);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_TIMESTAMP, FlinkSqlOperatorTable.CURRENT_TIMESTAMP);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_ROW_TIMESTAMP, FlinkSqlOperatorTable.CURRENT_ROW_TIMESTAMP);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LOCAL_TIME, FlinkSqlOperatorTable.LOCALTIME);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.LOCAL_TIMESTAMP, FlinkSqlOperatorTable.LOCALTIMESTAMP);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.DATE_FORMAT, FlinkSqlOperatorTable.DATE_FORMAT);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP_LTZ, FlinkSqlOperatorTable.TO_TIMESTAMP_LTZ);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.AT, FlinkSqlOperatorTable.ITEM);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CARDINALITY, FlinkSqlOperatorTable.CARDINALITY);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ORDER_DESC, FlinkSqlOperatorTable.DESC);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ARRAY_ELEMENT, FlinkSqlOperatorTable.ELEMENT);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.MD5, FlinkSqlOperatorTable.MD5);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA2, FlinkSqlOperatorTable.SHA2);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA224, FlinkSqlOperatorTable.SHA224);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA256, FlinkSqlOperatorTable.SHA256);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA384, FlinkSqlOperatorTable.SHA384);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA512, FlinkSqlOperatorTable.SHA512);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA1, FlinkSqlOperatorTable.SHA1);
        DEFINITION_OPERATOR_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.STREAM_RECORD_TIMESTAMP, FlinkSqlOperatorTable.STREAMRECORD_TIMESTAMP);
    }
}

