/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@JsonTypeName(value="ProjectPushDown")
public class ProjectPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_PROJECTED_FIELDS = "projectedFields";
    @JsonProperty(value="projectedFields")
    private final int[][] projectedFields;

    @JsonCreator
    public ProjectPushDownSpec(@JsonProperty(value="projectedFields") int[][] projectedFields, @JsonProperty(value="producedType") RowType producedType) {
        super(producedType);
        this.projectedFields = (int[][])Preconditions.checkNotNull((Object)projectedFields);
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        if (!(tableSource instanceof SupportsProjectionPushDown)) {
            throw new TableException(String.format("%s does not support SupportsProjectionPushDown.", tableSource.getClass().getName()));
        }
        ((SupportsProjectionPushDown)tableSource).applyProjection(this.projectedFields);
    }
}

