/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.shared.ldap.extras.controls.SyncInfoValue;
import org.apache.directory.shared.ldap.extras.controls.SynchronizationInfoEnum;
import org.apache.directory.shared.ldap.model.message.controls.AbstractControl;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncInfoValueImpl
extends AbstractControl
implements SyncInfoValue {
    private SynchronizationInfoEnum type;
    private byte[] cookie;
    private boolean refreshDone = true;
    private boolean refreshDeletes = false;
    private List<byte[]> syncUUIDs;

    public SyncInfoValueImpl() {
        super("1.3.6.1.4.1.4203.1.9.1.4");
    }

    public SyncInfoValueImpl(boolean isCritical) {
        super("1.3.6.1.4.1.4203.1.9.1.4", isCritical);
    }

    @Override
    public SynchronizationInfoEnum getType() {
        return this.type;
    }

    @Override
    public void setType(SynchronizationInfoEnum type) {
        this.type = type;
    }

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    @Override
    public boolean isRefreshDone() {
        return this.refreshDone;
    }

    @Override
    public void setRefreshDone(boolean refreshDone) {
        this.refreshDone = refreshDone;
    }

    @Override
    public boolean isRefreshDeletes() {
        return this.refreshDeletes;
    }

    @Override
    public void setRefreshDeletes(boolean refreshDeletes) {
        this.refreshDeletes = refreshDeletes;
    }

    @Override
    public List<byte[]> getSyncUUIDs() {
        return this.syncUUIDs;
    }

    @Override
    public void setSyncUUIDs(List<byte[]> syncUUIDs) {
        this.syncUUIDs = syncUUIDs;
    }

    @Override
    public void addSyncUUID(byte[] syncUUID) {
        if (this.syncUUIDs == null) {
            this.syncUUIDs = new ArrayList<byte[]>();
        }
        this.syncUUIDs.add(syncUUID);
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + this.type.getValue();
        h = h * 17 + (this.refreshDone ? 1 : 0);
        h = h * 17 + (this.refreshDeletes ? 1 : 0);
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        if (this.syncUUIDs != null) {
            for (byte[] bytes : this.syncUUIDs) {
                if (bytes == null) continue;
                for (byte b : bytes) {
                    h = h * 17 + b;
                }
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyncInfoValue)) {
            return false;
        }
        SyncInfoValue otherControl = (SyncInfoValue)o;
        if (this.syncUUIDs != null) {
            if (otherControl.getSyncUUIDs() == null) {
                return false;
            }
            for (byte[] syncUuid : this.syncUUIDs) {
                boolean found = false;
                for (byte[] otherSyncUuid : otherControl.getSyncUUIDs()) {
                    if (!Arrays.equals(syncUuid, otherSyncUuid)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else if (otherControl.getSyncUUIDs() != null) {
            return false;
        }
        return this.refreshDeletes == otherControl.isRefreshDeletes() && this.refreshDone == otherControl.isRefreshDone() && this.type == otherControl.getType() && Arrays.equals(this.cookie, otherControl.getCookie()) && this.isCritical() == otherControl.isCritical();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncInfoValue control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        switch (this.getType()) {
            case NEW_COOKIE: {
                sb.append("        newCookie : '").append(Strings.dumpBytes((byte[])this.getCookie())).append("'\n");
                break;
            }
            case REFRESH_DELETE: {
                sb.append("        refreshDelete : \n");
                if (this.getCookie() != null) {
                    sb.append("            cookie : '").append(Strings.dumpBytes((byte[])this.getCookie())).append("'\n");
                }
                sb.append("            refreshDone : ").append(this.isRefreshDone()).append('\n');
                break;
            }
            case REFRESH_PRESENT: {
                sb.append("        refreshPresent : \n");
                if (this.getCookie() != null) {
                    sb.append("            cookie : '").append(Strings.dumpBytes((byte[])this.getCookie())).append("'\n");
                }
                sb.append("            refreshDone : ").append(this.isRefreshDone()).append('\n');
                break;
            }
            case SYNC_ID_SET: {
                sb.append("        syncIdSet : \n");
                if (this.getCookie() != null) {
                    sb.append("            cookie : '").append(Strings.dumpBytes((byte[])this.getCookie())).append("'\n");
                }
                sb.append("            refreshDeletes : ").append(this.isRefreshDeletes()).append('\n');
                sb.append("            syncUUIDS : ");
                if (this.getSyncUUIDs().size() != 0) {
                    boolean isFirst = true;
                    for (byte[] syncUUID : this.getSyncUUIDs()) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(Arrays.toString(syncUUID));
                    }
                    sb.append('\n');
                    break;
                }
                sb.append("empty\n");
            }
        }
        return sb.toString();
    }
}

