/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.MessageSentCallback;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.UseMessageIdAsCorrelationIdMessageSentCallback;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ValueHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

public class JmsProducer
extends DefaultAsyncProducer {
    private static final transient Log LOG = LogFactory.getLog(JmsProducer.class);
    private final JmsEndpoint endpoint;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private JmsOperations inOnlyTemplate;
    private JmsOperations inOutTemplate;
    private UuidGenerator uuidGenerator;
    private ReplyManager replyManager;

    public JmsProducer(JmsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initReplyManager() {
        if (!this.started.get()) {
            JmsProducer jmsProducer = this;
            synchronized (jmsProducer) {
                if (this.started.get()) {
                    return;
                }
                try {
                    if (this.endpoint.getReplyTo() != null) {
                        this.replyManager = this.endpoint.getReplyManager(this.endpoint.getReplyTo());
                        LOG.info((Object)("Using JmsReplyManager: " + this.replyManager + " to process replies from: " + this.endpoint.getReplyTo()));
                    } else {
                        this.replyManager = this.endpoint.getReplyManager();
                        LOG.info((Object)("Using JmsReplyManager: " + this.replyManager + " to process replies from temporary queue"));
                    }
                }
                catch (Exception e) {
                    throw new FailedToCreateProducerException((Endpoint)this.endpoint, (Throwable)e);
                }
                this.started.set(true);
            }
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        if (!this.endpoint.isDisableReplyTo() && exchange.getPattern().isOutCapable()) {
            return this.processInOut(exchange, callback);
        }
        return this.processInOnly(exchange, callback);
    }

    protected boolean processInOut(final Exchange exchange, final AsyncCallback callback) {
        final Message in = exchange.getIn();
        String destinationName = (String)in.getHeader("CamelJmsDestinationName", String.class);
        in.removeHeader("CamelJmsDestinationName");
        if (destinationName == null) {
            destinationName = this.endpoint.getDestinationName();
        }
        Destination destination = (Destination)in.getHeader("CamelJmsDestination", Destination.class);
        in.removeHeader("CamelJmsDestination");
        if (destination == null) {
            destination = this.endpoint.getDestination();
        }
        if (destination != null) {
            destinationName = null;
        }
        this.initReplyManager();
        boolean msgIdAsCorrId = this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID();
        final String provisionalCorrelationId = msgIdAsCorrId ? this.getUuidGenerator().generateUuid() : null;
        UseMessageIdAsCorrelationIdMessageSentCallback messageSentCallback = null;
        if (msgIdAsCorrId) {
            messageSentCallback = new UseMessageIdAsCorrelationIdMessageSentCallback(this.replyManager, provisionalCorrelationId, this.endpoint.getRequestTimeout());
        }
        ValueHolder sentCallback = new ValueHolder(messageSentCallback);
        final String originalCorrelationId = (String)in.getHeader("JMSCorrelationID", String.class);
        if (originalCorrelationId == null && !msgIdAsCorrId) {
            in.setHeader("JMSCorrelationID", (Object)this.getUuidGenerator().generateUuid());
        }
        MessageCreator messageCreator = new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message message = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                Destination replyTo = JmsProducer.this.replyManager.getReplyTo();
                if (replyTo == null) {
                    throw new RuntimeExchangeException("Failed to resolve replyTo destination", exchange);
                }
                message.setJMSReplyTo(replyTo);
                JmsProducer.this.replyManager.setReplyToSelectorHeader(in, message);
                String correlationId = JmsProducer.this.determineCorrelationId(message, provisionalCorrelationId);
                JmsProducer.this.replyManager.registerReply(JmsProducer.this.replyManager, exchange, callback, originalCorrelationId, correlationId, JmsProducer.this.endpoint.getRequestTimeout());
                return message;
            }
        };
        this.doSend(true, destinationName, destination, messageCreator, (MessageSentCallback)sentCallback.get());
        this.setMessageId(exchange);
        return false;
    }

    protected String determineCorrelationId(javax.jms.Message message, String provisionalCorrelationId) throws JMSException {
        if (provisionalCorrelationId != null) {
            return provisionalCorrelationId;
        }
        String messageId = message.getJMSMessageID();
        String correlationId = message.getJMSCorrelationID();
        if (this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID()) {
            return messageId;
        }
        if (ObjectHelper.isEmpty((Object)correlationId)) {
            return messageId;
        }
        return correlationId;
    }

    protected boolean processInOnly(final Exchange exchange, AsyncCallback callback) {
        Destination destination;
        final Message in = exchange.getIn();
        String destinationName = (String)in.getHeader("CamelJmsDestinationName", String.class);
        if (destinationName != null) {
            in.removeHeader("CamelJmsDestinationName");
        }
        if (destinationName == null) {
            destinationName = this.endpoint.getDestinationName();
        }
        if ((destination = (Destination)in.getHeader("CamelJmsDestination", Destination.class)) != null) {
            in.removeHeader("CamelJmsDestination");
        }
        if (destination == null) {
            destination = this.endpoint.getDestination();
        }
        if (destination != null) {
            destinationName = null;
        }
        final String to = destinationName != null ? destinationName : "" + destination;
        MessageCreator messageCreator = new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                String replyTo;
                javax.jms.Message answer = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                Object jmsReplyTo = answer.getJMSReplyTo();
                if (JmsProducer.this.endpoint.isDisableReplyTo()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ReplyTo is disabled on endpoint: " + (Object)((Object)JmsProducer.this.endpoint)));
                    }
                    answer.setJMSReplyTo(null);
                } else if (jmsReplyTo == null && (jmsReplyTo = exchange.getIn().getHeader("JMSReplyTo", String.class)) == null) {
                    jmsReplyTo = JmsProducer.this.endpoint.getReplyTo();
                }
                if (jmsReplyTo != null && !JmsProducer.this.endpoint.isPreserveMessageQos() && !JmsProducer.this.endpoint.isExplicitQosEnabled()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Disabling JMSReplyTo: " + jmsReplyTo + " for destination: " + to + ". Use preserveMessageQos=true to force Camel to keep the JMSReplyTo on endpoint: " + (Object)((Object)JmsProducer.this.endpoint)));
                    }
                    jmsReplyTo = null;
                }
                if (jmsReplyTo != null && jmsReplyTo instanceof String) {
                    replyTo = JmsMessageHelper.normalizeDestinationName((String)jmsReplyTo);
                    jmsReplyTo = null;
                    if (JmsProducer.this.endpoint.getDestinationResolver() != null) {
                        jmsReplyTo = JmsProducer.this.endpoint.getDestinationResolver().resolveDestinationName(session, replyTo, JmsProducer.this.endpoint.isPubSubDomain());
                    }
                    if (jmsReplyTo == null) {
                        if (JmsProducer.this.endpoint.isPubSubDomain()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Creating JMSReplyTo topic: " + replyTo));
                            }
                            jmsReplyTo = session.createTopic(replyTo);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Creating JMSReplyTo queue: " + replyTo));
                            }
                            jmsReplyTo = session.createQueue(replyTo);
                        }
                    }
                }
                replyTo = null;
                if (jmsReplyTo instanceof Destination) {
                    replyTo = jmsReplyTo;
                }
                if (replyTo != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Using JMSReplyTo destination: " + replyTo));
                    }
                    answer.setJMSReplyTo((Destination)replyTo);
                } else {
                    answer.setJMSReplyTo(null);
                }
                return answer;
            }
        };
        this.doSend(false, destinationName, destination, messageCreator, null);
        this.setMessageId(exchange);
        callback.done(true);
        return true;
    }

    protected void doSend(boolean inOut, String destinationName, Destination destination, MessageCreator messageCreator, MessageSentCallback callback) {
        JmsConfiguration.CamelJmsTemplate template = (JmsConfiguration.CamelJmsTemplate)(inOut ? this.getInOutTemplate() : this.getInOnlyTemplate());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using " + (inOut ? "inOut" : "inOnly") + " jms template"));
        }
        if (destination != null) {
            if (inOut) {
                if (template != null) {
                    template.send(destination, messageCreator, callback);
                }
            } else if (template != null) {
                template.send(destination, messageCreator);
            }
        } else if (destinationName != null) {
            if (inOut) {
                if (template != null) {
                    template.send(destinationName, messageCreator, callback);
                }
            } else if (template != null) {
                template.send(destinationName, messageCreator);
            }
        } else {
            throw new IllegalArgumentException("Neither destination nor destinationName is specified on this endpoint: " + (Object)((Object)this.endpoint));
        }
    }

    protected void setMessageId(Exchange exchange) {
        if (exchange.hasOut()) {
            JmsMessage out = (JmsMessage)exchange.getOut();
            try {
                if (out != null && out.getJmsMessage() != null) {
                    out.setMessageId(out.getJmsMessage().getJMSMessageID());
                }
            }
            catch (JMSException e) {
                LOG.warn((Object)"Unable to retrieve JMSMessageID from outgoing JMS Message and set it into Camel's MessageId", (Throwable)e);
            }
        }
    }

    public JmsOperations getInOnlyTemplate() {
        if (this.inOnlyTemplate == null) {
            this.inOnlyTemplate = this.endpoint.createInOnlyTemplate();
        }
        return this.inOnlyTemplate;
    }

    public void setInOnlyTemplate(JmsOperations inOnlyTemplate) {
        this.inOnlyTemplate = inOnlyTemplate;
    }

    public JmsOperations getInOutTemplate() {
        if (this.inOutTemplate == null) {
            this.inOutTemplate = this.endpoint.createInOutTemplate();
        }
        return this.inOutTemplate;
    }

    public void setInOutTemplate(JmsOperations inOutTemplate) {
        this.inOutTemplate = inOutTemplate;
    }

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.uuidGenerator == null) {
            this.uuidGenerator = this.getEndpoint().getCamelContext().getUuidGenerator();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

