/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.Comparator;
import net.java.truecommons.shed.ExceptionBuilderTestSuite;
import net.java.truecommons.shed.PriorityExceptionBuilder;
import net.java.truecommons.shed.TestException;
import net.java.truecommons.shed.WarningException;
import org.junit.Assert;
import org.junit.Test;

public class PriorityExceptionBuilderTest
extends ExceptionBuilderTestSuite<PriorityExceptionBuilder<TestException>, TestException, TestException> {
    public PriorityExceptionBuilderTest() {
        super(TestException.class);
    }

    @Override
    protected PriorityExceptionBuilder<TestException> newBuilder() {
        return new PriorityExceptionBuilder((Comparator)TestComparator.INSTANCE);
    }

    @Override
    protected TestException newInput() {
        return new TestException(0, new TestException[0]);
    }

    @Test
    public void testFailIdempotence() {
        TestException ex = (TestException)((PriorityExceptionBuilder)this.builder).fail((Throwable)this.newInput());
        Assert.assertSame((Object)ex, (Object)((PriorityExceptionBuilder)this.builder).fail((Throwable)ex));
    }

    @Test
    public void testWarnIdempotence() {
        ((PriorityExceptionBuilder)this.builder).warn((Throwable)this.newInput());
        try {
            ((PriorityExceptionBuilder)this.builder).check();
            Assert.fail();
        }
        catch (TestException ex) {
            Assert.assertTrue((boolean)this.clazz.isInstance(ex));
            ((PriorityExceptionBuilder)this.builder).warn((Throwable)ex);
            try {
                ((PriorityExceptionBuilder)this.builder).check();
                Assert.fail();
            }
            catch (TestException ex2) {
                Assert.assertSame((Object)ex, (Object)ex2);
            }
        }
    }

    @Test
    public void testPriority() throws TestException {
        for (TestException[] params : new TestException[][]{{new TestException(0, new WarningException(1, new TestException[0])), new WarningException(1, new TestException[0]), new TestException(0, new TestException[0])}, {new TestException(0, new WarningException(1, new TestException[0])), new TestException(0, new TestException[0]), new WarningException(1, new TestException[0])}, {new TestException(0, new WarningException(1, new TestException[0]), new WarningException(2, new TestException[0])), new WarningException(1, new TestException[0]), new WarningException(2, new TestException[0]), new TestException(0, new TestException[0])}, {new TestException(0, new WarningException(1, new TestException[0]), new WarningException(2, new TestException[0])), new WarningException(1, new TestException[0]), new TestException(0, new TestException[0]), new WarningException(2, new TestException[0])}, {new TestException(0, new WarningException(1, new TestException[0]), new WarningException(2, new TestException[0])), new TestException(0, new TestException[0]), new WarningException(1, new TestException[0]), new WarningException(2, new TestException[0])}, {new TestException(0, new WarningException(1, new TestException[0]), new TestException(2, new TestException[0])), new WarningException(1, new TestException[0]), new TestException(0, new TestException[0]), new TestException(2, new TestException[0])}, {new TestException(0, new WarningException(1, new TestException[0]), new TestException(2, new TestException[0])), new TestException(0, new TestException[0]), new WarningException(1, new TestException[0]), new TestException(2, new TestException[0])}, {new TestException(0, new TestException(1, new TestException[0]), new WarningException(2, new TestException[0])), new TestException(0, new TestException[0]), new TestException(1, new TestException[0]), new WarningException(2, new TestException[0])}}) {
            TestException expected = params[0];
            int i = 1;
            while (i < params.length - 1) {
                ((PriorityExceptionBuilder)this.builder).warn((Throwable)params[i++]);
            }
            TestException assembly = (TestException)((PriorityExceptionBuilder)this.builder).fail((Throwable)params[i]);
            ((PriorityExceptionBuilder)this.builder).check();
            Assert.assertEquals((Object)expected, (Object)assembly);
        }
    }

    private static final class TestComparator
    implements Comparator<TestException> {
        static final TestComparator INSTANCE = new TestComparator();

        private TestComparator() {
        }

        @Override
        public int compare(TestException o1, TestException o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

