/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.CheckForNull;
import net.java.truecommons.shed.Option;
import org.junit.Assert;
import org.junit.Test;

public class OptionTest {
    @CheckForNull
    private final String string = 0 == ThreadLocalRandom.current().nextInt(1) ? "Hello world!" : null;
    private final Option<String> option = Option.apply((Object)this.string);

    @Test
    public void testMostIdiomaticUseCase() {
        for (String s : this.option) {
            Assert.assertSame((Object)this.string, (Object)s);
        }
    }

    @Test
    public void testLessIdiomaticUseCase() {
        if (!this.option.isEmpty()) {
            Assert.assertSame((Object)this.string, (Object)this.option.get());
        }
    }

    @Test
    public void testComposition() {
        class Container {
            Container() {
            }

            Option<String> getMessage() {
                return Option.some((Object)"Hello world!");
            }
        }
        Option option = Option.some((Object)new Container());
        for (Container c : option) {
            for (String s : c.getMessage()) {
                System.out.println(s);
            }
        }
    }
}

