/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import net.java.truecommons.shed.Buffers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class BuffersTest {
    private static final String[] tests = new String[]{"", "f\u00f6o", "b\u00e4r"};

    @Test
    public void testStringRoundTrip() {
        String[] arr$ = tests;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s;
            String ist = s = arr$[i$];
            ByteBuffer ibb = Buffers.byteBuffer((String)ist);
            ByteBuffer obb = ibb.duplicate();
            String ost = Buffers.string((ByteBuffer)obb);
            Assert.assertThat((Object)ost, (Matcher)CoreMatchers.is((Object)ist));
            Assert.assertThat((Object)obb, (Matcher)CoreMatchers.is((Object)ibb));
        }
    }

    @Test
    public void testCharArrayRoundTrip() {
        for (String s : tests) {
            char[] ica = s.toCharArray();
            ByteBuffer ibb = Buffers.byteBuffer((char[])ica);
            ByteBuffer obb = ibb.duplicate();
            char[] oca = Buffers.charArray((ByteBuffer)obb);
            Assert.assertThat((Object)oca, (Matcher)CoreMatchers.is((Object)ica));
            Assert.assertThat((Object)obb, (Matcher)CoreMatchers.is((Object)ibb));
        }
    }

    @Test
    public void testCharBufferRoundTrip() {
        for (String s : tests) {
            CharBuffer icb = CharBuffer.wrap(s);
            ByteBuffer ibb = Buffers.byteBuffer((CharBuffer)icb);
            ByteBuffer obb = ibb.duplicate();
            CharBuffer ocb = Buffers.charBuffer((ByteBuffer)obb);
            Assert.assertThat((Object)ocb, (Matcher)CoreMatchers.is((Object)icb));
            Assert.assertThat((Object)obb, (Matcher)CoreMatchers.is((Object)ibb));
        }
    }

    @Test
    public void testNullConversions() {
        Assert.assertNull((Object)Buffers.byteBuffer((String)null));
        Assert.assertNull((Object)Buffers.byteBuffer((char[])null));
        Assert.assertNull((Object)Buffers.byteBuffer((CharBuffer)null));
        Assert.assertNull((Object)Buffers.string((ByteBuffer)null));
        Assert.assertNull((Object)Buffers.charArray((ByteBuffer)null));
        Assert.assertNull((Object)Buffers.charBuffer((ByteBuffer)null));
    }
}

