/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.java.truecommons.shed.BitField;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitFieldTest {
    private static final Logger logger = LoggerFactory.getLogger(BitFieldTest.class);

    @Test
    public void testSetOne() {
        BitField bits = BitField.noneOf(Dummy.class).set((Enum)Dummy.ONE);
        Assert.assertFalse((boolean)bits.isEmpty());
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)bits.get((Enum)Dummy.ONE));
        Assert.assertTrue((boolean)bits.is((Enum)Dummy.ONE));
        Assert.assertThat((Object)BitField.copyOf((Collection)bits.toEnumSet()), (Matcher)CoreMatchers.equalTo((Object)bits));
    }

    @Test
    public void testClearOne() {
        BitField bits = BitField.of((Enum)Dummy.ONE).clear((Enum)Dummy.ONE);
        Assert.assertTrue((boolean)bits.isEmpty());
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertFalse((boolean)bits.get((Enum)Dummy.ONE));
        Assert.assertFalse((boolean)bits.is((Enum)Dummy.ONE));
        Assert.assertThat((Object)BitField.copyOf((Collection)bits.toEnumSet()), (Matcher)CoreMatchers.equalTo((Object)bits));
    }

    @Test
    public void testSetTwo() {
        BitField bits = BitField.of((Enum)Dummy.ONE, (Enum[])new Dummy[]{Dummy.TWO});
        Assert.assertFalse((boolean)bits.isEmpty());
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)bits.get((Enum)Dummy.ONE));
        Assert.assertTrue((boolean)bits.is((Enum)Dummy.ONE));
        Assert.assertTrue((boolean)bits.get((Enum)Dummy.TWO));
        Assert.assertTrue((boolean)bits.is((Enum)Dummy.TWO));
        Assert.assertThat((Object)BitField.copyOf((Collection)bits.toEnumSet()), (Matcher)CoreMatchers.equalTo((Object)bits));
    }

    @Test
    public void testClearTwo() {
        BitField bits = BitField.of((Enum)Dummy.ONE, (Enum[])new Dummy[]{Dummy.TWO}).clear((Enum)Dummy.ONE).clear((Enum)Dummy.TWO);
        Assert.assertTrue((boolean)bits.isEmpty());
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertFalse((boolean)bits.get((Enum)Dummy.ONE));
        Assert.assertFalse((boolean)bits.is((Enum)Dummy.ONE));
        Assert.assertFalse((boolean)bits.get((Enum)Dummy.TWO));
        Assert.assertFalse((boolean)bits.is((Enum)Dummy.TWO));
        Assert.assertThat((Object)BitField.copyOf((Collection)bits.toEnumSet()), (Matcher)CoreMatchers.equalTo((Object)bits));
    }

    @Test
    public void testAllOf() {
        BitField bits = BitField.allOf(Dummy.class);
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testNot() {
        BitField bits = BitField.allOf(Dummy.class);
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)3));
        bits = bits.not();
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAnd() {
        BitField bits = BitField.allOf(Dummy.class);
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)bits.and(BitField.allOf(Dummy.class)), (Matcher)CoreMatchers.sameInstance((Object)bits));
        bits = bits.and(BitField.noneOf(Dummy.class));
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testOr() {
        BitField bits = BitField.noneOf(Dummy.class);
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)bits.and(BitField.noneOf(Dummy.class)), (Matcher)CoreMatchers.sameInstance((Object)bits));
        bits = bits.or(BitField.allOf(Dummy.class));
        Assert.assertThat((Object)bits.cardinality(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testIterator() {
        BitField bits = BitField.allOf(Dummy.class);
        Iterator it = bits.iterator();
        Dummy[] dummies = Dummy.values();
        for (int i = 0; i < dummies.length; ++i) {
            assert (it.hasNext());
            Assert.assertThat(it.next(), (Matcher)CoreMatchers.sameInstance((Object)((Object)dummies[i])));
            try {
                it.remove();
                Assert.fail();
                continue;
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (Dummy[] params : new Dummy[][]{{Dummy.ONE}, {Dummy.ONE, Dummy.TWO}, {Dummy.ONE, Dummy.TWO, Dummy.THREE}}) {
            Object clone;
            BitField original = BitField.copyOf(Arrays.asList(params));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(original);
            }
            logger.trace("Number of serialized bytes: {}", (Object)bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                clone = ois.readObject();
            }
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            clone = null;
            try {
                enc.setExceptionListener(listener);
                enc.writeObject(original);
            }
            catch (Throwable x2) {
                clone = x2;
                throw x2;
            }
            finally {
                if (enc != null) {
                    if (clone != null) {
                        try {
                            enc.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)clone).addSuppressed(x2);
                        }
                    } else {
                        enc.close();
                    }
                }
            }
            logger.trace("XML Output:\n{}", (Object)bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            var11_15 = null;
            try (XMLDecoder dec = new XMLDecoder(bis);){
                clone = dec.readObject();
            }
            catch (Throwable throwable) {
                var11_15 = throwable;
                throw throwable;
            }
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
        }
    }

    static enum Dummy {
        ONE,
        TWO,
        THREE;

    }
}

