/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.services;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.services.UnifiedClassLoader;

@Immutable
public final class Loader {
    private final ClassLoader primary;

    public Loader(@CheckForNull ClassLoader loader) {
        this.primary = null != loader ? loader : ClassLoader.getSystemClassLoader();
    }

    public Iterable<URL> resourcesFor(final String name) throws ServiceConfigurationError {
        final class IterableResources
        implements Iterable<URL> {
            IterableResources() {
            }

            @Override
            public Iterator<URL> iterator() {
                try {
                    return new EnumerationIterator<URL>(Loader.this.classLoader().getResources(name));
                }
                catch (IOException ex) {
                    throw new ServiceConfigurationError(ex.toString(), ex);
                }
            }
        }
        return new IterableResources();
    }

    public <S> Iterable<S> instancesOf(final Class<S> spec) {
        final class IterableServices
        implements Iterable<S> {
            IterableServices() {
            }

            @Override
            public Iterator<S> iterator() {
                return ServiceLoader.load(spec, Loader.this.classLoader()).iterator();
            }
        }
        return new IterableServices();
    }

    private ClassLoader classLoader() {
        return UnifiedClassLoader.resolve(this.primary, Thread.currentThread().getContextClassLoader());
    }

    @Nullable
    public <S> S instanceOf(Class<S> spec, @CheckForNull Class<? extends S> impl) throws ServiceConfigurationError {
        String name = System.getProperty(spec.getName(), null == impl ? null : impl.getName());
        if (null == name) {
            return null;
        }
        try {
            return impl.cast(this.classFor(name).newInstance());
        }
        catch (InstantiationException ex) {
            throw new ServiceConfigurationError(ex.toString(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServiceConfigurationError(ex.toString(), ex);
        }
    }

    public Class<?> classFor(String name) throws ServiceConfigurationError {
        try {
            return this.primary.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            try {
                ClassLoader secondary = Thread.currentThread().getContextClassLoader();
                if (this.primary == secondary) {
                    throw ex;
                }
                return secondary.loadClass(name);
            }
            catch (ClassNotFoundException ex2) {
                throw new ServiceConfigurationError(ex2.toString(), ex2);
            }
        }
    }

    @CheckForNull
    public static <T> T promote(@CheckForNull Object object, Class<T> type) throws IllegalArgumentException {
        try {
            if (object instanceof String && !type.equals(String.class)) {
                object = new Loader(type.getClassLoader()).classFor((String)((Object)object));
            }
            if (object instanceof Class && !type.equals(Class.class)) {
                object = ((Class)object).newInstance();
            }
            return type.cast(object);
        }
        catch (ServiceConfigurationError ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static final class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<E> e;

        EnumerationIterator(Enumeration<E> e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public E next() {
            return this.e.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

