/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx.keychain;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.java.truecommons.key.macosx.keychain.Keychain;
import net.java.truecommons.key.macosx.keychain.Security;

final class KeychainUtils {
    private KeychainUtils() {
    }

    @Nullable
    static Security.SecKeychainAttributeList list(@CheckForNull Map<Keychain.AttributeClass, ByteBuffer> map) {
        if (null == map) {
            return null;
        }
        Security.SecKeychainAttributeList list = new Security.SecKeychainAttributeList();
        int size = map.size();
        if (0 >= size) {
            return list;
        }
        Security.SecKeychainAttribute[] array = (Security.SecKeychainAttribute[])new Security.SecKeychainAttribute().toArray(size);
        int count = 0;
        for (Map.Entry<Keychain.AttributeClass, ByteBuffer> entry : map.entrySet()) {
            Keychain.AttributeClass id = entry.getKey();
            if (null == id) continue;
            Security.SecKeychainAttribute attr = array[count++];
            attr.tag = id.getTag();
            ByteBuffer buffer = entry.getValue();
            if (null != buffer) {
                int length = buffer.remaining();
                Pointer data = KeychainUtils.malloc(length);
                buffer.mark();
                data.getByteBuffer(0L, (long)length).put(buffer);
                buffer.reset();
                attr.length = length;
                attr.data = data;
            }
            attr.write();
        }
        list.count = count;
        if (0 < count) {
            list.attr = array[0].getPointer();
        }
        return list;
    }

    private static Pointer malloc(int size) {
        if (0 < size) {
            return new Memory((long)size);
        }
        if (0 == size) {
            return (Memory)new Memory(4L).share(0L, 0L);
        }
        throw new IllegalArgumentException("" + size);
    }

    @Nullable
    static Map<Keychain.AttributeClass, ByteBuffer> map(@CheckForNull Security.SecKeychainAttributeList list) {
        Security.SecKeychainAttribute[] array;
        if (null == list) {
            return null;
        }
        EnumMap<Keychain.AttributeClass, ByteBuffer> map = new EnumMap<Keychain.AttributeClass, ByteBuffer>(Keychain.AttributeClass.class);
        int count = list.count;
        if (0 >= count) {
            return map;
        }
        Security.SecKeychainAttribute attr = new Security.SecKeychainAttribute(list.attr);
        attr.read();
        for (Security.SecKeychainAttribute attr2 : array = (Security.SecKeychainAttribute[])attr.toArray(count)) {
            Pointer data;
            Keychain.AttributeClass id = Keychain.AttributeClass.lookup(attr2.tag);
            if (null == id || null == (data = attr2.data)) continue;
            int length = attr2.length;
            ByteBuffer buffer = (ByteBuffer)ByteBuffer.allocateDirect(length).put(data.getByteBuffer(0L, (long)length)).flip();
            map.put(id, buffer);
        }
        return map;
    }

    static Security.SecKeychainAttributeInfo info(Keychain.AttributeClass ... ids) {
        int length;
        Security.SecKeychainAttributeInfo info = new Security.SecKeychainAttributeInfo();
        info.count = length = ids.length;
        int size = length << 2;
        Memory tag = new Memory((long)(size << 1));
        Pointer format = tag.share((long)size, (long)size);
        info.tag = tag;
        info.format = format;
        int offset = 0;
        for (Keychain.AttributeClass id : ids) {
            tag.setInt((long)offset, id.getTag());
            format.setInt((long)offset, 0);
            offset += 4;
        }
        return info;
    }
}

