/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx.keychain;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.macosx.keychain.CoreFoundation;
import net.java.truecommons.key.macosx.keychain.Keychain;
import net.java.truecommons.key.macosx.keychain.KeychainException;
import net.java.truecommons.key.macosx.keychain.KeychainUtils;
import net.java.truecommons.key.macosx.keychain.Security;
import net.java.truecommons.shed.Buffers;

@ThreadSafe
final class KeychainImpl
extends Keychain {
    @CheckForNull
    private Security.SecKeychainRef ref;

    KeychainImpl() throws KeychainException {
        PointerByReference pr = new PointerByReference();
        KeychainImpl.check(Security.SecKeychainCopyDefault(pr));
        this.ref = new Security.SecKeychainRef(pr.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeychainImpl(String path, @CheckForNull char[] password) throws KeychainException {
        boolean prompt = null == password || 0 >= password.length;
        PointerByReference pr = new PointerByReference();
        ByteBuffer buffer = prompt ? null : Buffers.byteBuffer((char[])password);
        int length = prompt ? 0 : buffer.remaining();
        Class<KeychainImpl> clazz = KeychainImpl.class;
        synchronized (KeychainImpl.class) {
            int s = Security.SecKeychainCreate(path, length, buffer, prompt, null, pr);
            if (s == -25296) {
                s = Security.SecKeychainOpen(path, pr);
            }
            KeychainImpl.check(s);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this.ref = new Security.SecKeychainRef(pr.getValue());
            return;
        }
    }

    @Override
    public synchronized void createItem(Keychain.ItemClass id, Map<Keychain.AttributeClass, ByteBuffer> attributes, ByteBuffer secret) throws KeychainException {
        KeychainImpl.check(Security.SecKeychainItemCreateFromContent(id.getTag(), KeychainUtils.list(attributes), secret.remaining(), secret, this.ref(), null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void visitItems(@CheckForNull Keychain.ItemClass id, @CheckForNull Map<Keychain.AttributeClass, ByteBuffer> attributes, final Keychain.Visitor visitor) throws KeychainException {
        if (null == id) {
            id = Keychain.ItemClass.ANY_ITEM;
        }
        PointerByReference srr = new PointerByReference();
        KeychainImpl.check(Security.SecKeychainSearchCreateFromAttributes(this.ref(), id.getTag(), KeychainUtils.list(attributes), srr));
        final Security.SecKeychainSearchRef sr = new Security.SecKeychainSearchRef(srr.getValue());
        try {
            class Visit
            implements Callable<Void> {
                private final EnumMap<Keychain.ItemClass, Security.SecKeychainAttributeInfo> infos = new EnumMap(Keychain.ItemClass.class);

                Visit() {
                }

                Security.SecKeychainAttributeInfo info(Keychain.ItemClass id) {
                    Security.SecKeychainAttributeInfo info = this.infos.get((Object)id);
                    if (null != info) {
                        return info;
                    }
                    info = KeychainUtils.info(id.getAttributeClasses());
                    this.infos.put(id, info);
                    return info;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws KeychainException {
                    while (true) {
                        Security.SecKeychainItemRef ir;
                        PointerByReference irr = new PointerByReference();
                        int status = Security.SecKeychainSearchCopyNext(sr, irr);
                        switch (status) {
                            case -25300: {
                                return null;
                            }
                            case 0: {
                                ir = new Security.SecKeychainItemRef(irr.getValue());
                                break;
                            }
                            default: {
                                throw KeychainException.create(status);
                            }
                        }
                        try {
                            class ItemImpl
                            implements Keychain.Item {
                                private Keychain.ItemClass id;

                                ItemImpl() {
                                }

                                @Override
                                public Keychain.ItemClass getItemClass() throws KeychainException {
                                    Keychain.ItemClass id = this.id;
                                    if (null != id) {
                                        return id;
                                    }
                                    IntByReference cr = new IntByReference();
                                    KeychainImpl.check(Security.SecKeychainItemCopyAttributesAndData(ir, null, cr, null, null, null));
                                    int c = cr.getValue();
                                    this.id = id = Keychain.ItemClass.lookup(c);
                                    if (null == id) {
                                        throw (KeychainException)KeychainException.create(-4).initCause(new UnsupportedOperationException("Unknown class id: " + c));
                                    }
                                    return id;
                                }

                                @Override
                                @Nullable
                                public ByteBuffer getAttribute(Keychain.AttributeClass id) throws KeychainException {
                                    return this.getAttributes(KeychainUtils.info(id)).get((Object)id);
                                }

                                @Override
                                public void setAttribute(Keychain.AttributeClass id, @CheckForNull ByteBuffer value) throws KeychainException {
                                    EnumMap<Keychain.AttributeClass, ByteBuffer> attributes = new EnumMap<Keychain.AttributeClass, ByteBuffer>(Keychain.AttributeClass.class);
                                    attributes.put(id, value);
                                    this.putAttributeMap(attributes);
                                }

                                @Override
                                public Map<Keychain.AttributeClass, ByteBuffer> getAttributeMap() throws KeychainException {
                                    return this.getAttributes(this.info(this.getItemClass()));
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                private Map<Keychain.AttributeClass, ByteBuffer> getAttributes(Security.SecKeychainAttributeInfo info) throws KeychainException {
                                    PointerByReference ar = new PointerByReference();
                                    KeychainImpl.check(Security.SecKeychainItemCopyAttributesAndData(ir, info, null, ar, null, null));
                                    Security.SecKeychainAttributeList l = new Security.SecKeychainAttributeList(ar.getValue());
                                    try {
                                        l.read();
                                        Map<Keychain.AttributeClass, ByteBuffer> map = KeychainUtils.map(l);
                                        return map;
                                    }
                                    finally {
                                        Security.SecKeychainItemFreeAttributesAndData(l, null);
                                    }
                                }

                                @Override
                                public void putAttributeMap(Map<Keychain.AttributeClass, ByteBuffer> attributes) throws KeychainException {
                                    KeychainImpl.check(Security.SecKeychainItemModifyAttributesAndData(ir, KeychainUtils.list(Objects.requireNonNull(attributes)), 0, null));
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public ByteBuffer getSecret() throws KeychainException {
                                    IntByReference lr = new IntByReference();
                                    PointerByReference dr = new PointerByReference();
                                    KeychainImpl.check(Security.SecKeychainItemCopyAttributesAndData(ir, null, null, null, lr, dr));
                                    Pointer p = dr.getValue();
                                    try {
                                        long l = (long)lr.getValue() & 0xFFFFFFFFL;
                                        ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocateDirect((int)l).put(p.getByteBuffer(0L, l)).flip();
                                        return byteBuffer;
                                    }
                                    finally {
                                        Security.SecKeychainItemFreeAttributesAndData(null, p);
                                    }
                                }

                                @Override
                                public void setSecret(ByteBuffer secret) throws KeychainException {
                                    KeychainImpl.check(Security.SecKeychainItemModifyAttributesAndData(ir, null, secret.remaining(), secret));
                                }

                                @Override
                                public void delete() throws KeychainException {
                                    KeychainImpl.check(Security.SecKeychainItemDelete(ir));
                                }
                            }
                            visitor.visit(new ItemImpl());
                            continue;
                        }
                        finally {
                            CoreFoundation.CFRelease(ir);
                            continue;
                        }
                        break;
                    }
                }
            }
            new Visit().call();
        }
        finally {
            CoreFoundation.CFRelease(sr);
        }
    }

    @Override
    public synchronized void delete() throws KeychainException {
        KeychainImpl.check(Security.SecKeychainDelete(this.ref()));
        this.close();
    }

    private static void check(int status) throws KeychainException {
        if (0 != status) {
            throw KeychainException.create(status);
        }
    }

    private Security.SecKeychainRef ref() throws KeychainException {
        if (null == this.ref) {
            KeychainImpl.check(-25295);
        }
        return this.ref;
    }

    @Override
    public synchronized void close() {
        Security.SecKeychainRef ref = this.ref;
        if (null == ref) {
            return;
        }
        this.ref = null;
        CoreFoundation.CFRelease(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.close();
        }
    }
}

