/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx;

import java.util.Map;
import java.util.ServiceConfigurationError;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.annotations.ServiceImplementation;
import net.java.truecommons.key.macosx.OsxKeyManager;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.common.AesPbeParameters;
import net.java.truecommons.key.spec.spi.KeyManagerMapModifier;

@Immutable
@ServiceImplementation
public final class OsxAesPbeKeyManagerMapModifier
extends KeyManagerMapModifier {
    public Map<Class<?>, KeyManager<?>> apply(Map<Class<?>, KeyManager<?>> map) {
        if (!"Mac OS X".equals(System.getProperty("os.name"))) {
            return map;
        }
        KeyManager<?> m = map.get(AesPbeParameters.class);
        if (null == m) {
            throw new ServiceConfigurationError("This module is a pure persistence service and depends on another key manager module to implement the user interface.");
        }
        map.put(AesPbeParameters.class, (KeyManager<?>)new OsxKeyManager<AesPbeParameters>(m, AesPbeParameters.class));
        return map;
    }

    public int getPriority() {
        return -100;
    }
}

