/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.annotations.processing;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.java.truecommons.annotations.ServiceImplementation;
import net.java.truecommons.annotations.ServiceSpecification;
import net.java.truecommons.annotations.processing.ServiceProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"net.java.truecommons.annotations.verbose", "net.java.truecommons.annotations.processing.verbose"})
public final class ServiceImplementationProcessor
extends ServiceProcessor {
    private static final Comparator<TypeElement> TYPE_ELEMENT_COMPARATOR = new Comparator<TypeElement>(){

        @Override
        public int compare(TypeElement o1, TypeElement o2) {
            return o1.getQualifiedName().toString().compareTo(o2.getQualifiedName().toString());
        }
    };
    private boolean verbose;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Set<String> supported = this.getSupportedOptions();
        Map<String, String> present = processingEnv.getOptions();
        this.verbose = false;
        for (String option : supported) {
            this.verbose |= Boolean.parseBoolean(present.get(option));
        }
    }

    @Override
    boolean isDebugEnabled() {
        return this.verbose;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Registry registry = new Registry();
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceImplementation.class)) {
            TypeElement impl = (TypeElement)element;
            if (!this.valid(impl, impl) || this.processAnnotations(impl, registry) || this.processTypeHierarchy(impl, registry)) continue;
            this.error("Cannot find any specification.", impl);
        }
        registry.persist();
        return false;
    }

    boolean valid(TypeElement impl, Element loc) {
        Set<Modifier> modifiers = impl.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.ABSTRACT) || impl.getKind() != ElementKind.CLASS) {
            return this.error("Not a public and non-abstract class.", loc);
        }
        if (impl.getNestingKind().isNested() && !modifiers.contains((Object)Modifier.STATIC)) {
            return this.error("Impossible to instantiate without an instance of the enclosing class.", loc);
        }
        LinkedList<ExecutableElement> ctors = new LinkedList<ExecutableElement>();
        for (Element element : impl.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ctors.add((ExecutableElement)element);
        }
        return ctors.isEmpty() || this.valid(ctors) || this.error("No public constructor with zero parameters available.", loc);
    }

    private boolean valid(Collection<ExecutableElement> ctors) {
        for (ExecutableElement ctor : ctors) {
            if (!this.valid(ctor)) continue;
            return true;
        }
        return false;
    }

    private boolean valid(ExecutableElement ctor) {
        return ctor.getModifiers().contains((Object)Modifier.PUBLIC) && ctor.getParameters().isEmpty();
    }

    private boolean processAnnotations(final TypeElement impl, final Registry registry) {
        final DeclaredType implType = (DeclaredType)impl.asType();
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(impl)) {
            if (!ServiceImplementation.class.getName().equals(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                ExecutableElement element = entry.getKey();
                if (!"value".equals(element.getSimpleName().toString())) continue;
                class Visitor
                extends SimpleAnnotationValueVisitor6<Boolean, Void> {
                    Visitor() {
                        super(false);
                    }

                    @Override
                    public Boolean visitType(TypeMirror type, Void p) {
                        if (ServiceImplementationProcessor.this.processingEnv.getTypeUtils().isAssignable(implType, type)) {
                            registry.add(impl, (TypeElement)((DeclaredType)type).asElement());
                        } else {
                            ServiceImplementationProcessor.this.error("Unassignable to " + type + ".", impl);
                        }
                        return Boolean.TRUE;
                    }

                    @Override
                    public Boolean visitArray(List<? extends AnnotationValue> values, Void p) {
                        boolean found = false;
                        for (AnnotationValue annotationValue : values) {
                            found |= annotationValue.accept(this, p).booleanValue();
                        }
                        return found;
                    }
                }
                return entry.getValue().accept(new Visitor(), null);
            }
        }
        return false;
    }

    private boolean processTypeHierarchy(final TypeElement impl, final Registry registry) {
        class Visitor
        extends SimpleTypeVisitor6<Boolean, Void> {
            Visitor() {
                super(false);
            }

            @Override
            public Boolean visitDeclared(DeclaredType type, Void p) {
                boolean found = false;
                TypeElement elem = (TypeElement)type.asElement();
                if (null != elem.getAnnotation(ServiceSpecification.class)) {
                    found = true;
                    registry.add(impl, elem);
                }
                for (TypeMirror typeMirror : elem.getInterfaces()) {
                    found |= typeMirror.accept(this, p).booleanValue();
                }
                return elem.getSuperclass().accept(this, p) != false || found;
            }
        }
        return impl.asType().accept(new Visitor(), null);
    }

    private final class Registry {
        final Elements elements;
        final Map<TypeElement, Collection<TypeElement>> services;

        private Registry() {
            this.elements = ServiceImplementationProcessor.this.processingEnv.getElementUtils();
            this.services = new HashMap<TypeElement, Collection<TypeElement>>();
        }

        void add(TypeElement impl, TypeElement spec) {
            Collection<TypeElement> coll = this.services.get(spec);
            if (null == coll) {
                coll = new TreeSet<TypeElement>(TYPE_ELEMENT_COMPARATOR);
            }
            coll.add(impl);
            this.services.put(spec, coll);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void persist() {
            Filer filer = ServiceImplementationProcessor.this.processingEnv.getFiler();
            Messager messager = ServiceImplementationProcessor.this.getMessager();
            for (Map.Entry<TypeElement, Collection<TypeElement>> entry : this.services.entrySet()) {
                TypeElement spec = entry.getKey();
                Collection<TypeElement> coll = entry.getValue();
                if (coll.isEmpty()) continue;
                String path = "META-INF/services/" + this.name(spec);
                try {
                    FileObject fo = filer.createResource(StandardLocation.CLASS_OUTPUT, "", path, new Element[0]);
                    try (Writer w = fo.openWriter();){
                        for (TypeElement impl : coll) {
                            w.append(this.name(impl)).append("\n");
                            ServiceImplementationProcessor.this.debug(String.format("Registered at: %s", path), impl);
                        }
                    }
                }
                catch (IOException ex) {
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("Failed to register %d service implementation class(es) at: %s: %s", coll.size(), path, ex.getMessage()));
                }
            }
        }

        CharSequence name(TypeElement elem) {
            return this.elements.getBinaryName(elem);
        }
    }
}

