/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.ObjectType;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.OptionProcessor;
import io.timeandspace.jpsg.PrimitiveType;
import io.timeandspace.jpsg.PrimitiveTypeModifierPreProcessor;
import io.timeandspace.jpsg.TemplateProcessor;
import java.util.Map;

public final class RawModifierProcessor
extends TemplateProcessor {
    public static final int PRIORITY = PrimitiveTypeModifierPreProcessor.getPRIORITY() + 10;
    private static final String RAW = OptionProcessor.modifier("raw");

    @Override
    protected int priority() {
        return PRIORITY;
    }

    @Override
    protected void process(StringBuilder sb, Context source, Context target, String template) {
        for (Map.Entry<String, Option> e : source) {
            String dim = e.getKey();
            if (!(e.getValue() instanceof PrimitiveType) || !(target.getOption(dim) instanceof ObjectType)) continue;
            PrimitiveType sourceT = (PrimitiveType)e.getValue();
            String rawP = OptionProcessor.prefixPattern(RAW, "(" + sourceT.className + "|" + sourceT.standalone + ")");
            template = template.replaceAll(rawP, "Object");
        }
        template = template.replaceAll(RAW, "");
        this.postProcess(sb, source, target, template);
    }
}

