/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.CheckingMatcher;
import io.timeandspace.jpsg.CheckingPattern;
import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.PrimitiveType;
import io.timeandspace.jpsg.TemplateProcessor;
import java.util.HashMap;
import java.util.Map;

public final class FloatingWrappingProcessor
extends TemplateProcessor {
    private static final String WRAPPING_PREFIX = "/[*/]\\s*(?<op>wrap|unwrap|unwrapRaw)";
    private static final CheckingPattern WRAPPING_P = CheckingPattern.compile("/[*/]\\s*(?<op>wrap|unwrap|unwrapRaw)", "/[*/]\\s*(?<op>wrap|unwrap|unwrapRaw)\\s+(?<dim>\\w+)\\s*[*/]/((?<closed>(?<closedBody>[^/]+)/[*/][*/]/)|(?<openBody>[^\\s\\{\\};/*]+))");
    private static final Map<String, String> opsToFloatMethods = new HashMap<String, String>();
    private static final Map<String, String> opsToDoubleMethods = new HashMap<String, String>();

    @Override
    protected void process(StringBuilder builder, Context source, Context target, String template) {
        StringBuilder sb = new StringBuilder();
        CheckingMatcher m = WRAPPING_P.matcher(template);
        while (m.find()) {
            String body = m.group(m.group("closed") != null ? "closedBody" : "openBody");
            Option targetType = target.getOption(m.group("dim"));
            String repl = body;
            if (targetType == PrimitiveType.FLOAT) {
                repl = "Float." + opsToFloatMethods.get(m.group("op")) + "(" + repl + ")";
            } else if (targetType == PrimitiveType.DOUBLE) {
                repl = "Double." + opsToDoubleMethods.get(m.group("op")) + "(" + repl + ")";
            }
            m.appendSimpleReplacement(sb, repl);
        }
        m.appendTail(sb);
        this.postProcess(builder, source, target, sb.toString());
    }

    static {
        opsToFloatMethods.put("wrap", "intBitsToFloat");
        opsToFloatMethods.put("unwrap", "floatToIntBits");
        opsToFloatMethods.put("unwrapRaw", "floatToRawIntBits");
        opsToDoubleMethods.put("wrap", "longBitsToDouble");
        opsToDoubleMethods.put("unwrap", "doubleToLongBits");
        opsToDoubleMethods.put("unwrapRaw", "doubleToRawLongBits");
    }
}

