/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.CheckingMatcher;
import io.timeandspace.jpsg.CheckingPattern;
import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.Generator;
import io.timeandspace.jpsg.MalformedTemplateException;
import io.timeandspace.jpsg.TemplateProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public final class DefinitionProcessor
extends TemplateProcessor {
    public static final int PRIORITY = 200;
    private static final String DEF_PREFIX = "/[*/]\\s*define";
    private static final CheckingPattern DEF_P = CheckingPattern.compile("/[*/]\\s*define", "/[*/]\\s*define\\s+(?<name>\\w+)(\\s+(?<param>\\w+))?\\s*[*/]/(?<body>.+?)/[*/]\\s*enddefine\\s*[*/]/");
    private static final Definition COMMENT_DEFINITION = new Definition("comment", "");

    static CheckingPattern makeDefinitionUsePattern(String definitionName) {
        String defPrefix = "/[*/]\\s*" + definitionName + "\\b";
        return CheckingPattern.compile(defPrefix, defPrefix + "(\\s++(?<argument>[^/* ]+)\\s*+|\\s*+)[*/]/(([^/]+?)/[*/][*/]/)?+", 40);
    }

    @Override
    protected int priority() {
        return 200;
    }

    @Override
    protected void process(StringBuilder builder, Context source, Context target, String template) {
        CheckingMatcher matcher = DEF_P.matcher(template);
        StringBuilder sb = new StringBuilder();
        Map<String, Definition> definitions = this.makeDefaultDefinitions();
        while (matcher.find()) {
            String defName = matcher.group("name");
            if (definitions.containsKey(defName)) {
                throw MalformedTemplateException.near(template, matcher.start(), "Definition with name " + defName + " already exists in this context");
            }
            definitions.put(defName, new Definition(template, matcher));
            matcher.appendSimpleReplacement(sb, "");
        }
        matcher.appendTail(sb);
        String withoutDefinitions = this.replaceDefinitions(definitions, source, target, sb.toString());
        this.postProcess(builder, source, target, withoutDefinitions);
    }

    private Map<String, Definition> makeDefaultDefinitions() {
        HashMap<String, Definition> definitions = new HashMap<String, Definition>(4);
        definitions.put("comment", COMMENT_DEFINITION);
        return definitions;
    }

    private String replaceDefinitions(Map<String, Definition> definitions, Context source, Context target, String template) {
        for (Map.Entry<String, Definition> e : definitions.entrySet()) {
            String defName = e.getKey();
            Definition definition = e.getValue();
            String bodyWithoutNestedDefinitions = this.replaceDefinitions(this.without(definitions, defName), source, target, definition.body);
            if (defName.equals("ClassName")) {
                String className = this.postGenerate(source, target, bodyWithoutNestedDefinitions).trim();
                Generator.setRedefinedClassName(className);
            }
            CheckingPattern defUsePattern = DefinitionProcessor.makeDefinitionUsePattern(defName);
            CheckingMatcher defUseMatcher = defUsePattern.matcher(template);
            StringBuilder sb = new StringBuilder();
            while (defUseMatcher.find()) {
                String replacement = definition.replaceParameter(bodyWithoutNestedDefinitions, template, defUseMatcher);
                defUseMatcher.appendSimpleReplacement(sb, replacement);
            }
            defUseMatcher.appendTail(sb);
            template = sb.toString();
        }
        return template;
    }

    private Map<String, Definition> without(Map<String, Definition> definitions, String defName) {
        HashMap<String, Definition> definitionsWithout = new HashMap<String, Definition>(definitions);
        definitionsWithout.remove(defName);
        return definitionsWithout;
    }

    private String postGenerate(Context source, Context target, String template) {
        StringBuilder sb = new StringBuilder();
        this.postProcess(sb, source, target, template);
        return sb.toString();
    }

    private static class Definition {
        private final String name;
        private final String body;
        @Nullable
        private final String param;

        Definition(String template, CheckingMatcher defineMatcher) {
            this.name = defineMatcher.group("name");
            if (this.name == null) {
                throw new AssertionError();
            }
            this.body = defineMatcher.group("body").trim();
            this.param = defineMatcher.group("param");
            if (this.name.equals("ClassName") && this.param != null) {
                throw MalformedTemplateException.near(template, defineMatcher.start(), "ClassName must not have a parameter, " + this.param + " specified");
            }
        }

        Definition(String name, String body) {
            this.name = name;
            this.body = body;
            this.param = null;
        }

        String replaceParameter(String bodyWithoutNestedDefinitions, String template, CheckingMatcher definitionUseMatcher) {
            String argument = definitionUseMatcher.group("argument");
            if (this.param != null && argument == null) {
                throw MalformedTemplateException.near(template, definitionUseMatcher.start(), "Definition " + this.name + " requires an argument " + this.param);
            }
            if (this.param == null && argument != null) {
                throw MalformedTemplateException.near(template, definitionUseMatcher.start(), "Definition " + this.name + " don't have a parameter, " + argument + " given");
            }
            if (this.param == null) {
                return bodyWithoutNestedDefinitions;
            }
            String paramRegex = "\\b" + Pattern.quote(this.param) + "\\b";
            return bodyWithoutNestedDefinitions.replaceAll(paramRegex, argument);
        }
    }
}

